/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hadoop.HadoopFileStatus;
import com.facebook.presto.hive.ConcurrentLazyQueue;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.hive.util.HiveFileIterator;
import com.facebook.presto.hive.util.ResumableTask;
import com.facebook.presto.hive.util.ResumableTasks;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import io.airlift.slice.Slices;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;

public class BackgroundHiveSplitLoader
implements HiveSplitLoader {
    private static final String CORRUPT_BUCKETING = "Hive table is corrupt. It is declared as being bucketed, but the files do not match the bucketing declaration.";
    public static final CompletableFuture<?> COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    private final Table table;
    private final TupleDomain<? extends ColumnHandle> compactEffectivePredicate;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final List<HiveBucketing.HiveBucket> buckets;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final int loaderConcurrency;
    private final boolean recursiveDirWalkerEnabled;
    private final Executor executor;
    private final ConnectorSession session;
    private final ConcurrentLazyQueue<HivePartitionMetadata> partitions;
    private final Deque<HiveFileIterator> fileIterators = new ConcurrentLinkedDeque<HiveFileIterator>();
    private final ReentrantReadWriteLock taskExecutionLock = new ReentrantReadWriteLock();
    private HiveSplitSource hiveSplitSource;
    private volatile boolean stopped;

    public BackgroundHiveSplitLoader(Table table, Iterable<HivePartitionMetadata> partitions, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, Optional<HiveBucketHandle> bucketHandle, List<HiveBucketing.HiveBucket> buckets, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int loaderConcurrency, boolean recursiveDirWalkerEnabled) {
        this.table = table;
        this.compactEffectivePredicate = compactEffectivePredicate;
        this.bucketHandle = bucketHandle;
        this.buckets = buckets;
        this.loaderConcurrency = loaderConcurrency;
        this.session = session;
        this.hdfsEnvironment = hdfsEnvironment;
        this.namenodeStats = namenodeStats;
        this.directoryLister = directoryLister;
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.executor = executor;
        this.partitions = new ConcurrentLazyQueue<HivePartitionMetadata>(partitions);
        this.hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
    }

    @Override
    public void start(HiveSplitSource splitSource) {
        this.hiveSplitSource = splitSource;
        for (int i = 0; i < this.loaderConcurrency; ++i) {
            ResumableTasks.submit(this.executor, new HiveSplitLoaderTask());
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private void invokeNoMoreSplitsIfNecessary() {
        if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
            this.taskExecutionLock.writeLock().lock();
            try {
                if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
                    this.hiveSplitSource.noMoreSplits();
                }
            }
            finally {
                this.taskExecutionLock.writeLock().unlock();
            }
        }
    }

    private CompletableFuture<?> loadSplits() throws IOException {
        HiveFileIterator files = this.fileIterators.poll();
        if (files == null) {
            HivePartitionMetadata partition = this.partitions.poll();
            if (partition == null) {
                return COMPLETED_FUTURE;
            }
            return this.loadPartition(partition);
        }
        while (files.hasNext() && !this.stopped) {
            CompletableFuture<?> future;
            LocatedFileStatus file = (LocatedFileStatus)files.next();
            if (HadoopFileStatus.isDirectory((FileStatus)file)) {
                if (!this.recursiveDirWalkerEnabled) continue;
                HiveFileIterator fileIterator = new HiveFileIterator(file.getPath(), files.getFileSystem(), files.getDirectoryLister(), files.getNamenodeStats(), files.getPartitionName(), files.getInputFormat(), files.getSchema(), files.getPartitionKeys(), files.getEffectivePredicate(), files.getColumnCoercions());
                this.fileIterators.add(fileIterator);
                continue;
            }
            boolean splittable = HiveUtil.isSplittable(files.getInputFormat(), this.hdfsEnvironment.getFileSystem(this.hdfsContext, file.getPath()), file.getPath());
            Optional<InternalHiveSplit> internalHiveSplit = this.createInternalHiveSplit(files.getPartitionName(), file.getPath().toString(), file.getBlockLocations(), 0L, file.getLen(), file.getLen(), files.getSchema(), files.getPartitionKeys(), splittable, this.session, OptionalInt.empty(), files.getColumnCoercions(), BackgroundHiveSplitLoader.getPathDomain(files.getEffectivePredicate()));
            if (!internalHiveSplit.isPresent() || (future = this.hiveSplitSource.addToQueue(internalHiveSplit.get())).isDone()) continue;
            this.fileIterators.addFirst(files);
            return future;
        }
        return COMPLETED_FUTURE;
    }

    private CompletableFuture<?> loadPartition(HivePartitionMetadata partition) throws IOException {
        String partitionName = partition.getHivePartition().getPartitionId();
        Properties schema = BackgroundHiveSplitLoader.getPartitionSchema(this.table, partition.getPartition());
        List<HivePartitionKey> partitionKeys = BackgroundHiveSplitLoader.getPartitionKeys(this.table, partition.getPartition());
        TupleDomain<? extends ColumnHandle> effectivePredicate = this.compactEffectivePredicate;
        Optional<Domain> pathDomain = BackgroundHiveSplitLoader.getPathDomain(effectivePredicate);
        Path path = new Path(BackgroundHiveSplitLoader.getPartitionLocation(this.table, partition.getPartition()));
        Configuration configuration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, path);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, schema, false);
        FileSystem fs = this.hdfsEnvironment.getFileSystem(this.hdfsContext, path);
        if (inputFormat instanceof SymlinkTextInputFormat) {
            if (this.bucketHandle.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketed table in SymlinkTextInputFormat is not yet supported");
            }
            CompletableFuture<?> lastResult = COMPLETED_FUTURE;
            for (Path targetPath : BackgroundHiveSplitLoader.getTargetPathsFromSymlink(fs, path)) {
                TextInputFormat targetInputFormat = new TextInputFormat();
                Configuration targetConfiguration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, targetPath);
                JobConf targetJob = ConfigurationUtils.toJobConf(targetConfiguration);
                targetJob.setInputFormat(TextInputFormat.class);
                targetInputFormat.configure(targetJob);
                FileInputFormat.setInputPaths((JobConf)targetJob, (Path[])new Path[]{targetPath});
                InputSplit[] targetSplits = targetInputFormat.getSplits(targetJob, 0);
                lastResult = this.addSplitsToSource(targetSplits, partitionName, partitionKeys, schema, effectivePredicate, partition.getColumnCoercions(), pathDomain);
                if (!this.stopped) continue;
                return COMPLETED_FUTURE;
            }
            return lastResult;
        }
        if (BackgroundHiveSplitLoader.shouldUseFileSplitsFromInputFormat(inputFormat)) {
            JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
            InputSplit[] splits = inputFormat.getSplits(jobConf, 0);
            return this.addSplitsToSource(splits, partitionName, partitionKeys, schema, effectivePredicate, partition.getColumnCoercions(), pathDomain);
        }
        HiveFileIterator iterator = new HiveFileIterator(path, fs, this.directoryLister, this.namenodeStats, partitionName, inputFormat, schema, partitionKeys, effectivePredicate, partition.getColumnCoercions());
        if (!this.buckets.isEmpty()) {
            int bucketCount = this.buckets.get(0).getBucketCount();
            List<LocatedFileStatus> fileList = BackgroundHiveSplitLoader.listAndSortBucketFiles(iterator, bucketCount);
            ArrayList splitList = new ArrayList();
            for (HiveBucketing.HiveBucket bucket : this.buckets) {
                int bucketNumber = bucket.getBucketNumber();
                LocatedFileStatus file = fileList.get(bucketNumber);
                boolean splittable = HiveUtil.isSplittable(iterator.getInputFormat(), this.hdfsEnvironment.getFileSystem(this.hdfsContext, file.getPath()), file.getPath());
                Optional<InternalHiveSplit> internalHiveSplit = this.createInternalHiveSplit(iterator.getPartitionName(), file.getPath().toString(), file.getBlockLocations(), 0L, file.getLen(), file.getLen(), iterator.getSchema(), iterator.getPartitionKeys(), splittable, this.session, OptionalInt.of(bucketNumber), partition.getColumnCoercions(), pathDomain);
                internalHiveSplit.ifPresent(splitList::add);
            }
            return this.hiveSplitSource.addToQueue(splitList);
        }
        if (this.bucketHandle.isPresent()) {
            int bucketCount = this.bucketHandle.get().getBucketCount();
            List<LocatedFileStatus> list = BackgroundHiveSplitLoader.listAndSortBucketFiles(iterator, bucketCount);
            ArrayList splitList = new ArrayList();
            for (int bucketIndex = 0; bucketIndex < bucketCount; ++bucketIndex) {
                LocatedFileStatus file = list.get(bucketIndex);
                boolean splittable = HiveUtil.isSplittable(iterator.getInputFormat(), this.hdfsEnvironment.getFileSystem(this.hdfsContext, file.getPath()), file.getPath());
                Optional<InternalHiveSplit> internalHiveSplit = this.createInternalHiveSplit(iterator.getPartitionName(), file.getPath().toString(), file.getBlockLocations(), 0L, file.getLen(), file.getLen(), iterator.getSchema(), iterator.getPartitionKeys(), splittable, this.session, OptionalInt.of(bucketIndex), partition.getColumnCoercions(), pathDomain);
                internalHiveSplit.ifPresent(splitList::add);
            }
            return this.hiveSplitSource.addToQueue(splitList);
        }
        this.fileIterators.addLast(iterator);
        return COMPLETED_FUTURE;
    }

    private CompletableFuture<?> addSplitsToSource(InputSplit[] targetSplits, String partitionName, List<HivePartitionKey> partitionKeys, Properties schema, TupleDomain<HiveColumnHandle> effectivePredicate, Map<Integer, HiveTypeName> columnCoercions, Optional<Domain> pathDomain) throws IOException {
        CompletableFuture<?> lastResult = COMPLETED_FUTURE;
        for (InputSplit inputSplit : targetSplits) {
            FileSplit split = (FileSplit)inputSplit;
            FileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, split.getPath());
            FileStatus file = targetFilesystem.getFileStatus(split.getPath());
            Optional<InternalHiveSplit> internalHiveSplit = this.createInternalHiveSplit(partitionName, file.getPath().toString(), targetFilesystem.getFileBlockLocations(file, split.getStart(), split.getLength()), split.getStart(), split.getLength(), file.getLen(), schema, partitionKeys, false, this.session, OptionalInt.empty(), columnCoercions, pathDomain);
            if (internalHiveSplit.isPresent()) {
                lastResult = this.hiveSplitSource.addToQueue(internalHiveSplit.get());
            }
            if (!this.stopped) continue;
            return COMPLETED_FUTURE;
        }
        return lastResult;
    }

    private static boolean shouldUseFileSplitsFromInputFormat(InputFormat<?, ?> inputFormat) {
        return Arrays.stream(inputFormat.getClass().getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch(name -> name.equals("UseFileSplitsFromInputFormat"));
    }

    private static List<LocatedFileStatus> listAndSortBucketFiles(HiveFileIterator hiveFileIterator, int bucketCount) {
        ArrayList<LocatedFileStatus> list = new ArrayList<LocatedFileStatus>(bucketCount);
        while (hiveFileIterator.hasNext()) {
            LocatedFileStatus next = (LocatedFileStatus)hiveFileIterator.next();
            if (HadoopFileStatus.isDirectory((FileStatus)next)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("%s Found sub-directory in bucket directory for partition: %s", CORRUPT_BUCKETING, hiveFileIterator.getPartitionName()));
            }
            list.add(next);
        }
        if (list.size() != bucketCount) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("%s The number of files in the directory (%s) does not match the declared bucket count (%s) for partition: %s", CORRUPT_BUCKETING, list.size(), bucketCount, hiveFileIterator.getPartitionName()));
        }
        list.sort(null);
        return list;
    }

    private static List<Path> getTargetPathsFromSymlink(FileSystem fileSystem, Path symlinkDir) {
        try {
            FileStatus[] symlinks = fileSystem.listStatus(symlinkDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            ArrayList<Path> targets = new ArrayList<Path>();
            for (FileStatus symlink : symlinks) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath()), StandardCharsets.UTF_8));){
                    CharStreams.readLines((Readable)reader).stream().map(Path::new).forEach(targets::add);
                }
            }
            return targets;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Error parsing symlinks from: " + symlinkDir, (Throwable)e);
        }
    }

    private Optional<InternalHiveSplit> createInternalHiveSplit(String partitionName, String path, BlockLocation[] blockLocations, long start, long length, long fileSize, Properties schema, List<HivePartitionKey> partitionKeys, boolean splittable, ConnectorSession session, OptionalInt bucketNumber, Map<Integer, HiveTypeName> columnCoercions, Optional<Domain> pathDomain) throws IOException {
        if (!BackgroundHiveSplitLoader.pathMatchesPredicate(pathDomain, path)) {
            return Optional.empty();
        }
        boolean forceLocalScheduling = HiveSessionProperties.isForceLocalScheduling(session);
        if (fileSize == 0L && blockLocations.length == 0) {
            blockLocations = new BlockLocation[]{new BlockLocation()};
            forceLocalScheduling = false;
        }
        ImmutableList.Builder blockBuilder = ImmutableList.builder();
        for (BlockLocation blockLocation : blockLocations) {
            long blockEnd;
            long blockStart = Math.max(start, blockLocation.getOffset());
            if (blockStart > (blockEnd = Math.min(start + length, blockLocation.getOffset() + blockLocation.getLength())) || blockStart == blockEnd && (blockStart != start || blockEnd != start + length)) continue;
            blockBuilder.add((Object)new InternalHiveSplit.InternalHiveBlock(blockStart, blockEnd, BackgroundHiveSplitLoader.getHostAddresses(blockLocation)));
        }
        ImmutableList blocks = blockBuilder.build();
        BackgroundHiveSplitLoader.checkBlocks((List<InternalHiveSplit.InternalHiveBlock>)blocks, start, length);
        if (!splittable) {
            blocks = ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(start, start + length, ((InternalHiveSplit.InternalHiveBlock)blocks.get(0)).getAddresses()));
        }
        return Optional.of(new InternalHiveSplit(partitionName, path, start, start + length, fileSize, schema, partitionKeys, (List<InternalHiveSplit.InternalHiveBlock>)blocks, bucketNumber, splittable, forceLocalScheduling && BackgroundHiveSplitLoader.allBlocksHaveRealAddress((List<InternalHiveSplit.InternalHiveBlock>)blocks), columnCoercions));
    }

    private static void checkBlocks(List<InternalHiveSplit.InternalHiveBlock> blocks, long start, long length) {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((start == blocks.get(0).getStart() ? 1 : 0) != 0);
        Preconditions.checkArgument((start + length == blocks.get(blocks.size() - 1).getEnd() ? 1 : 0) != 0);
        for (int i = 1; i < blocks.size(); ++i) {
            Preconditions.checkArgument((blocks.get(i - 1).getEnd() == blocks.get(i).getStart() ? 1 : 0) != 0);
        }
    }

    private static boolean allBlocksHaveRealAddress(List<InternalHiveSplit.InternalHiveBlock> blocks) {
        return blocks.stream().map(InternalHiveSplit.InternalHiveBlock::getAddresses).allMatch(BackgroundHiveSplitLoader::hasRealAddress);
    }

    private static boolean hasRealAddress(List<HostAddress> addresses) {
        return addresses.stream().anyMatch(address -> !address.getHostText().equals("localhost"));
    }

    private static List<HostAddress> getHostAddresses(BlockLocation blockLocation) {
        String[] hosts;
        try {
            hosts = blockLocation.getHosts();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (List)Arrays.stream(hosts).map(HostAddress::fromString).collect(ImmutableList.toImmutableList());
    }

    private static List<HivePartitionKey> getPartitionKeys(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List<Column> keys = table.getPartitionColumns();
        List<String> values = partition.get().getValues();
        HiveUtil.checkCondition(keys.size() == values.size(), HiveErrorCode.HIVE_INVALID_METADATA, "Expected %s partition key values, but got %s", keys.size(), values.size());
        for (int i = 0; i < keys.size(); ++i) {
            String name = keys.get(i).getName();
            HiveType hiveType = keys.get(i).getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            String value = values.get(i);
            HiveUtil.checkCondition(value != null, HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "partition key value cannot be null for field: %s", name);
            partitionKeys.add((Object)new HivePartitionKey(name, value));
        }
        return partitionKeys.build();
    }

    private static Properties getPartitionSchema(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return MetastoreUtil.getHiveSchema(table);
        }
        return MetastoreUtil.getHiveSchema(partition.get(), table);
    }

    private static String getPartitionLocation(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return table.getStorage().getLocation();
        }
        return partition.get().getStorage().getLocation();
    }

    private static Optional<Domain> getPathDomain(TupleDomain<HiveColumnHandle> effectivePredicate) {
        if (!effectivePredicate.getDomains().isPresent()) {
            return Optional.empty();
        }
        return ((Map)effectivePredicate.getDomains().get()).entrySet().stream().filter(entry -> HiveColumnHandle.isPathColumnHandle((HiveColumnHandle)entry.getKey())).findFirst().map(Map.Entry::getValue);
    }

    private static boolean pathMatchesPredicate(Optional<Domain> pathDomain, String path) {
        if (!pathDomain.isPresent()) {
            return true;
        }
        return pathDomain.get().includesNullableValue((Object)Slices.utf8Slice((String)path));
    }

    private class HiveSplitLoaderTask
    implements ResumableTask {
        private HiveSplitLoaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResumableTask.TaskStatus process() {
            CompletableFuture future;
            do {
                if (BackgroundHiveSplitLoader.this.stopped) {
                    return ResumableTask.TaskStatus.finished();
                }
                BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().lock();
                try {
                    future = BackgroundHiveSplitLoader.this.loadSplits();
                }
                catch (Exception e) {
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e);
                    Preconditions.checkState((boolean)BackgroundHiveSplitLoader.this.stopped);
                    ResumableTask.TaskStatus taskStatus = ResumableTask.TaskStatus.finished();
                    return taskStatus;
                }
                finally {
                    BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().unlock();
                }
                BackgroundHiveSplitLoader.this.invokeNoMoreSplitsIfNecessary();
            } while (future.isDone());
            return ResumableTask.TaskStatus.continueOn(future);
        }
    }
}

