/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.statistics.MetastoreHiveStatisticsProvider;
import com.facebook.presto.spi.type.TypeManager;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.joda.time.DateTimeZone;

public class HiveMetadataFactory {
    private static final Logger log = Logger.get(HiveMetadataFactory.class);
    private final boolean allowCorruptWritesForTesting;
    private final boolean respectTableFormat;
    private final boolean bucketWritingEnabled;
    private final boolean skipDeletionForAlter;
    private final boolean writesToNonManagedTablesEnabled;
    private final HiveStorageFormat defaultStorageFormat;
    private final long perTransactionCacheMaximumSize;
    private final ExtendedHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final DateTimeZone timeZone;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final TableParameterCodec tableParameterCodec;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final BoundedExecutor renameExecution;
    private final TypeTranslator typeTranslator;
    private final String prestoVersion;

    @Inject
    public HiveMetadataFactory(HiveClientConfig hiveClientConfig, ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, @ForHiveClient ExecutorService executorService, TypeManager typeManager, LocationService locationService, TableParameterCodec tableParameterCodec, JsonCodec<PartitionUpdate> partitionUpdateCodec, TypeTranslator typeTranslator, NodeVersion nodeVersion) {
        this(metastore, hdfsEnvironment, partitionManager, hiveClientConfig.getDateTimeZone(), hiveClientConfig.getMaxConcurrentFileRenames(), hiveClientConfig.getAllowCorruptWritesForTesting(), hiveClientConfig.isRespectTableFormat(), hiveClientConfig.isSkipDeletionForAlter(), hiveClientConfig.isBucketWritingEnabled(), hiveClientConfig.getWritesToNonManagedTablesEnabled(), hiveClientConfig.getHiveStorageFormat(), hiveClientConfig.getPerTransactionMetastoreCacheMaximumSize(), typeManager, locationService, tableParameterCodec, partitionUpdateCodec, executorService, typeTranslator, nodeVersion.toString());
    }

    public HiveMetadataFactory(ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, DateTimeZone timeZone, int maxConcurrentFileRenames, boolean allowCorruptWritesForTesting, boolean respectTableFormat, boolean skipDeletionForAlter, boolean bucketWritingEnabled, boolean writesToNonManagedTablesEnabled, HiveStorageFormat defaultStorageFormat, long perTransactionCacheMaximumSize, TypeManager typeManager, LocationService locationService, TableParameterCodec tableParameterCodec, JsonCodec<PartitionUpdate> partitionUpdateCodec, ExecutorService executorService, TypeTranslator typeTranslator, String prestoVersion) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.respectTableFormat = respectTableFormat;
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.bucketWritingEnabled = bucketWritingEnabled;
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.defaultStorageFormat = Objects.requireNonNull(defaultStorageFormat, "defaultStorageFormat is null");
        this.perTransactionCacheMaximumSize = perTransactionCacheMaximumSize;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.tableParameterCodec = Objects.requireNonNull(tableParameterCodec, "tableParameterCodec is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        if (!allowCorruptWritesForTesting && !timeZone.equals((Object)DateTimeZone.getDefault())) {
            log.warn("Hive writes are disabled. To write data to Hive, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments", new Object[]{timeZone.getID()});
        }
        this.renameExecution = new BoundedExecutor((Executor)executorService, maxConcurrentFileRenames);
    }

    public HiveMetadata create() {
        SemiTransactionalHiveMetastore metastore = new SemiTransactionalHiveMetastore(this.hdfsEnvironment, CachingHiveMetastore.memoizeMetastore(this.metastore, this.perTransactionCacheMaximumSize), (Executor)this.renameExecution, this.skipDeletionForAlter);
        return new HiveMetadata(metastore, this.hdfsEnvironment, this.partitionManager, this.timeZone, this.allowCorruptWritesForTesting, this.respectTableFormat, this.bucketWritingEnabled, this.writesToNonManagedTablesEnabled, this.defaultStorageFormat, this.typeManager, this.locationService, this.tableParameterCodec, this.partitionUpdateCodec, this.typeTranslator, this.prestoVersion, new MetastoreHiveStatisticsProvider(this.typeManager, metastore));
    }
}

