/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCoercionRecordCursor;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePageSource;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public class HivePageSourceProvider
implements ConnectorPageSourceProvider {
    private final DateTimeZone hiveStorageTimeZone;
    private final HdfsEnvironment hdfsEnvironment;
    private final Set<HiveRecordCursorProvider> cursorProviders;
    private final TypeManager typeManager;
    private final Set<HivePageSourceFactory> pageSourceFactories;

    @Inject
    public HivePageSourceProvider(HiveClientConfig hiveClientConfig, HdfsEnvironment hdfsEnvironment, Set<HiveRecordCursorProvider> cursorProviders, Set<HivePageSourceFactory> pageSourceFactories, TypeManager typeManager) {
        Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        this.hiveStorageTimeZone = hiveClientConfig.getDateTimeZone();
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.cursorProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(cursorProviders, "cursorProviders is null"));
        this.pageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(pageSourceFactories, "pageSourceFactories is null"));
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        List<HiveColumnHandle> hiveColumns = columns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList());
        HiveSplit hiveSplit = (HiveSplit)split;
        Path path = new Path(hiveSplit.getPath());
        Optional<ConnectorPageSource> pageSource = HivePageSourceProvider.createHivePageSource(this.cursorProviders, this.pageSourceFactories, this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, hiveSplit.getDatabase(), hiveSplit.getTable()), path), session, path, hiveSplit.getBucketNumber(), hiveSplit.getStart(), hiveSplit.getLength(), hiveSplit.getFileSize(), hiveSplit.getSchema(), hiveSplit.getEffectivePredicate(), hiveColumns, hiveSplit.getPartitionKeys(), this.hiveStorageTimeZone, this.typeManager, hiveSplit.getColumnCoercions());
        if (pageSource.isPresent()) {
            return pageSource.get();
        }
        throw new RuntimeException("Could not find a file reader for split " + hiveSplit);
    }

    public static Optional<ConnectorPageSource> createHivePageSource(Set<HiveRecordCursorProvider> cursorProviders, Set<HivePageSourceFactory> pageSourceFactories, Configuration configuration, ConnectorSession session, Path path, OptionalInt bucketNumber, long start, long length, long fileSize, Properties schema, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> hiveColumns, List<HivePartitionKey> partitionKeys, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, Map<Integer, HiveType> columnCoercions) {
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(partitionKeys, hiveColumns, columnCoercions, path, bucketNumber);
        List<ColumnMapping> regularColumnMappings = ColumnMapping.extractRegularColumnMappings(columnMappings);
        for (HivePageSourceFactory pageSourceFactory : pageSourceFactories) {
            Optional<? extends ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(configuration, session, path, start, length, fileSize, schema, ColumnMapping.extractRegularColumnHandles(regularColumnMappings, true), effectivePredicate, hiveStorageTimeZone);
            if (!pageSource.isPresent()) continue;
            return Optional.of(new HivePageSource(columnMappings, hiveStorageTimeZone, typeManager, pageSource.get()));
        }
        Iterator<Object> iterator = cursorProviders.iterator();
        while (iterator.hasNext()) {
            HiveRecordCursorProvider provider;
            boolean doCoercion = !((provider = (HiveRecordCursorProvider)iterator.next()) instanceof GenericHiveRecordCursorProvider);
            Optional<RecordCursor> cursor = provider.createRecordCursor(configuration, session, path, start, length, fileSize, schema, ColumnMapping.extractRegularColumnHandles(regularColumnMappings, doCoercion), effectivePredicate, hiveStorageTimeZone, typeManager);
            if (!cursor.isPresent()) continue;
            RecordCursor delegate = cursor.get();
            if (doCoercion) {
                delegate = new HiveCoercionRecordCursor(regularColumnMappings, typeManager, delegate);
            }
            HiveRecordCursor hiveRecordCursor = new HiveRecordCursor(columnMappings, hiveStorageTimeZone, typeManager, delegate);
            List columnTypes = hiveColumns.stream().map(input -> typeManager.getType(input.getTypeSignature())).collect(Collectors.toList());
            return Optional.of(new RecordPageSource(columnTypes, (RecordCursor)hiveRecordCursor));
        }
        return Optional.empty();
    }

    public static class ColumnMapping {
        private final HiveColumnHandle hiveColumnHandle;
        private final String prefilledValue;
        private final int index;
        private final Optional<HiveType> coercionFrom;

        private ColumnMapping(HiveColumnHandle hiveColumnHandle, String prefilledValue, int index, Optional<HiveType> coercionFrom) {
            Objects.requireNonNull(hiveColumnHandle, "hiveColumnHandle is null");
            if (ColumnMapping.isPrefilled(hiveColumnHandle)) {
                Objects.requireNonNull(prefilledValue, "prefilledValue is null when it is a prefilled column");
                Preconditions.checkArgument((index == -1 ? 1 : 0) != 0, (Object)"index should be -1");
            } else {
                Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index should be greater than or equal to 0");
            }
            this.hiveColumnHandle = hiveColumnHandle;
            this.prefilledValue = prefilledValue;
            this.index = index;
            this.coercionFrom = Objects.requireNonNull(coercionFrom, "coercionFrom is null while coercion is needed");
        }

        public boolean isPrefilled() {
            return ColumnMapping.isPrefilled(this.hiveColumnHandle);
        }

        public String getPrefilledValue() {
            Preconditions.checkState((boolean)this.isPrefilled(), (Object)"This is column is not prefilled");
            return this.prefilledValue;
        }

        public HiveColumnHandle getHiveColumnHandle() {
            return this.hiveColumnHandle;
        }

        public int getIndex() {
            return this.index;
        }

        public Optional<HiveType> getCoercionFrom() {
            return this.coercionFrom;
        }

        private static boolean isPrefilled(HiveColumnHandle hiveColumnHandle) {
            return hiveColumnHandle.getColumnType() != HiveColumnHandle.ColumnType.REGULAR;
        }

        public static List<ColumnMapping> buildColumnMappings(List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, Map<Integer, HiveType> columnCoercions, Path path, OptionalInt bucketNumber) {
            ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
            int regularIndex = 0;
            ImmutableList.Builder columnMappings = ImmutableList.builder();
            for (int i = 0; i < columns.size(); ++i) {
                int currentIndex;
                HiveColumnHandle column = columns.get(i);
                String prefilledValue = null;
                if (column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR) {
                    currentIndex = regularIndex++;
                } else {
                    currentIndex = -1;
                    HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(column.getName());
                    prefilledValue = HiveUtil.getPrefilledColumnValue(column, partitionKey, path, bucketNumber);
                }
                Optional<HiveType> coercionFrom = Optional.ofNullable(columnCoercions.get(column.getHiveColumnIndex()));
                columnMappings.add((Object)new ColumnMapping(column, prefilledValue, currentIndex, coercionFrom));
            }
            return columnMappings.build();
        }

        public static List<ColumnMapping> extractRegularColumnMappings(List<ColumnMapping> columnMappings) {
            return columnMappings.stream().filter(columnMapping -> !columnMapping.isPrefilled()).collect(Collectors.toList());
        }

        public static List<HiveColumnHandle> extractRegularColumnHandles(List<ColumnMapping> regularColumnMappings, boolean doCoercion) {
            return regularColumnMappings.stream().map(columnMapping -> {
                HiveColumnHandle columnHandle = columnMapping.getHiveColumnHandle();
                if (!doCoercion || !columnMapping.getCoercionFrom().isPresent()) {
                    return columnHandle;
                }
                return new HiveColumnHandle(columnHandle.getName(), columnMapping.getCoercionFrom().get(), columnMapping.getCoercionFrom().get().getTypeSignature(), columnHandle.getHiveColumnIndex(), columnHandle.getColumnType(), Optional.empty());
            }).collect(Collectors.toList());
        }
    }
}

