/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionHandle;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.util.AsyncQueue;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;

class HiveSplitSource
implements ConnectorSplitSource {
    private static final Logger log = Logger.get(HiveSplit.class);
    private final String queryId;
    private final String databaseName;
    private final String tableName;
    private final TupleDomain<? extends ColumnHandle> compactEffectivePredicate;
    private final PerBucket queues;
    private final AtomicInteger bufferedInternalSplitCount = new AtomicInteger();
    private final int maxOutstandingSplitsBytes;
    private final DataSize maxSplitSize;
    private final DataSize maxInitialSplitSize;
    private final AtomicInteger remainingInitialSplits;
    private final HiveSplitLoader splitLoader;
    private final AtomicReference<State> stateReference;
    private final AtomicLong estimatedSplitSizeInBytes = new AtomicLong();
    private final CounterStat highMemorySplitSourceCounter;
    private final AtomicBoolean loggedHighMemoryWarning = new AtomicBoolean();

    private HiveSplitSource(ConnectorSession session, String databaseName, String tableName, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, PerBucket queues, int maxInitialSplits, DataSize maxOutstandingSplitsSize, HiveSplitLoader splitLoader, AtomicReference<State> stateReference, CounterStat highMemorySplitSourceCounter) {
        Objects.requireNonNull(session, "session is null");
        this.queryId = session.getQueryId();
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.queues = Objects.requireNonNull(queues, "queues is null");
        this.maxOutstandingSplitsBytes = Math.toIntExact(maxOutstandingSplitsSize.toBytes());
        this.splitLoader = Objects.requireNonNull(splitLoader, "splitLoader is null");
        this.stateReference = Objects.requireNonNull(stateReference, "stateReference is null");
        this.highMemorySplitSourceCounter = Objects.requireNonNull(highMemorySplitSourceCounter, "highMemorySplitSourceCounter is null");
        this.maxSplitSize = HiveSessionProperties.getMaxSplitSize(session);
        this.maxInitialSplitSize = HiveSessionProperties.getMaxInitialSplitSize(session);
        this.remainingInitialSplits = new AtomicInteger(maxInitialSplits);
    }

    public static HiveSplitSource allAtOnce(ConnectorSession session, String databaseName, String tableName, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, int maxInitialSplits, final int maxOutstandingSplits, DataSize maxOutstandingSplitsSize, HiveSplitLoader splitLoader, final Executor executor, CounterStat highMemorySplitSourceCounter) {
        AtomicReference<State> stateReference = new AtomicReference<State>(State.initial());
        return new HiveSplitSource(session, databaseName, tableName, compactEffectivePredicate, new PerBucket(){
            private final AsyncQueue<InternalHiveSplit> queue;
            {
                this.queue = new AsyncQueue(maxOutstandingSplits, executor);
            }

            @Override
            public ListenableFuture<?> offer(OptionalInt bucketNumber, InternalHiveSplit connectorSplit) {
                return this.queue.offer(connectorSplit);
            }

            @Override
            public <O> ListenableFuture<O> borrowBatchAsync(OptionalInt bucketNumber, int maxSize, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, O>> function) {
                Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0);
                return this.queue.borrowBatchAsync(maxSize, function);
            }

            @Override
            public void finish() {
                this.queue.finish();
            }

            @Override
            public boolean isFinished(OptionalInt bucketNumber) {
                Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0);
                return this.queue.isFinished();
            }
        }, maxInitialSplits, maxOutstandingSplitsSize, splitLoader, stateReference, highMemorySplitSourceCounter);
    }

    public static HiveSplitSource bucketed(ConnectorSession session, String databaseName, String tableName, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, final int estimatedOutstandingSplitsPerBucket, int maxInitialSplits, DataSize maxOutstandingSplitsSize, HiveSplitLoader splitLoader, final Executor executor, CounterStat highMemorySplitSourceCounter) {
        final AtomicReference<State> stateReference = new AtomicReference<State>(State.initial());
        return new HiveSplitSource(session, databaseName, tableName, compactEffectivePredicate, new PerBucket(){
            private final Map<Integer, AsyncQueue<InternalHiveSplit>> queues = new ConcurrentHashMap<Integer, AsyncQueue<InternalHiveSplit>>();

            @Override
            public ListenableFuture<?> offer(OptionalInt bucketNumber, InternalHiveSplit connectorSplit) {
                AsyncQueue<InternalHiveSplit> queue = this.queueFor(bucketNumber);
                queue.offer(connectorSplit);
                return Futures.immediateFuture(null);
            }

            @Override
            public <O> ListenableFuture<O> borrowBatchAsync(OptionalInt bucketNumber, int maxSize, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, O>> function) {
                return this.queueFor(bucketNumber).borrowBatchAsync(maxSize, function);
            }

            @Override
            public void finish() {
                this.queues.values().forEach(AsyncQueue::finish);
            }

            @Override
            public boolean isFinished(OptionalInt bucketNumber) {
                return this.queueFor(bucketNumber).isFinished();
            }

            public AsyncQueue<InternalHiveSplit> queueFor(OptionalInt bucketNumber) {
                Preconditions.checkArgument((boolean)bucketNumber.isPresent());
                return this.queues.computeIfAbsent(bucketNumber.getAsInt(), ignored -> {
                    if (((State)stateReference.get()).getKind() != StateKind.INITIAL) {
                        throw new IllegalStateException();
                    }
                    return new AsyncQueue(estimatedOutstandingSplitsPerBucket, executor);
                });
            }
        }, maxInitialSplits, maxOutstandingSplitsSize, splitLoader, stateReference, highMemorySplitSourceCounter);
    }

    @VisibleForTesting
    int getBufferedInternalSplitCount() {
        return this.bufferedInternalSplitCount.get();
    }

    CompletableFuture<?> addToQueue(List<? extends InternalHiveSplit> splits) {
        CompletableFuture<Object> lastResult = CompletableFuture.completedFuture(null);
        for (InternalHiveSplit internalHiveSplit : splits) {
            lastResult = this.addToQueue(internalHiveSplit);
        }
        return lastResult;
    }

    CompletableFuture<?> addToQueue(InternalHiveSplit split) {
        if (this.stateReference.get().getKind() != StateKind.INITIAL) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.estimatedSplitSizeInBytes.addAndGet(split.getEstimatedSizeInBytes()) > (long)this.maxOutstandingSplitsBytes) {
            if (this.loggedHighMemoryWarning.compareAndSet(false, true)) {
                this.highMemorySplitSourceCounter.update(1L);
                log.warn("Split buffering for %s.%s in query %s exceeded memory limit (%s). %s splits are buffered.", new Object[]{this.databaseName, this.tableName, this.queryId, DataSize.succinctBytes((long)this.maxOutstandingSplitsBytes), this.getBufferedInternalSplitCount()});
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Split buffering for %s.%s exceeded memory limit (%s). %s splits are buffered.", this.databaseName, this.tableName, DataSize.succinctBytes((long)this.maxOutstandingSplitsBytes), this.getBufferedInternalSplitCount()));
        }
        this.bufferedInternalSplitCount.incrementAndGet();
        OptionalInt bucketNumber = split.getBucketNumber();
        return MoreFutures.toCompletableFuture(this.queues.offer(bucketNumber, split));
    }

    void noMoreSplits() {
        if (HiveSplitSource.setIf(this.stateReference, State.noMoreSplits(), state -> state.getKind() == StateKind.INITIAL)) {
            this.splitLoader.stop();
            this.queues.finish();
        }
    }

    void fail(Throwable e) {
        if (HiveSplitSource.setIf(this.stateReference, State.failed(e), state -> state.getKind() == StateKind.INITIAL)) {
            this.splitLoader.stop();
            this.queues.finish();
        }
    }

    public CompletableFuture<List<ConnectorSplit>> getNextBatch(int maxSize) {
        return this.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, maxSize).thenApply(ConnectorSplitSource.ConnectorSplitBatch::getSplits);
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        boolean noMoreSplits;
        State state = this.stateReference.get();
        switch (state.getKind()) {
            case INITIAL: {
                noMoreSplits = false;
                break;
            }
            case NO_MORE_SPLITS: {
                noMoreSplits = true;
                break;
            }
            case FAILED: {
                return MoreFutures.failedFuture((Throwable)state.getThrowable());
            }
            case CLOSED: {
                throw new IllegalStateException("HiveSplitSource is already closed");
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        OptionalInt bucketNumber = this.toBucketNumber(partitionHandle);
        ListenableFuture future = this.queues.borrowBatchAsync(bucketNumber, maxSize, internalSplits -> {
            ImmutableList.Builder splitsToInsertBuilder = ImmutableList.builder();
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            int removedEstimatedSizeInBytes = 0;
            for (InternalHiveSplit internalSplit : internalSplits) {
                long maxSplitBytes = this.maxSplitSize.toBytes();
                if (this.remainingInitialSplits.get() > 0 && this.remainingInitialSplits.getAndDecrement() > 0) {
                    maxSplitBytes = this.maxInitialSplitSize.toBytes();
                }
                InternalHiveSplit.InternalHiveBlock block = internalSplit.currentBlock();
                long splitBytes = internalSplit.isSplittable() ? Math.min(maxSplitBytes, block.getEnd() - internalSplit.getStart()) : internalSplit.getEnd() - internalSplit.getStart();
                resultBuilder.add((Object)new HiveSplit(this.databaseName, this.tableName, internalSplit.getPartitionName(), internalSplit.getPath(), internalSplit.getStart(), splitBytes, internalSplit.getFileSize(), internalSplit.getSchema(), internalSplit.getPartitionKeys(), block.getAddresses(), internalSplit.getBucketNumber(), internalSplit.isForceLocalScheduling(), this.compactEffectivePredicate, Maps.transformValues(internalSplit.getColumnCoercions(), HiveTypeName::toHiveType)));
                internalSplit.increaseStart(splitBytes);
                if (internalSplit.isDone()) {
                    removedEstimatedSizeInBytes += internalSplit.getEstimatedSizeInBytes();
                    continue;
                }
                splitsToInsertBuilder.add((Object)internalSplit);
            }
            this.estimatedSplitSizeInBytes.addAndGet(-removedEstimatedSizeInBytes);
            ImmutableList splitsToInsert = splitsToInsertBuilder.build();
            ImmutableList result = resultBuilder.build();
            this.bufferedInternalSplitCount.addAndGet(splitsToInsert.size() - result.size());
            return new AsyncQueue.BorrowResult(splitsToInsert, result);
        });
        ListenableFuture transform = Futures.transform(future, splits -> {
            Objects.requireNonNull(splits, "splits is null");
            if (noMoreSplits) {
                return new ConnectorSplitSource.ConnectorSplitBatch(splits, splits.isEmpty() && this.queues.isFinished(bucketNumber));
            }
            return new ConnectorSplitSource.ConnectorSplitBatch(splits, false);
        });
        return MoreFutures.toCompletableFuture((ListenableFuture)transform);
    }

    public boolean isFinished() {
        State state = this.stateReference.get();
        switch (state.getKind()) {
            case INITIAL: {
                return false;
            }
            case NO_MORE_SPLITS: {
                return this.bufferedInternalSplitCount.get() == 0;
            }
            case FAILED: {
                throw HiveSplitSource.propagatePrestoException(state.getThrowable());
            }
            case CLOSED: {
                throw new IllegalStateException("HiveSplitSource is already closed");
            }
        }
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (HiveSplitSource.setIf(this.stateReference, State.closed(), state -> state.getKind() == StateKind.INITIAL || state.getKind() == StateKind.NO_MORE_SPLITS)) {
            this.splitLoader.stop();
            this.queues.finish();
        }
    }

    private OptionalInt toBucketNumber(ConnectorPartitionHandle partitionHandle) {
        if (partitionHandle == NotPartitionedPartitionHandle.NOT_PARTITIONED) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(((HivePartitionHandle)partitionHandle).getBucket());
    }

    private static <T> boolean setIf(AtomicReference<T> atomicReference, T newValue, Predicate<T> predicate) {
        T current;
        do {
            if (predicate.test(current = atomicReference.get())) continue;
            return false;
        } while (!atomicReference.compareAndSet(current, newValue));
        return true;
    }

    private static RuntimeException propagatePrestoException(Throwable throwable) {
        if (throwable instanceof PrestoException) {
            throw (PrestoException)throwable;
        }
        if (throwable instanceof FileNotFoundException) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, throwable);
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, throwable);
    }

    static enum StateKind {
        INITIAL,
        NO_MORE_SPLITS,
        FAILED,
        CLOSED;

    }

    static class State {
        private final StateKind kind;
        private final Throwable throwable;

        private State(StateKind kind, Throwable throwable) {
            this.kind = kind;
            this.throwable = throwable;
        }

        public StateKind getKind() {
            return this.kind;
        }

        public Throwable getThrowable() {
            Preconditions.checkState((this.throwable != null ? 1 : 0) != 0);
            return this.throwable;
        }

        public static State initial() {
            return new State(StateKind.INITIAL, null);
        }

        public static State noMoreSplits() {
            return new State(StateKind.NO_MORE_SPLITS, null);
        }

        public static State failed(Throwable throwable) {
            return new State(StateKind.FAILED, throwable);
        }

        public static State closed() {
            return new State(StateKind.CLOSED, null);
        }
    }

    static interface PerBucket {
        public ListenableFuture<?> offer(OptionalInt var1, InternalHiveSplit var2);

        public <O> ListenableFuture<O> borrowBatchAsync(OptionalInt var1, int var2, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, O>> var3);

        public void finish();

        public boolean isFinished(OptionalInt var1);
    }
}

