/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.HiveWriter;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.RecordFileWriter;
import com.facebook.presto.hive.WriteCompletedEvent;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HivePageSinkMetadataProvider;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import io.airlift.event.client.EventClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.ReflectionUtil;

public class HiveWriterFactory {
    private static final int MAX_BUCKET_COUNT = 100000;
    private static final int BUCKET_NUMBER_PADDING = Integer.toString(99999).length();
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final String schemaName;
    private final String tableName;
    private final List<DataColumn> dataColumns;
    private final List<String> partitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final LocationHandle locationHandle;
    private final LocationService locationService;
    private final String filePrefix;
    private final HivePageSinkMetadataProvider pageSinkMetadataProvider;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final JobConf conf;
    private final Table table;
    private final boolean immutablePartitions;
    private final ConnectorSession session;
    private final OptionalInt bucketCount;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final Map<String, String> sessionProperties;
    private final HiveWriterStats hiveWriterStats;

    public HiveWriterFactory(Set<HiveFileWriterFactory> fileWriterFactories, String schemaName, String tableName, boolean isCreateTable, List<HiveColumnHandle> inputColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, OptionalInt bucketCount, LocationHandle locationHandle, LocationService locationService, String filePrefix, HivePageSinkMetadataProvider pageSinkMetadataProvider, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, boolean immutablePartitions, ConnectorSession session, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties, HiveWriterStats hiveWriterStats) {
        Path writePath;
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.filePrefix = Objects.requireNonNull(filePrefix, "filePrefix is null");
        this.pageSinkMetadataProvider = Objects.requireNonNull(pageSinkMetadataProvider, "pageSinkMetadataProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.immutablePartitions = immutablePartitions;
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        ImmutableList.Builder partitionColumnNames = ImmutableList.builder();
        ImmutableList.Builder partitionColumnTypes = ImmutableList.builder();
        ImmutableList.Builder dataColumns = ImmutableList.builder();
        for (HiveColumnHandle column : inputColumns) {
            HiveType hiveType = column.getHiveType();
            if (column.isPartitionKey()) {
                partitionColumnNames.add((Object)column.getName());
                partitionColumnTypes.add((Object)typeManager.getType(column.getTypeSignature()));
                continue;
            }
            dataColumns.add((Object)new DataColumn(column.getName(), typeManager.getType(column.getTypeSignature()), hiveType));
        }
        this.partitionColumnNames = partitionColumnNames.build();
        this.partitionColumnTypes = partitionColumnTypes.build();
        this.dataColumns = dataColumns.build();
        if (isCreateTable) {
            this.table = null;
            writePath = locationService.writePathRoot(locationHandle).orElseThrow(() -> new IllegalArgumentException("CREATE TABLE must have a write path"));
        } else {
            Optional<Table> table = pageSinkMetadataProvider.getTable();
            if (!table.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table %s.%s was dropped during insert", schemaName, tableName));
            }
            this.table = table.get();
            writePath = locationService.writePathRoot(locationHandle).orElseGet(() -> locationService.targetPathRoot(locationHandle));
        }
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        if (bucketCount.isPresent()) {
            Preconditions.checkArgument((bucketCount.getAsInt() < 100000 ? 1 : 0) != 0, (Object)"bucketCount must be smaller than 100000");
        }
        this.session = Objects.requireNonNull(session, "session is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
        this.sessionProperties = (Map)hiveSessionProperties.getSessionProperties().stream().collect(ImmutableMap.toImmutableMap(PropertyMetadata::getName, entry -> session.getProperty(entry.getName(), entry.getJavaType()).toString()));
        Configuration conf = hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, schemaName, tableName), writePath);
        this.conf = ConfigurationUtils.toJobConf(conf);
        try {
            hdfsEnvironment.getFileSystem(session.getUser(), writePath, conf);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + writePath, (Throwable)e);
        }
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
    }

    public HiveWriter createWriter(Page partitionColumns, int position, OptionalInt bucketNumber) {
        StorageFormat outputStorageFormat;
        Path write;
        Path target;
        Properties schema;
        boolean isNew;
        if (this.bucketCount.isPresent()) {
            Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"Bucket not provided for bucketed table");
            Preconditions.checkArgument((bucketNumber.getAsInt() < this.bucketCount.getAsInt() ? 1 : 0) != 0, (String)"Bucket number %s must be less than bucket count %s", (Object)bucketNumber, (Object)this.bucketCount);
        } else {
            Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0, (Object)"Bucket number provided by for table that is not bucketed");
        }
        String fileName = bucketNumber.isPresent() ? HiveWriterFactory.computeBucketedFileName(this.filePrefix, bucketNumber.getAsInt()) : this.filePrefix + "_" + UUID.randomUUID();
        List<String> partitionValues = this.toPartitionValues(partitionColumns, position);
        Optional<Object> partitionName = !this.partitionColumnNames.isEmpty() ? Optional.of(FileUtils.makePartName(this.partitionColumnNames, partitionValues)) : Optional.empty();
        Optional<Object> partition = Optional.empty();
        if (!partitionValues.isEmpty() && this.table != null) {
            partition = this.pageSinkMetadataProvider.getPartition(partitionValues);
        }
        if (!partition.isPresent()) {
            if (this.table == null) {
                isNew = true;
                schema = new Properties();
                schema.setProperty("columns", this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.joining(",")));
                schema.setProperty("columns.types", this.dataColumns.stream().map(DataColumn::getHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
                target = this.locationService.targetPath(this.locationHandle, partitionName);
                write = this.locationService.writePath(this.locationHandle, partitionName).get();
                if (partitionName.isPresent() && !target.equals((Object)write) && HiveWriteUtils.pathExists(new HdfsEnvironment.HdfsContext(this.session, this.schemaName, this.tableName), this.hdfsEnvironment, target)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for new partition '%s' of table '%s.%s' already exists: %s", partitionName, this.schemaName, this.tableName, target));
                }
            } else {
                if (partitionName.isPresent()) {
                    isNew = true;
                } else {
                    if (bucketNumber.isPresent()) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into bucketed unpartitioned Hive table");
                    }
                    if (this.immutablePartitions) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Unpartitioned Hive tables are immutable");
                    }
                    isNew = false;
                }
                schema = MetastoreUtil.getHiveSchema(this.table);
                target = this.locationService.targetPath(this.locationHandle, partitionName);
                write = this.locationService.writePath(this.locationHandle, partitionName).orElse(target);
            }
            outputStorageFormat = partitionName.isPresent() ? StorageFormat.fromHiveStorageFormat(this.partitionStorageFormat) : StorageFormat.fromHiveStorageFormat(this.tableStorageFormat);
        } else {
            if (bucketNumber.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into existing partition of bucketed Hive table: " + (String)partitionName.get());
            }
            if (this.immutablePartitions) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Hive partitions are immutable: " + (String)partitionName.get());
            }
            isNew = false;
            List<Column> tableColumns = this.table.getDataColumns();
            List<Column> existingPartitionColumns = ((Partition)partition.get()).getColumns();
            for (int i = 0; i < Math.min(existingPartitionColumns.size(), tableColumns.size()); ++i) {
                HiveType partitionType;
                HiveType tableType = tableColumns.get(i).getType();
                if (tableType.equals(partitionType = existingPartitionColumns.get(i).getType())) continue;
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumns.get(i).getName(), this.tableName, tableType, partitionName, existingPartitionColumns.get(i).getName(), partitionType));
            }
            HiveWriteUtils.checkPartitionIsWritable((String)partitionName.get(), (Partition)partition.get());
            outputStorageFormat = ((Partition)partition.get()).getStorage().getStorageFormat();
            schema = MetastoreUtil.getHiveSchema((Partition)partition.get(), this.table);
            target = this.locationService.targetPath(this.locationHandle, (Partition)partition.get(), (String)partitionName.get());
            write = this.locationService.writePath(this.locationHandle, partitionName).orElse(target);
        }
        this.validateSchema(partitionName, schema);
        String fileNameWithExtension = fileName + HiveWriterFactory.getFileExtension(this.conf, outputStorageFormat);
        Path path = new Path(write, fileNameWithExtension);
        Object hiveFileWriter = null;
        for (HiveFileWriterFactory fileWriterFactory : this.fileWriterFactories) {
            Optional<HiveFileWriter> fileWriter = fileWriterFactory.createFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, this.conf, this.session);
            if (!fileWriter.isPresent()) continue;
            hiveFileWriter = fileWriter.get();
            break;
        }
        if (hiveFileWriter == null) {
            hiveFileWriter = new RecordFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, this.partitionStorageFormat.getEstimatedWriterSystemMemoryUsage(), this.conf, this.typeManager);
        }
        String writerImplementation = hiveFileWriter.getClass().getName();
        Consumer<HiveWriter> onCommit = hiveWriter -> {
            Optional<Object> size;
            try {
                size = Optional.of(this.hdfsEnvironment.getFileSystem(this.session.getUser(), path, (Configuration)this.conf).getFileStatus(path).getLen());
            }
            catch (IOException | RuntimeException e) {
                size = Optional.empty();
            }
            this.eventClient.post((Object[])new WriteCompletedEvent[]{new WriteCompletedEvent(this.session.getQueryId(), path.toString(), this.schemaName, this.tableName, partitionName.orElse(null), outputStorageFormat.getOutputFormat(), writerImplementation, this.nodeManager.getCurrentNode().getVersion(), this.nodeManager.getCurrentNode().getHttpUri().getHost(), this.session.getIdentity().getPrincipal().map(Principal::getName).orElse(null), this.nodeManager.getEnvironment(), this.sessionProperties, size.orElse(null), hiveWriter.getRowCount())});
        };
        return new HiveWriter((HiveFileWriter)hiveFileWriter, partitionName, isNew, fileNameWithExtension, write.toString(), target.toString(), onCommit, this.hiveWriterStats);
    }

    private void validateSchema(Optional<String> partitionName, Properties schema) {
        List fileColumnNames = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)schema.getProperty("columns", ""));
        List<HiveType> fileColumnHiveTypes = HiveType.toHiveTypes(schema.getProperty("columns.types", ""));
        Map inputColumnMap = this.dataColumns.stream().collect(Collectors.toMap(DataColumn::getName, Function.identity()));
        Sets.SetView missingColumns = Sets.difference(inputColumnMap.keySet(), new HashSet(fileColumnNames));
        if (!missingColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table %s.%s does not have columns %s", schema, this.tableName, missingColumns));
        }
        if (fileColumnNames.size() != fileColumnHiveTypes.size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Partition '%s' in table '%s.%s' has mismatched metadata for column names and types", partitionName, this.schemaName, this.tableName));
        }
        for (int fileIndex = 0; fileIndex < fileColumnNames.size(); ++fileIndex) {
            HiveType inputHiveType;
            String columnName = (String)fileColumnNames.get(fileIndex);
            HiveType fileColumnHiveType = fileColumnHiveTypes.get(fileIndex);
            if (fileColumnHiveType.equals(inputHiveType = ((DataColumn)inputColumnMap.get(columnName)).getHiveType())) continue;
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s.%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", columnName, this.schemaName, this.tableName, inputHiveType, partitionName, columnName, fileColumnHiveType));
        }
    }

    private List<String> toPartitionValues(Page partitionColumns, int position) {
        ImmutableList.Builder partitionValues = ImmutableList.builder();
        for (int field = 0; field < partitionColumns.getChannelCount(); ++field) {
            Object value = HiveWriteUtils.getField(this.partitionColumnTypes.get(field), partitionColumns.getBlock(field), position);
            if (value == null) {
                partitionValues.add((Object)"__HIVE_DEFAULT_PARTITION__");
                continue;
            }
            String valueString = value.toString();
            if (!CharMatcher.inRange((char)' ', (char)'~').matchesAllOf((CharSequence)valueString)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "Hive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: " + BaseEncoding.base16().withSeparator(" ", 2).encode(valueString.getBytes(StandardCharsets.UTF_8)));
            }
            partitionValues.add((Object)valueString);
        }
        return partitionValues.build();
    }

    public static String computeBucketedFileName(String filePrefix, int bucket) {
        return filePrefix + "_bucket-" + Strings.padStart((String)Integer.toString(bucket), (int)BUCKET_NUMBER_PADDING, (char)'0');
    }

    public static String getFileExtension(JobConf conf, StorageFormat storageFormat) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT) || !HiveIgnoreKeyTextOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return "";
        }
        String compressionCodecClass = conf.get("mapred.output.compression.codec");
        if (compressionCodecClass == null) {
            return new DefaultCodec().getDefaultExtension();
        }
        try {
            Class<CompressionCodec> codecClass = conf.getClassByName(compressionCodecClass).asSubclass(CompressionCodec.class);
            return ((CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)conf)).getDefaultExtension();
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Compression codec not found: " + compressionCodecClass, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Failed to load compression codec: " + compressionCodecClass, (Throwable)e);
        }
    }

    private static class DataColumn {
        private final String name;
        private final Type type;
        private final HiveType hiveType;

        public DataColumn(String name, Type type, HiveType hiveType) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public HiveType getHiveType() {
            return this.hiveType;
        }
    }
}

