/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.PartitionOfflineException;
import com.facebook.presto.hive.TableOfflineException;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.ProtectMode;

public class MetastoreUtil {
    private MetastoreUtil() {
    }

    public static Properties getHiveSchema(Table table) {
        return MetastoreUtil.getHiveSchema(table.getStorage(), table.getDataColumns(), table.getDataColumns(), table.getParameters(), table.getDatabaseName(), table.getTableName(), table.getPartitionColumns());
    }

    public static Properties getHiveSchema(Partition partition, Table table) {
        return MetastoreUtil.getHiveSchema(partition.getStorage(), partition.getColumns(), table.getDataColumns(), table.getParameters(), table.getDatabaseName(), table.getTableName(), table.getPartitionColumns());
    }

    private static Properties getHiveSchema(Storage sd, List<Column> dataColumns, List<Column> tableDataColumns, Map<String, String> parameters, String databaseName, String tableName, List<Column> partitionKeys) {
        Properties schema = new Properties();
        schema.setProperty("file.inputformat", sd.getStorageFormat().getInputFormat());
        schema.setProperty("file.outputformat", sd.getStorageFormat().getOutputFormat());
        schema.setProperty("name", databaseName + "." + tableName);
        schema.setProperty("location", sd.getLocation());
        if (sd.getBucketProperty().isPresent()) {
            schema.setProperty("bucket_field_name", sd.getBucketProperty().get().getBucketedBy().get(0));
            schema.setProperty("bucket_count", Integer.toString(sd.getBucketProperty().get().getBucketCount()));
        } else {
            schema.setProperty("bucket_count", "0");
        }
        for (Map.Entry<String, String> param : sd.getSerdeParameters().entrySet()) {
            schema.setProperty(param.getKey(), param.getValue() != null ? param.getValue() : "");
        }
        schema.setProperty("serialization.lib", sd.getStorageFormat().getSerDe());
        StringBuilder columnNameBuilder = new StringBuilder();
        StringBuilder columnTypeBuilder = new StringBuilder();
        StringBuilder columnCommentBuilder = new StringBuilder();
        boolean first = true;
        for (Column column : tableDataColumns) {
            if (!first) {
                columnNameBuilder.append(",");
                columnTypeBuilder.append(":");
                columnCommentBuilder.append('\u0000');
            }
            columnNameBuilder.append(column.getName());
            columnTypeBuilder.append(column.getType());
            columnCommentBuilder.append(column.getComment().orElse(""));
            first = false;
        }
        String columnNames = columnNameBuilder.toString();
        String columnTypes = columnTypeBuilder.toString();
        schema.setProperty("columns", columnNames);
        schema.setProperty("columns.types", columnTypes);
        schema.setProperty("columns.comments", columnCommentBuilder.toString());
        schema.setProperty("serialization.ddl", MetastoreUtil.toThriftDdl(tableName, dataColumns));
        String partString = "";
        String partStringSep = "";
        String partTypesString = "";
        String partTypesStringSep = "";
        for (Column column : partitionKeys) {
            partString = partString + partStringSep;
            partString = partString + column.getName();
            partTypesString = partTypesString + partTypesStringSep;
            partTypesString = partTypesString + column.getType().getHiveTypeName().toString();
            if (partStringSep.length() != 0) continue;
            partStringSep = "/";
            partTypesStringSep = ":";
        }
        if (partString.length() > 0) {
            schema.setProperty("partition_columns", partString);
            schema.setProperty("partition_columns.types", partTypesString);
        }
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                schema.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return schema;
    }

    public static ProtectMode getProtectMode(Partition partition) {
        return MetastoreUtil.getProtectMode(partition.getParameters());
    }

    public static ProtectMode getProtectMode(Table table) {
        return MetastoreUtil.getProtectMode(table.getParameters());
    }

    public static String makePartName(List<Column> partitionColumns, List<String> values) {
        Preconditions.checkArgument((partitionColumns.size() == values.size() ? 1 : 0) != 0);
        List partitionColumnNames = partitionColumns.stream().map(Column::getName).collect(Collectors.toList());
        return FileUtils.makePartName(partitionColumnNames, values);
    }

    private static String toThriftDdl(String structName, List<Column> columns) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("struct ");
        ddl.append(structName);
        ddl.append(" { ");
        boolean first = true;
        for (Column column : columns) {
            if (first) {
                first = false;
            } else {
                ddl.append(", ");
            }
            ddl.append(MetaStoreUtils.typeToThriftType((String)column.getType().getHiveTypeName().toString()));
            ddl.append(' ');
            ddl.append(column.getName());
        }
        ddl.append("}");
        return ddl.toString();
    }

    private static ProtectMode getProtectMode(Map<String, String> parameters) {
        if (!parameters.containsKey(ProtectMode.PARAMETER_NAME)) {
            return new ProtectMode();
        }
        return ProtectMode.getProtectModeFromString((String)parameters.get(ProtectMode.PARAMETER_NAME));
    }

    public static void verifyOnline(SchemaTableName tableName, Optional<String> partitionName, ProtectMode protectMode, Map<String, String> parameters) {
        if (protectMode.offline) {
            if (partitionName.isPresent()) {
                throw new PartitionOfflineException(tableName, partitionName.get(), false, null);
            }
            throw new TableOfflineException(tableName, false, null);
        }
        String prestoOffline = parameters.get("presto_offline");
        if (!Strings.isNullOrEmpty((String)prestoOffline)) {
            if (partitionName.isPresent()) {
                throw new PartitionOfflineException(tableName, partitionName.get(), true, prestoOffline);
            }
            throw new TableOfflineException(tableName, true, prestoOffline);
        }
    }

    public static void verifyCanDropColumn(ExtendedHiveMetastore metastore, String databaseName, String tableName, String columnName) {
        Table table = metastore.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        if (table.getPartitionColumns().stream().anyMatch(column -> column.getName().equals(columnName))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop partition columns");
        }
        if (table.getDataColumns().size() <= 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop the only non-partition column in a table");
        }
    }
}

