/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class ThriftHiveMetastoreClient
implements HiveMetastoreClient {
    private final TTransport transport;
    private final ThriftHiveMetastore.Client client;

    public ThriftHiveMetastoreClient(TTransport transport) {
        this.transport = Objects.requireNonNull(transport, "transport is null");
        this.client = new ThriftHiveMetastore.Client((TProtocol)new TBinaryProtocol(transport));
    }

    public ThriftHiveMetastoreClient(TProtocol protocol) {
        this.transport = protocol.getTransport();
        this.client = new ThriftHiveMetastore.Client(protocol);
    }

    @Override
    public void close() {
        this.transport.close();
    }

    @Override
    public List<String> getAllDatabases() throws TException {
        return this.client.get_all_databases();
    }

    @Override
    public Database getDatabase(String dbName) throws TException {
        return this.client.get_database(dbName);
    }

    @Override
    public List<String> getAllTables(String databaseName) throws TException {
        return this.client.get_all_tables(databaseName);
    }

    @Override
    public List<String> getTableNamesByFilter(String databaseName, String filter) throws TException {
        return this.client.get_table_names_by_filter(databaseName, filter, (short)-1);
    }

    @Override
    public void createDatabase(Database database) throws TException {
        this.client.create_database(database);
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData, boolean cascade) throws TException {
        this.client.drop_database(databaseName, deleteData, cascade);
    }

    @Override
    public void alterDatabase(String databaseName, Database database) throws TException {
        this.client.alter_database(databaseName, database);
    }

    @Override
    public void createTable(Table table) throws TException {
        this.client.create_table(table);
    }

    @Override
    public void dropTable(String databaseName, String name, boolean deleteData) throws TException {
        this.client.drop_table(databaseName, name, deleteData);
    }

    @Override
    public void alterTable(String databaseName, String tableName, Table newTable) throws TException {
        this.client.alter_table(databaseName, tableName, newTable);
    }

    @Override
    public Table getTable(String databaseName, String tableName) throws TException {
        return this.client.get_table(databaseName, tableName);
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String databaseName, String tableName, List<String> columnNames) throws TException {
        TableStatsRequest tableStatsRequest = new TableStatsRequest(databaseName, tableName, columnNames);
        return this.client.get_table_statistics_req(tableStatsRequest).getTableStats();
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String databaseName, String tableName, List<String> columnNames, List<String> partitionValues) throws TException {
        PartitionsStatsRequest partitionsStatsRequest = new PartitionsStatsRequest(databaseName, tableName, columnNames, partitionValues);
        return this.client.get_partitions_statistics_req(partitionsStatsRequest).getPartStats();
    }

    @Override
    public List<String> getPartitionNames(String databaseName, String tableName) throws TException {
        return this.client.get_partition_names(databaseName, tableName, (short)-1);
    }

    @Override
    public List<String> getPartitionNamesFiltered(String databaseName, String tableName, List<String> partitionValues) throws TException {
        return this.client.get_partition_names_ps(databaseName, tableName, partitionValues, (short)-1);
    }

    @Override
    public int addPartitions(List<Partition> newPartitions) throws TException {
        return this.client.add_partitions(newPartitions);
    }

    @Override
    public boolean dropPartition(String databaseName, String tableName, List<String> partitionValues, boolean deleteData) throws TException {
        return this.client.drop_partition(databaseName, tableName, partitionValues, deleteData);
    }

    @Override
    public void alterPartition(String databaseName, String tableName, Partition partition) throws TException {
        this.client.alter_partition(databaseName, tableName, partition);
    }

    @Override
    public Partition getPartition(String databaseName, String tableName, List<String> partitionValues) throws TException {
        return this.client.get_partition(databaseName, tableName, partitionValues);
    }

    @Override
    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws TException {
        return this.client.get_partitions_by_names(databaseName, tableName, partitionNames);
    }

    @Override
    public List<Role> listRoles(String principalName, PrincipalType principalType) throws TException {
        return this.client.list_roles(principalName, principalType);
    }

    @Override
    public PrincipalPrivilegeSet getPrivilegeSet(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws TException {
        return this.client.get_privilege_set(hiveObject, userName, groupNames);
    }

    @Override
    public List<HiveObjectPrivilege> listPrivileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObjectRef) throws TException {
        return this.client.list_privileges(principalName, principalType, hiveObjectRef);
    }

    @Override
    public List<String> getRoleNames() throws TException {
        return this.client.get_role_names();
    }

    @Override
    public boolean grantPrivileges(PrivilegeBag privilegeBag) throws TException {
        return this.client.grant_privileges(privilegeBag);
    }

    @Override
    public boolean revokePrivileges(PrivilegeBag privilegeBag) throws TException {
        return this.client.revoke_privileges(privilegeBag);
    }
}

