/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.PrincipalType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;

public final class ThriftMetastoreUtil {
    private ThriftMetastoreUtil() {
    }

    public static org.apache.hadoop.hive.metastore.api.Database toMetastoreApiDatabase(Database database) {
        org.apache.hadoop.hive.metastore.api.Database result = new org.apache.hadoop.hive.metastore.api.Database();
        result.setName(database.getDatabaseName());
        database.getLocation().ifPresent(arg_0 -> ((org.apache.hadoop.hive.metastore.api.Database)result).setLocationUri(arg_0));
        result.setOwnerName(database.getOwnerName());
        result.setOwnerType(ThriftMetastoreUtil.toMetastoreApiPrincipalType(database.getOwnerType()));
        database.getComment().ifPresent(arg_0 -> ((org.apache.hadoop.hive.metastore.api.Database)result).setDescription(arg_0));
        result.setParameters(database.getParameters());
        return result;
    }

    public static org.apache.hadoop.hive.metastore.api.Table toMetastoreApiTable(Table table, PrincipalPrivileges privileges) {
        org.apache.hadoop.hive.metastore.api.Table result = new org.apache.hadoop.hive.metastore.api.Table();
        result.setDbName(table.getDatabaseName());
        result.setTableName(table.getTableName());
        result.setOwner(table.getOwner());
        result.setTableType(table.getTableType());
        result.setParameters(table.getParameters());
        result.setPartitionKeys(table.getPartitionColumns().stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(Collectors.toList()));
        result.setSd(ThriftMetastoreUtil.makeStorageDescriptor(table.getTableName(), table.getDataColumns(), table.getStorage()));
        result.setPrivileges(ThriftMetastoreUtil.toMetastoreApiPrincipalPrivilegeSet(table.getOwner(), privileges));
        result.setViewOriginalText((String)table.getViewOriginalText().orElse(null));
        result.setViewExpandedText((String)table.getViewExpandedText().orElse(null));
        return result;
    }

    public static PrincipalPrivilegeSet toMetastoreApiPrincipalPrivilegeSet(String grantee, PrincipalPrivileges privileges) {
        ImmutableMap.Builder userPrivileges = ImmutableMap.builder();
        for (Map.Entry entry : privileges.getUserPrivileges().asMap().entrySet()) {
            userPrivileges.put(entry.getKey(), ((Collection)entry.getValue()).stream().map(privilegeInfo -> ThriftMetastoreUtil.toMetastoreApiPrivilegeGrantInfo(grantee, privilegeInfo)).collect(Collectors.toList()));
        }
        ImmutableMap.Builder rolePrivileges = ImmutableMap.builder();
        for (Map.Entry entry : privileges.getRolePrivileges().asMap().entrySet()) {
            rolePrivileges.put(entry.getKey(), ((Collection)entry.getValue()).stream().map(privilegeInfo -> ThriftMetastoreUtil.toMetastoreApiPrivilegeGrantInfo(grantee, privilegeInfo)).collect(Collectors.toList()));
        }
        return new PrincipalPrivilegeSet((Map)userPrivileges.build(), (Map)ImmutableMap.of(), (Map)rolePrivileges.build());
    }

    public static PrivilegeGrantInfo toMetastoreApiPrivilegeGrantInfo(String grantee, HivePrivilegeInfo privilegeInfo) {
        return new PrivilegeGrantInfo(privilegeInfo.getHivePrivilege().name().toLowerCase(), 0, grantee, org.apache.hadoop.hive.metastore.api.PrincipalType.USER, privilegeInfo.isGrantOption());
    }

    public static org.apache.hadoop.hive.metastore.api.PrincipalType toMetastoreApiPrincipalType(PrincipalType principalType) {
        switch (principalType) {
            case USER: {
                return org.apache.hadoop.hive.metastore.api.PrincipalType.USER;
            }
            case ROLE: {
                return org.apache.hadoop.hive.metastore.api.PrincipalType.ROLE;
            }
        }
        throw new IllegalArgumentException("Unsupported principal type: " + (Object)((Object)principalType));
    }

    public static org.apache.hadoop.hive.metastore.api.Partition toMetastoreApiPartition(Partition partition) {
        org.apache.hadoop.hive.metastore.api.Partition result = new org.apache.hadoop.hive.metastore.api.Partition();
        result.setDbName(partition.getDatabaseName());
        result.setTableName(partition.getTableName());
        result.setValues(partition.getValues());
        result.setSd(ThriftMetastoreUtil.makeStorageDescriptor(partition.getTableName(), partition.getColumns(), partition.getStorage()));
        result.setParameters(partition.getParameters());
        return result;
    }

    public static Set<HivePrivilegeInfo> toGrants(List<PrivilegeGrantInfo> userGrants) {
        if (userGrants == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder privileges = ImmutableSet.builder();
        for (PrivilegeGrantInfo userGrant : userGrants) {
            privileges.addAll(HivePrivilegeInfo.parsePrivilege(userGrant));
        }
        return privileges.build();
    }

    public static Database fromMetastoreApiDatabase(org.apache.hadoop.hive.metastore.api.Database database) {
        Map parameters;
        String ownerName = "PUBLIC";
        PrincipalType ownerType = PrincipalType.ROLE;
        if (database.getOwnerName() != null) {
            ownerName = database.getOwnerName();
            ownerType = ThriftMetastoreUtil.fromMetastoreApiPrincipalType(database.getOwnerType());
        }
        if ((parameters = database.getParameters()) == null) {
            parameters = ImmutableMap.of();
        }
        return Database.builder().setDatabaseName(database.getName()).setLocation(Optional.ofNullable(database.getLocationUri())).setOwnerName(ownerName).setOwnerType(ownerType).setComment(Optional.ofNullable(database.getDescription())).setParameters(parameters).build();
    }

    public static Table fromMetastoreApiTable(org.apache.hadoop.hive.metastore.api.Table table) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(table.getDbName()).setTableName(table.getTableName()).setOwner(Strings.nullToEmpty((String)table.getOwner())).setTableType(table.getTableType()).setDataColumns(storageDescriptor.getCols().stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(Collectors.toList())).setPartitionColumns(table.getPartitionKeys().stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(Collectors.toList())).setParameters((Map<String, String>)(table.getParameters() == null ? ImmutableMap.of() : table.getParameters())).setViewOriginalText(Optional.ofNullable(Strings.emptyToNull((String)table.getViewOriginalText()))).setViewExpandedText(Optional.ofNullable(Strings.emptyToNull((String)table.getViewExpandedText())));
        ThriftMetastoreUtil.fromMetastoreApiStorageDescriptor(storageDescriptor, tableBuilder.getStorageBuilder(), table.getTableName());
        return tableBuilder.build();
    }

    public static Partition fromMetastoreApiPartition(org.apache.hadoop.hive.metastore.api.Partition partition) {
        StorageDescriptor storageDescriptor = partition.getSd();
        if (storageDescriptor == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Partition does not contain a storage descriptor: " + partition);
        }
        Partition.Builder partitionBuilder = Partition.builder().setDatabaseName(partition.getDbName()).setTableName(partition.getTableName()).setValues(partition.getValues()).setColumns(storageDescriptor.getCols().stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(Collectors.toList())).setParameters(partition.getParameters());
        ThriftMetastoreUtil.fromMetastoreApiStorageDescriptor(storageDescriptor, partitionBuilder.getStorageBuilder(), String.format("%s.%s", partition.getTableName(), partition.getValues()));
        return partitionBuilder.build();
    }

    public static HiveColumnStatistics fromMetastoreApiColumnStatistics(ColumnStatisticsObj columnStatistics) {
        if (columnStatistics.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStatsData = columnStatistics.getStatsData().getLongStats();
            return new HiveColumnStatistics(longStatsData.isSetLowValue() ? Optional.of(longStatsData.getLowValue()) : Optional.empty(), longStatsData.isSetHighValue() ? Optional.of(longStatsData.getHighValue()) : Optional.empty(), OptionalLong.empty(), OptionalDouble.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.of(longStatsData.getNumNulls()), OptionalLong.of(longStatsData.getNumDVs()));
        }
        if (columnStatistics.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStatsData = columnStatistics.getStatsData().getDoubleStats();
            return new HiveColumnStatistics(doubleStatsData.isSetLowValue() ? Optional.of(doubleStatsData.getLowValue()) : Optional.empty(), doubleStatsData.isSetHighValue() ? Optional.of(doubleStatsData.getHighValue()) : Optional.empty(), OptionalLong.empty(), OptionalDouble.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.of(doubleStatsData.getNumNulls()), OptionalLong.of(doubleStatsData.getNumDVs()));
        }
        if (columnStatistics.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStatsData = columnStatistics.getStatsData().getDecimalStats();
            return new HiveColumnStatistics(decimalStatsData.isSetLowValue() ? ThriftMetastoreUtil.fromMetastoreDecimal(decimalStatsData.getLowValue()) : Optional.empty(), decimalStatsData.isSetHighValue() ? ThriftMetastoreUtil.fromMetastoreDecimal(decimalStatsData.getHighValue()) : Optional.empty(), OptionalLong.empty(), OptionalDouble.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.of(decimalStatsData.getNumNulls()), OptionalLong.of(decimalStatsData.getNumDVs()));
        }
        if (columnStatistics.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData booleanStatsData = columnStatistics.getStatsData().getBooleanStats();
            return new HiveColumnStatistics(Optional.empty(), Optional.empty(), OptionalLong.empty(), OptionalDouble.empty(), OptionalLong.of(booleanStatsData.getNumTrues()), OptionalLong.of(booleanStatsData.getNumFalses()), OptionalLong.of(booleanStatsData.getNumNulls()), OptionalLong.of((booleanStatsData.getNumFalses() > 0L ? 1 : 0) + (booleanStatsData.getNumTrues() > 0L ? 1 : 0)));
        }
        if (columnStatistics.getStatsData().isSetDateStats()) {
            DateColumnStatsData dateStatsData = columnStatistics.getStatsData().getDateStats();
            return new HiveColumnStatistics(dateStatsData.isSetLowValue() ? ThriftMetastoreUtil.fromMetastoreDate(dateStatsData.getLowValue()) : Optional.empty(), dateStatsData.isSetHighValue() ? ThriftMetastoreUtil.fromMetastoreDate(dateStatsData.getHighValue()) : Optional.empty(), OptionalLong.empty(), OptionalDouble.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.of(dateStatsData.getNumNulls()), OptionalLong.of(dateStatsData.getNumDVs()));
        }
        if (columnStatistics.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStatsData = columnStatistics.getStatsData().getStringStats();
            return new HiveColumnStatistics(Optional.empty(), Optional.empty(), OptionalLong.of(stringStatsData.getMaxColLen()), OptionalDouble.of(stringStatsData.getAvgColLen()), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.of(stringStatsData.getNumNulls()), OptionalLong.of(stringStatsData.getNumDVs()));
        }
        if (columnStatistics.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStatsData = columnStatistics.getStatsData().getBinaryStats();
            return new HiveColumnStatistics(Optional.empty(), Optional.empty(), OptionalLong.of(binaryStatsData.getMaxColLen()), OptionalDouble.of(binaryStatsData.getAvgColLen()), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.of(binaryStatsData.getNumNulls()), OptionalLong.empty());
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Invalid column statistics data: " + columnStatistics);
    }

    public static Optional<LocalDate> fromMetastoreDate(Date date) {
        if (date == null) {
            return Optional.empty();
        }
        return Optional.of(LocalDate.ofEpochDay(date.getDaysSinceEpoch()));
    }

    public static Optional<BigDecimal> fromMetastoreDecimal(@Nullable Decimal decimal) {
        if (decimal == null) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(new BigInteger(decimal.getUnscaled()), decimal.getScale()));
    }

    public static PrincipalType fromMetastoreApiPrincipalType(org.apache.hadoop.hive.metastore.api.PrincipalType principalType) {
        switch (principalType) {
            case USER: {
                return PrincipalType.USER;
            }
            case ROLE: {
                return PrincipalType.ROLE;
            }
        }
        throw new IllegalArgumentException("Unsupported principal type: " + principalType);
    }

    public static FieldSchema toMetastoreApiFieldSchema(Column column) {
        return new FieldSchema(column.getName(), column.getType().getHiveTypeName().toString(), (String)column.getComment().orElse(null));
    }

    public static Column fromMetastoreApiFieldSchema(FieldSchema fieldSchema) {
        return new Column(fieldSchema.getName(), HiveType.valueOf(fieldSchema.getType()), Optional.ofNullable(Strings.emptyToNull((String)fieldSchema.getComment())));
    }

    public static void fromMetastoreApiStorageDescriptor(StorageDescriptor storageDescriptor, Storage.Builder builder, String tablePartitionName) {
        SerDeInfo serdeInfo = storageDescriptor.getSerdeInfo();
        if (serdeInfo == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table storage descriptor is missing SerDe info");
        }
        builder.setStorageFormat(StorageFormat.createNullable(serdeInfo.getSerializationLib(), storageDescriptor.getInputFormat(), storageDescriptor.getOutputFormat())).setLocation(Strings.nullToEmpty((String)storageDescriptor.getLocation())).setBucketProperty(HiveBucketProperty.fromStorageDescriptor(storageDescriptor, tablePartitionName)).setSorted(storageDescriptor.isSetSortCols() && !storageDescriptor.getSortCols().isEmpty()).setSkewed(storageDescriptor.isSetSkewedInfo() && storageDescriptor.getSkewedInfo().isSetSkewedColNames() && !storageDescriptor.getSkewedInfo().getSkewedColNames().isEmpty()).setSerdeParameters((Map<String, String>)(serdeInfo.getParameters() == null ? ImmutableMap.of() : serdeInfo.getParameters()));
    }

    private static StorageDescriptor makeStorageDescriptor(String tableName, List<Column> columns, Storage storage) {
        if (storage.isSorted() || storage.isSkewed()) {
            throw new IllegalArgumentException("Writing to sorted and/or skewed table/partition is not supported");
        }
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(tableName);
        serdeInfo.setSerializationLib(storage.getStorageFormat().getSerDeNullable());
        serdeInfo.setParameters(storage.getSerdeParameters());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(Strings.emptyToNull((String)storage.getLocation()));
        sd.setCols(columns.stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(Collectors.toList()));
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(storage.getStorageFormat().getInputFormatNullable());
        sd.setOutputFormat(storage.getStorageFormat().getOutputFormatNullable());
        sd.setParameters((Map)ImmutableMap.of());
        Optional<HiveBucketProperty> bucketProperty = storage.getBucketProperty();
        if (bucketProperty.isPresent()) {
            sd.setNumBuckets(bucketProperty.get().getBucketCount());
            sd.setBucketCols(bucketProperty.get().getBucketedBy());
        }
        return sd;
    }
}

