/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcRecordReader;
import com.facebook.presto.orc.memory.AggregatedMemoryContext;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;

public class OrcPageSource
implements ConnectorPageSource {
    private static final int NULL_ENTRY_SIZE = 0;
    private final OrcRecordReader recordReader;
    private final OrcDataSource orcDataSource;
    private final List<String> columnNames;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int batchId;
    private boolean closed;
    private final AggregatedMemoryContext systemMemoryContext;
    private final FileFormatDataSourceStats stats;

    public OrcPageSource(OrcRecordReader recordReader, OrcDataSource orcDataSource, List<HiveColumnHandle> columns, TypeManager typeManager, AggregatedMemoryContext systemMemoryContext, FileFormatDataSourceStats stats) {
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        int size = Objects.requireNonNull(columns, "columns is null").size();
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            Preconditions.checkState((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (Object)"column type must be regular");
            String name = column.getName();
            Type type = typeManager.getType(column.getTypeSignature());
            namesBuilder.add((Object)name);
            typesBuilder.add((Object)type);
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
            if (recordReader.isColumnPresent(column.getHiveColumnIndex())) continue;
            BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1024, 0);
            for (int i = 0; i < 1024; ++i) {
                blockBuilder.appendNull();
            }
            this.constantBlocks[columnIndex] = blockBuilder.build();
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            int batchSize = this.recordReader.nextBatch();
            if (batchSize <= 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                Type type = this.types.get(fieldId);
                blocks[fieldId] = this.constantBlocks[fieldId] != null ? this.constantBlocks[fieldId].getRegion(0, batchSize) : new LazyBlock(batchSize, (LazyBlockLoader)new OrcBlockLoader(this.hiveColumnIndexes[fieldId], type));
            }
            return new Page(batchSize, blocks);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.stats.addMaxCombinedBytesPerRow(this.recordReader.getMaxCombinedBytesPerRow());
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnNames", this.columnNames).add("types", this.types).toString();
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryContext.getBytes();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private final class OrcBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final int columnIndex;
        private final Type type;
        private boolean loaded;

        public OrcBlockLoader(int columnIndex, Type type) {
            this.expectedBatchId = OrcPageSource.this.batchId;
            this.columnIndex = columnIndex;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((OrcPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                Block block = OrcPageSource.this.recordReader.readBlock(this.type, this.columnIndex);
                lazyBlock.setBlock(block);
            }
            catch (IOException e) {
                if (e instanceof OrcCorruptionException) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
                }
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

