/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.dictionary;

import com.facebook.presto.hive.parquet.ParquetDictionaryPage;
import com.facebook.presto.hive.parquet.dictionary.ParquetDictionary;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import parquet.column.values.plain.PlainValuesReader;

public class ParquetFloatDictionary
extends ParquetDictionary {
    private final float[] content;

    public ParquetFloatDictionary(ParquetDictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        this.content = new float[dictionaryPage.getDictionarySize()];
        PlainValuesReader.FloatPlainValuesReader floatReader = new PlainValuesReader.FloatPlainValuesReader();
        floatReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryPage.getSlice().getBytes(), 0);
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = floatReader.readFloat();
        }
    }

    @Override
    public float decodeToFloat(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

