/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.DictionaryEncoder;
import com.facebook.hive.orc.DynamicIntArray;
import com.facebook.hive.orc.DynamicLongArray;
import com.facebook.hive.orc.SerializationUtils;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.io.IOException;
import java.io.OutputStream;

class IntDictionaryEncoder
extends DictionaryEncoder {
    private long newKey;
    private int numElements = 0;
    private final int numBytes;
    private final boolean useVInts;
    protected final DynamicLongArray keys = new DynamicLongArray();
    protected final DynamicIntArray counts = new DynamicIntArray();
    protected Long2IntOpenHashMapWithByteSize dictionary = new Long2IntOpenHashMapWithByteSize();

    public IntDictionaryEncoder(int numBytes, boolean useVInts) {
        this.numBytes = numBytes;
        this.useVInts = useVInts;
    }

    public IntDictionaryEncoder(boolean sortKeys, int numBytes, boolean useVInts) {
        super(sortKeys);
        this.numBytes = numBytes;
        this.useVInts = useVInts;
    }

    public long getValue(int position) {
        return this.keys.get(position);
    }

    public void visitDictionary(DictionaryEncoder.Visitor<Long> visitor, IntDictionaryEncoderVisitorContext context) throws IOException {
        int[] keysArray = null;
        if (this.sortKeys) {
            keysArray = new int[this.numElements];
            for (int idx = 0; idx < this.numElements; ++idx) {
                keysArray[idx] = idx;
            }
            IntArrays.quickSort((int[])keysArray, (IntComparator)new LongPositionComparator());
        }
        for (int pos = 0; pos < this.numElements; ++pos) {
            context.setOriginalPosition(keysArray == null ? pos : keysArray[pos]);
            visitor.visit(context);
        }
        keysArray = null;
    }

    public void visit(DictionaryEncoder.Visitor<Long> visitor) throws IOException {
        this.visitDictionary(visitor, new IntDictionaryEncoderVisitorContext());
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.counts.clear();
        this.dictionary = new Long2IntOpenHashMapWithByteSize();
        this.numElements = 0;
    }

    private int compareValue(long k, long cmpKey) {
        if (k > cmpKey) {
            return 1;
        }
        if (k < cmpKey) {
            return -1;
        }
        return 0;
    }

    public int add(long value) {
        this.newKey = value;
        if (this.dictionary.containsKey(value)) {
            int index = this.dictionary.get(value);
            this.counts.increment(index, 1);
            return this.dictionary.get(value);
        }
        int valRow = this.numElements++;
        this.dictionary.put(value, valRow);
        this.keys.add(this.newKey);
        this.counts.add(1);
        return valRow;
    }

    public long getByteSize() {
        long posSizes = this.dictionary.getByteSize();
        return this.keys.getSizeInBytes() + (long)this.counts.getSizeInBytes() + posSizes;
    }

    @Override
    public int getUncompressedLength() {
        return this.numElements * 8;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public class IntDictionaryEncoderVisitorContext
    implements DictionaryEncoder.VisitorContext<Long> {
        int originalPosition;

        public void setOriginalPosition(int pos) {
            this.originalPosition = pos;
        }

        @Override
        public int getOriginalPosition() {
            return this.originalPosition;
        }

        @Override
        public Long getKey() {
            return IntDictionaryEncoder.this.keys.get(this.originalPosition);
        }

        @Override
        public void writeBytes(OutputStream outputStream) throws IOException {
            long cur = IntDictionaryEncoder.this.keys.get(this.originalPosition);
            SerializationUtils.writeIntegerType(outputStream, cur, IntDictionaryEncoder.this.numBytes, true, IntDictionaryEncoder.this.useVInts);
        }

        @Override
        public int getLength() {
            return 8;
        }

        @Override
        public int getCount() {
            return IntDictionaryEncoder.this.counts.get(this.originalPosition);
        }

        @Override
        public int getIndexStride() {
            throw new UnsupportedOperationException("IntDictionaryEncoder does not currently track the index stride");
        }
    }

    public class LongPositionComparator
    implements IntComparator {
        public int compare(Integer pos, Integer cmpPos) {
            return this.compare((int)pos, (int)cmpPos);
        }

        public int compare(int pos, int cmpPos) {
            return IntDictionaryEncoder.this.compareValue(IntDictionaryEncoder.this.keys.get(pos), IntDictionaryEncoder.this.keys.get(cmpPos));
        }
    }

    private class Long2IntOpenHashMapWithByteSize
    extends Long2IntOpenHashMap {
        private static final long serialVersionUID = 0L;

        public int getByteSize() {
            int size = this.key.length * 8 + this.value.length * 4 + this.used.length;
            if (size + 5000 >= this.maxFill) {
                return (int)((float)size / this.f);
            }
            return size;
        }
    }
}

