/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    static void writeVulong(OutputStream output, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.write((byte)value);
                return;
            }
            output.write((byte)(0x80L | value & 0x7FL));
            value >>>= 7;
        }
    }

    static void writeVslong(OutputStream output, long value) throws IOException {
        SerializationUtils.writeVulong(output, value << 1 ^ value >> 63);
    }

    static void writeIntegerType(OutputStream output, long value, int numBytes) throws IOException {
        for (int i = 0; i < numBytes; ++i) {
            output.write((int)(value & 0xFFL));
            value >>>= 8;
        }
    }

    static long readVulong(InputStream in) throws IOException {
        long b;
        long result = 0L;
        int offset = 0;
        do {
            if ((b = (long)in.read()) == -1L) {
                throw new EOFException("Reading Vulong past EOF");
            }
            result |= (0x7FL & b) << offset;
            offset += 7;
        } while (b >= 128L);
        return result;
    }

    static long readVslong(InputStream in) throws IOException {
        long result = SerializationUtils.readVulong(in);
        return result >>> 1 ^ -(result & 1L);
    }

    static long readIntegerType(InputStream in, int numBytes) throws IOException {
        long result = 0L;
        int offset = 0;
        for (int i = 0; i < numBytes; ++i) {
            long b = in.read();
            if (b == -1L) {
                throw new EOFException("Reading Vulong past EOF");
            }
            result |= (0xFFL & b) << offset;
            offset += 8;
        }
        return result;
    }

    static void writeIntegerType(OutputStream output, long value, int numBytes, boolean signed, boolean useVInts) throws IOException {
        if (useVInts) {
            if (signed) {
                SerializationUtils.writeVslong(output, value);
            } else {
                SerializationUtils.writeVulong(output, value);
            }
        } else {
            SerializationUtils.writeIntegerType(output, value, numBytes);
        }
    }

    public static long readIntegerType(InputStream in, int numBytes, boolean signed, boolean useVInts) throws IOException {
        if (useVInts) {
            if (signed) {
                return SerializationUtils.readVslong(in);
            }
            return SerializationUtils.readVulong(in);
        }
        return SerializationUtils.readIntegerType(in, numBytes);
    }

    public static float readFloat(InputStream in) throws IOException {
        int ser = in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
        return Float.intBitsToFloat(ser);
    }

    static void writeFloat(OutputStream output, float value) throws IOException {
        int ser = Float.floatToIntBits(value);
        output.write(ser & 0xFF);
        output.write(ser >> 8 & 0xFF);
        output.write(ser >> 16 & 0xFF);
        output.write(ser >> 24 & 0xFF);
    }

    public static double readDouble(InputStream in) throws IOException {
        long ser = (long)in.read() | (long)in.read() << 8 | (long)in.read() << 16 | (long)in.read() << 24 | (long)in.read() << 32 | (long)in.read() << 40 | (long)in.read() << 48 | (long)in.read() << 56;
        return Double.longBitsToDouble(ser);
    }

    static void writeDouble(OutputStream output, double value) throws IOException {
        long ser = Double.doubleToLongBits(value);
        output.write((int)ser & 0xFF);
        output.write((int)(ser >> 8) & 0xFF);
        output.write((int)(ser >> 16) & 0xFF);
        output.write((int)(ser >> 24) & 0xFF);
        output.write((int)(ser >> 32) & 0xFF);
        output.write((int)(ser >> 40) & 0xFF);
        output.write((int)(ser >> 48) & 0xFF);
        output.write((int)(ser >> 56) & 0xFF);
    }
}

