/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.RunLengthIntegerReader;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LazyListTreeReader
extends LazyTreeReader {
    private final LazyTreeReader elementReader;
    private RunLengthIntegerReader lengths;

    public LazyListTreeReader(int columnId, long rowIndexStride, LazyTreeReader elementReader) {
        super(columnId, rowIndexStride);
        this.elementReader = elementReader;
    }

    @Override
    public Object next(Object previous) throws IOException {
        ArrayList<Object> result = null;
        if (this.valuePresent) {
            int i;
            result = previous == null ? new ArrayList<Object>() : (ArrayList<Object>)previous;
            int prevLength = result.size();
            int length = this.nextLength();
            for (i = prevLength; i < length; ++i) {
                result.add(null);
            }
            for (i = 0; i < length; ++i) {
                result.set(i, this.elementReader.getInComplexType(i < prevLength ? result.get(i) : null, this.previousRow));
            }
            for (i = prevLength - 1; i >= length; --i) {
                result.remove(i);
            }
        }
        return result;
    }

    @Override
    protected void seek(int rowIndexEntry, boolean backwards) throws IOException {
        super.seek(rowIndexEntry, backwards);
        this.elementReader.seek(rowIndexEntry, backwards);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.elementReader.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.lengths = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, 4);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.lengths.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        return this.lengths.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    public int nextLength() throws IOException {
        return (int)this.lengths.next();
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        long childSkip = 0L;
        for (long i = 0L; i < numNonNullValues; ++i) {
            childSkip += this.lengths.next();
        }
        this.elementReader.skipRowsInComplexType(childSkip);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.elementReader != null) {
            this.elementReader.close();
        }
        if (this.lengths != null) {
            this.lengths.close();
        }
    }
}

