/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.RunLengthIntegerReader;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.WriterImpl;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;

public class LazyTimestampTreeReader
extends LazyTreeReader {
    private RunLengthIntegerReader data;
    private RunLengthIntegerReader nanos;

    public LazyTimestampTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.data = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), true, 8);
        this.nanos = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.NANO_DATA)), false, 8);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.data.seek(index);
        this.nanos.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        updatedStartIndex = this.data.loadIndeces(rowIndexEntries, updatedStartIndex);
        return this.nanos.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    @Override
    public Object next(Object previous) throws IOException {
        TimestampWritable result = null;
        if (this.valuePresent) {
            result = previous == null ? new TimestampWritable() : (TimestampWritable)previous;
            long millis = (this.data.next() + WriterImpl.BASE_TIMESTAMP) * 1000L;
            int newNanos = LazyTimestampTreeReader.parseNanos(this.nanos.next());
            millis = millis >= 0L ? (millis += (long)(newNanos / 1000000)) : (millis -= (long)(newNanos / 1000000));
            Timestamp timestamp = result.getTimestamp();
            timestamp.setTime(millis);
            timestamp.setNanos(newNanos);
            result.set(timestamp);
        }
        return result;
    }

    private static int parseNanos(long serialized) {
        int zeros = 7 & (int)serialized;
        int result = (int)serialized >>> 3;
        if (zeros != 0) {
            for (int i = 0; i <= zeros; ++i) {
                result *= 10;
            }
        }
        return result;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        this.data.skip(numNonNullValues);
        this.nanos.skip(numNonNullValues);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.data != null) {
            this.data.close();
        }
        if (this.nanos != null) {
            this.nanos.close();
        }
    }
}

