/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.binary;

import com.facebook.presto.rcfile.RcFileDecoderUtils;
import com.facebook.presto.rcfile.binary.BinaryColumnEncoding;
import com.facebook.presto.rcfile.binary.BlockEncoding;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class ListEncoding
extends BlockEncoding {
    private final BinaryColumnEncoding elementEncoding;

    public ListEncoding(Type type, BinaryColumnEncoding elementEncoding) {
        super(type);
        this.elementEncoding = elementEncoding;
    }

    @Override
    public void encodeValue(Block block, int position, SliceOutput output) {
        int elementIndex;
        Block list = (Block)block.getObject(position, Block.class);
        RcFileDecoderUtils.writeVInt(output, list.getPositionCount());
        int nullByte = 0;
        for (elementIndex = 0; elementIndex < list.getPositionCount(); ++elementIndex) {
            if (elementIndex != 0 && elementIndex % 8 == 0) {
                output.writeByte(nullByte);
                nullByte = 0;
            }
            if (list.isNull(elementIndex)) continue;
            nullByte |= 1 << elementIndex % 8;
        }
        output.writeByte(nullByte);
        for (elementIndex = 0; elementIndex < list.getPositionCount(); ++elementIndex) {
            if (list.isNull(elementIndex)) continue;
            this.elementEncoding.encodeValueInto(list, elementIndex, output);
        }
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        int nullByteEnd;
        int entries = Math.toIntExact(RcFileDecoderUtils.readVInt(slice, offset));
        offset += RcFileDecoderUtils.decodeVIntSize(slice.getByte(offset));
        int nullByteCur = offset;
        int elementOffset = nullByteEnd = offset + (entries + 7) / 8;
        BlockBuilder arrayBuilder = builder.beginBlockEntry();
        for (int i = 0; i < entries; ++i) {
            if ((slice.getByte(nullByteCur) & 1 << i % 8) != 0) {
                int valueOffset = this.elementEncoding.getValueOffset(slice, elementOffset);
                int valueLength = this.elementEncoding.getValueLength(slice, elementOffset);
                this.elementEncoding.decodeValueInto(arrayBuilder, slice, elementOffset + valueOffset, valueLength);
                elementOffset = elementOffset + valueOffset + valueLength;
            } else {
                arrayBuilder.appendNull();
            }
            if (7 != i % 8) continue;
            ++nullByteCur;
        }
        builder.closeEntry();
    }
}

