/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ForFileRename;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HiveStagingFileCommitter
implements StagingFileCommitter {
    private final HdfsEnvironment hdfsEnvironment;
    private final ListeningExecutorService commitExecutor;

    @Inject
    public HiveStagingFileCommitter(HdfsEnvironment hdfsEnvironment, @ForFileRename ExecutorService executorService) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.commitExecutor = MoreExecutors.listeningDecorator((ExecutorService)executorService);
    }

    @Override
    public void commitFiles(ConnectorSession session, String schemaName, String tableName, List<PartitionUpdate> partitionUpdates) {
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, schemaName, tableName);
        ArrayList commitFutures = new ArrayList();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            Path path = partitionUpdate.getWritePath();
            FileSystem fileSystem = MetastoreUtil.getFileSystem(this.hdfsEnvironment, context, path);
            for (PartitionUpdate.FileWriteInfo fileWriteInfo : partitionUpdate.getFileWriteInfos()) {
                Preconditions.checkState((!fileWriteInfo.getWriteFileName().equals(fileWriteInfo.getTargetFileName()) ? 1 : 0) != 0);
                Path source = new Path(path, fileWriteInfo.getWriteFileName());
                Path target = new Path(path, fileWriteInfo.getTargetFileName());
                commitFutures.add(this.commitExecutor.submit(() -> MetastoreUtil.renameFile(fileSystem, source, target)));
            }
        }
        MetastoreUtil.waitForListenableFutures(commitFutures);
    }
}

