/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.spi.HostAddress;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import javax.annotation.concurrent.NotThreadSafe;
import org.openjdk.jol.info.ClassLayout;

@NotThreadSafe
public class InternalHiveSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(InternalHiveSplit.class).instanceSize() + ClassLayout.parseClass(String.class).instanceSize() + ClassLayout.parseClass(Properties.class).instanceSize() + ClassLayout.parseClass(String.class).instanceSize() + ClassLayout.parseClass(OptionalInt.class).instanceSize();
    private static final int INTEGER_INSTANCE_SIZE = ClassLayout.parseClass(Integer.class).instanceSize();
    private final String path;
    private final long end;
    private final long fileSize;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final List<InternalHiveBlock> blocks;
    private final String partitionName;
    private final OptionalInt readBucketNumber;
    private final OptionalInt tableBucketNumber;
    private final boolean splittable;
    private final boolean forceLocalScheduling;
    private final Map<Integer, HiveTypeName> columnCoercions;
    private final Optional<HiveSplit.BucketConversion> bucketConversion;
    private final boolean s3SelectPushdownEnabled;
    private long start;
    private int currentBlockIndex;

    public InternalHiveSplit(String partitionName, String path, long start, long end, long fileSize, Properties schema, List<HivePartitionKey> partitionKeys, List<InternalHiveBlock> blocks, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable, boolean forceLocalScheduling, Map<Integer, HiveTypeName> columnCoercions, Optional<HiveSplit.BucketConversion> bucketConversion, boolean s3SelectPushdownEnabled) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be positive");
        Preconditions.checkArgument((end >= 0L ? 1 : 0) != 0, (Object)"length must be positive");
        Preconditions.checkArgument((fileSize >= 0L ? 1 : 0) != 0, (Object)"fileSize must be positive");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(blocks, "blocks is null");
        Objects.requireNonNull(readBucketNumber, "readBucketNumber is null");
        Objects.requireNonNull(tableBucketNumber, "tableBucketNumber is null");
        Objects.requireNonNull(columnCoercions, "columnCoercions is null");
        Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        this.partitionName = partitionName;
        this.path = path;
        this.start = start;
        this.end = end;
        this.fileSize = fileSize;
        this.schema = schema;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.blocks = ImmutableList.copyOf(blocks);
        this.readBucketNumber = readBucketNumber;
        this.tableBucketNumber = tableBucketNumber;
        this.splittable = splittable;
        this.forceLocalScheduling = forceLocalScheduling;
        this.columnCoercions = ImmutableMap.copyOf(columnCoercions);
        this.bucketConversion = bucketConversion;
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
    }

    public String getPath() {
        return this.path;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    public Properties getSchema() {
        return this.schema;
    }

    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public OptionalInt getReadBucketNumber() {
        return this.readBucketNumber;
    }

    public OptionalInt getTableBucketNumber() {
        return this.tableBucketNumber;
    }

    public boolean isSplittable() {
        return this.splittable;
    }

    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    public Map<Integer, HiveTypeName> getColumnCoercions() {
        return this.columnCoercions;
    }

    public Optional<HiveSplit.BucketConversion> getBucketConversion() {
        return this.bucketConversion;
    }

    public InternalHiveBlock currentBlock() {
        Preconditions.checkState((!this.isDone() ? 1 : 0) != 0, (Object)"All blocks have been consumed");
        return this.blocks.get(this.currentBlockIndex);
    }

    public boolean isDone() {
        return this.currentBlockIndex == this.blocks.size();
    }

    public void increaseStart(long value) {
        this.start += value;
        if (this.start == this.currentBlock().getEnd()) {
            ++this.currentBlockIndex;
            if (this.isDone()) {
                return;
            }
            Verify.verify((this.start == this.currentBlock().getStart() ? 1 : 0) != 0);
        }
    }

    public int getEstimatedSizeInBytes() {
        int result = INSTANCE_SIZE;
        result += this.path.length() * 2;
        result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.partitionKeys.size()));
        for (HivePartitionKey partitionKey : this.partitionKeys) {
            result += partitionKey.getEstimatedSizeInBytes();
        }
        result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.blocks.size()));
        for (InternalHiveBlock block : this.blocks) {
            result += block.getEstimatedSizeInBytes();
        }
        result += this.partitionName.length() * 2;
        result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.columnCoercions.size()));
        for (HiveTypeName hiveTypeName : this.columnCoercions.values()) {
            result += INTEGER_INSTANCE_SIZE + hiveTypeName.getEstimatedSizeInBytes();
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("start", this.start).add("end", this.end).add("fileSize", this.fileSize).toString();
    }

    public static class InternalHiveBlock {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(InternalHiveBlock.class).instanceSize();
        private static final int HOST_ADDRESS_INSTANCE_SIZE = ClassLayout.parseClass(HostAddress.class).instanceSize() + ClassLayout.parseClass(String.class).instanceSize();
        private final long start;
        private final long end;
        private final List<HostAddress> addresses;

        public InternalHiveBlock(long start, long end, List<HostAddress> addresses) {
            Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"block end cannot be before block start");
            this.start = start;
            this.end = end;
            this.addresses = ImmutableList.copyOf(addresses);
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public List<HostAddress> getAddresses() {
            return this.addresses;
        }

        public int getEstimatedSizeInBytes() {
            int result = INSTANCE_SIZE;
            result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.addresses.size()));
            for (HostAddress address : this.addresses) {
                result += HOST_ADDRESS_INSTANCE_SIZE + address.getHostText().length() * 2;
            }
            return result;
        }
    }
}

