/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.authentication;

import com.facebook.presto.hive.ForHdfs;
import com.facebook.presto.hive.ForHiveMetastore;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.facebook.presto.hive.authentication.CachingKerberosHadoopAuthentication;
import com.facebook.presto.hive.authentication.DirectHdfsAuthentication;
import com.facebook.presto.hive.authentication.HadoopAuthentication;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.HdfsKerberosConfig;
import com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import com.facebook.presto.hive.authentication.ImpersonatingHdfsAuthentication;
import com.facebook.presto.hive.authentication.KerberosAuthentication;
import com.facebook.presto.hive.authentication.KerberosHadoopAuthentication;
import com.facebook.presto.hive.authentication.KerberosHiveMetastoreAuthentication;
import com.facebook.presto.hive.authentication.MetastoreKerberosConfig;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHiveMetastoreAuthentication;
import com.facebook.presto.hive.authentication.SimpleHadoopAuthentication;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.ConfigBinder;
import javax.inject.Inject;

public final class AuthenticationModules {
    private AuthenticationModules() {
    }

    public static Module noHiveMetastoreAuthenticationModule() {
        return binder -> binder.bind(HiveMetastoreAuthentication.class).to(NoHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
    }

    public static Module kerberosHiveMetastoreAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HiveMetastoreAuthentication.class).to(KerberosHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(MetastoreKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHiveMetastore
            HadoopAuthentication createHadoopAuthentication(MetastoreKerberosConfig config, HdfsConfigurationUpdater updater) {
                String principal = config.getHiveMetastoreClientPrincipal();
                String keytabLocation = config.getHiveMetastoreClientKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation, updater);
            }
        };
    }

    public static Module noHdfsAuthenticationModule() {
        return binder -> binder.bind(HdfsAuthentication.class).to(NoHdfsAuthentication.class).in(Scopes.SINGLETON);
    }

    public static Module simpleImpersonatingHdfsAuthenticationModule() {
        return binder -> {
            binder.bind(Key.get(HadoopAuthentication.class, ForHdfs.class)).to(SimpleHadoopAuthentication.class);
            binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
        };
    }

    public static Module kerberosHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HdfsAuthentication.class).to(DirectHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config, HdfsConfigurationUpdater updater) {
                String principal = config.getHdfsPrestoPrincipal();
                String keytabLocation = config.getHdfsPrestoKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation, updater);
            }
        };
    }

    public static Module kerberosImpersonatingHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config, HdfsConfigurationUpdater updater) {
                String principal = config.getHdfsPrestoPrincipal();
                String keytabLocation = config.getHdfsPrestoKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation, updater);
            }
        };
    }

    private static HadoopAuthentication createCachingKerberosHadoopAuthentication(String principal, String keytabLocation, HdfsConfigurationUpdater updater) {
        KerberosAuthentication kerberosAuthentication = new KerberosAuthentication(principal, keytabLocation);
        KerberosHadoopAuthentication kerberosHadoopAuthentication = KerberosHadoopAuthentication.createKerberosHadoopAuthentication(kerberosAuthentication, updater);
        return new CachingKerberosHadoopAuthentication(kerberosHadoopAuthentication);
    }
}

