/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.HiveTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PartitionFilter {
    private final HiveTableName hiveTableName;
    private final List<String> parts;

    @JsonCreator
    public PartitionFilter(@JsonProperty(value="hiveTableName") HiveTableName hiveTableName, @JsonProperty(value="parts") List<String> parts) {
        this.hiveTableName = Objects.requireNonNull(hiveTableName, "hiveTableName is null");
        this.parts = ImmutableList.copyOf((Collection)Objects.requireNonNull(parts, "parts is null"));
    }

    public static PartitionFilter partitionFilter(String databaseName, String tableName, List<String> parts) {
        return new PartitionFilter(HiveTableName.hiveTableName(databaseName, tableName), parts);
    }

    @JsonProperty
    public HiveTableName getHiveTableName() {
        return this.hiveTableName;
    }

    @JsonProperty
    public List<String> getParts() {
        return this.parts;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("parts", this.parts).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionFilter other = (PartitionFilter)o;
        return Objects.equals(this.hiveTableName, other.hiveTableName) && Objects.equals(this.parts, other.parts);
    }

    public int hashCode() {
        return Objects.hash(this.hiveTableName, this.parts);
    }
}

