/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.PartitionStatistics;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.facebook.presto.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public interface HiveMetastore {
    public void createDatabase(Database var1);

    public void dropDatabase(String var1);

    public void alterDatabase(String var1, Database var2);

    public void createTable(Table var1);

    public void dropTable(String var1, String var2, boolean var3);

    public void alterTable(String var1, String var2, Table var3);

    public List<String> getAllDatabases();

    public Optional<List<String>> getAllTables(String var1);

    public Optional<List<String>> getAllViews(String var1);

    public Optional<Database> getDatabase(String var1);

    public void addPartitions(String var1, String var2, List<PartitionWithStatistics> var3);

    public void dropPartition(String var1, String var2, List<String> var3, boolean var4);

    public void alterPartition(String var1, String var2, PartitionWithStatistics var3);

    public Optional<List<String>> getPartitionNames(String var1, String var2);

    public Optional<List<String>> getPartitionNamesByParts(String var1, String var2, List<String> var3);

    public Optional<Partition> getPartition(String var1, String var2, List<String> var3);

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3);

    public Optional<Table> getTable(String var1, String var2);

    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type var1);

    public PartitionStatistics getTableStatistics(String var1, String var2);

    public Map<String, PartitionStatistics> getPartitionStatistics(String var1, String var2, Set<String> var3);

    public void updateTableStatistics(String var1, String var2, Function<PartitionStatistics, PartitionStatistics> var3);

    public void updatePartitionStatistics(String var1, String var2, String var3, Function<PartitionStatistics, PartitionStatistics> var4);

    public void createRole(String var1, String var2);

    public void dropRole(String var1);

    public Set<String> listRoles();

    public void grantRoles(Set<String> var1, Set<PrestoPrincipal> var2, boolean var3, PrestoPrincipal var4);

    public void revokeRoles(Set<String> var1, Set<PrestoPrincipal> var2, boolean var3, PrestoPrincipal var4);

    public Set<RoleGrant> listRoleGrants(PrestoPrincipal var1);

    public void grantTablePrivileges(String var1, String var2, PrestoPrincipal var3, Set<HivePrivilegeInfo> var4);

    public void revokeTablePrivileges(String var1, String var2, PrestoPrincipal var3, Set<HivePrivilegeInfo> var4);

    public Set<HivePrivilegeInfo> listTablePrivileges(String var1, String var2, PrestoPrincipal var3);

    default public boolean isTableOwner(String user, String databaseName, String tableName) {
        Optional<Table> table = this.getTable(databaseName, tableName);
        return table.isPresent() && user.equals(table.get().getOwner());
    }

    default public Optional<List<FieldSchema>> getFields(String databaseName, String tableName) {
        Optional<Table> table = this.getTable(databaseName, tableName);
        if (!table.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        if (table.get().getSd() == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        return Optional.of(table.get().getSd().getCols());
    }
}

