/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcRecordReader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TempFileReader
extends AbstractIterator<Page> {
    private final List<Type> types;
    private final OrcRecordReader reader;

    public TempFileReader(List<Type> types, OrcDataSource dataSource) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        try {
            OrcReader orcReader = new OrcReader(dataSource, OrcEncoding.ORC, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(16.0, DataSize.Unit.MEGABYTE));
            HashMap<Integer, Type> includedColumns = new HashMap<Integer, Type>();
            for (int i = 0; i < types.size(); ++i) {
                includedColumns.put(i, types.get(i));
            }
            this.reader = orcReader.createRecordReader(includedColumns, OrcPredicate.TRUE, DateTimeZone.UTC, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to read temporary data");
        }
    }

    protected Page computeNext() {
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int batchSize = this.reader.nextBatch();
            if (batchSize <= 0) {
                return (Page)this.endOfData();
            }
            Block[] blocks = new Block[this.types.size()];
            for (int i = 0; i < this.types.size(); ++i) {
                blocks[i] = this.reader.readBlock(this.types.get(i), i).getLoadedBlock();
            }
            return new Page(batchSize, blocks);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to read temporary data");
        }
    }
}

