/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ColumnEncoding {
    public static final int DEFAULT_SEQUENCE_ID = 0;
    private final ColumnEncodingKind columnEncodingKind;
    private final int dictionarySize;
    private final Optional<List<DwrfSequenceEncoding>> additionalSequenceEncodings;

    public ColumnEncoding(ColumnEncodingKind columnEncodingKind, int dictionarySize) {
        this(columnEncodingKind, dictionarySize, Optional.empty());
    }

    public ColumnEncoding(ColumnEncodingKind columnEncodingKind, int dictionarySize, Optional<List<DwrfSequenceEncoding>> additionalSequenceEncodings) {
        this.columnEncodingKind = Objects.requireNonNull(columnEncodingKind, "columnEncodingKind is null");
        this.dictionarySize = dictionarySize;
        this.additionalSequenceEncodings = additionalSequenceEncodings;
    }

    public ColumnEncodingKind getColumnEncodingKind() {
        return this.columnEncodingKind;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public Optional<List<DwrfSequenceEncoding>> getAdditionalSequenceEncodings() {
        return this.additionalSequenceEncodings;
    }

    public ColumnEncoding getColumnEncoding(int sequence) {
        if (sequence == 0) {
            return this;
        }
        Preconditions.checkState((boolean)this.additionalSequenceEncodings.isPresent(), (String)"Got non-zero sequence: %d, but there are no additional sequence encodings: %s", (int)sequence, (Object)this);
        return this.additionalSequenceEncodings.get().get(sequence - 1).getValueEncoding();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnEncodingKind", (Object)this.columnEncodingKind).add("dictionarySize", this.dictionarySize).add("additionalSequenceEncodings", this.additionalSequenceEncodings).toString();
    }

    public static enum ColumnEncodingKind {
        DIRECT,
        DICTIONARY,
        DIRECT_V2,
        DICTIONARY_V2,
        DWRF_DIRECT,
        DWRF_MAP_FLAT;

    }
}

