/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DoubleStatisticsBuilder
implements StatisticsBuilder {
    private long nonNullValueCount;
    private boolean hasNan;
    private double minimum = Double.POSITIVE_INFINITY;
    private double maximum = Double.NEGATIVE_INFINITY;

    @Override
    public void addBlock(Type type, Block block) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            double value = type == RealType.REAL ? (double)Float.intBitsToFloat((int)type.getLong(block, position)) : type.getDouble(block, position);
            this.addValue(value);
        }
    }

    public void addValue(double value) {
        ++this.nonNullValueCount;
        if (Double.isNaN(value)) {
            this.hasNan = true;
        } else {
            this.minimum = Math.min(value, this.minimum);
            this.maximum = Math.max(value, this.maximum);
        }
    }

    private void addDoubleStatistics(long valueCount, DoubleStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        this.minimum = Math.min(value.getMin(), this.minimum);
        this.maximum = Math.max(value.getMax(), this.maximum);
    }

    private Optional<DoubleStatistics> buildDoubleStatistics() {
        if (this.nonNullValueCount == 0L || this.hasNan) {
            return Optional.empty();
        }
        return Optional.of(new DoubleStatistics(this.minimum, this.maximum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<DoubleStatistics> doubleStatistics = this.buildDoubleStatistics();
        return new ColumnStatistics(this.nonNullValueCount, doubleStatistics.map(s -> 9L).orElse(0L), null, null, doubleStatistics.orElse(null), null, null, null, null, null);
    }

    public static Optional<DoubleStatistics> mergeDoubleStatistics(List<ColumnStatistics> stats) {
        DoubleStatisticsBuilder doubleStatisticsBuilder = new DoubleStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            DoubleStatistics partialStatistics = columnStatistics.getDoubleStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            doubleStatisticsBuilder.addDoubleStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return doubleStatisticsBuilder.buildDoubleStatistics();
    }
}

