/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class CheckpointInputStreamSource<S extends ValueInputStream<C>, C extends StreamCheckpoint>
implements InputStreamSource<S> {
    private final S stream;
    private final C checkpoint;

    public static <S extends ValueInputStream<C>, C extends StreamCheckpoint> CheckpointInputStreamSource<S, C> createCheckpointStreamSource(S stream, StreamCheckpoint checkpoint) {
        Objects.requireNonNull(stream, "stream is null");
        Objects.requireNonNull(checkpoint, "checkpoint is null");
        StreamCheckpoint verifiedCheckpoint = checkpoint;
        return new CheckpointInputStreamSource<S, StreamCheckpoint>(stream, verifiedCheckpoint);
    }

    public CheckpointInputStreamSource(S stream, C checkpoint) {
        this.stream = (ValueInputStream)Objects.requireNonNull(stream, "stream is null");
        this.checkpoint = (StreamCheckpoint)Objects.requireNonNull(checkpoint, "checkpoint is null");
    }

    @Override
    public Class<S> getStreamType() {
        return this.stream.getClass();
    }

    @Override
    @Nullable
    public S openStream() throws IOException {
        this.stream.seekToCheckpoint(this.checkpoint);
        return this.stream;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stream", this.stream).add("checkpoint", this.checkpoint).toString();
    }
}

