/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.io.IOException;

public interface LongInputStream
extends ValueInputStream<LongStreamCheckpoint> {
    public long next() throws IOException;

    default public void nextIntVector(int items, int[] vector, int offset) throws IOException {
        Preconditions.checkPositionIndex((int)(items + offset), (int)vector.length);
        for (int i = offset; i < items + offset; ++i) {
            vector[i] = Math.toIntExact(this.next());
        }
    }

    default public void nextIntVector(int items, int[] vector, int vectorOffset, boolean[] isNull) throws IOException {
        Preconditions.checkPositionIndex((int)(items + vectorOffset), (int)vector.length);
        Preconditions.checkPositionIndex((int)items, (int)isNull.length);
        for (int i = 0; i < items; ++i) {
            if (isNull[i]) continue;
            vector[i + vectorOffset] = Math.toIntExact(this.next());
        }
    }

    default public void nextLongVector(int items, long[] vector) throws IOException {
        Preconditions.checkPositionIndex((int)items, (int)vector.length);
        for (int i = 0; i < items; ++i) {
            vector[i] = this.next();
        }
    }

    default public void nextLongVector(Type type, int items, BlockBuilder builder) throws IOException {
        for (int i = 0; i < items; ++i) {
            type.writeLong(builder, this.next());
        }
    }

    default public long sum(int items) throws IOException {
        long sum = 0L;
        for (int i = 0; i < items; ++i) {
            sum += this.next();
        }
        return sum;
    }
}

