/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamV2Checkpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class LongOutputStreamV2
implements LongOutputStream {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongOutputStreamV2.class).instanceSize();
    private static final int MAX_SCOPE = 512;
    private static final int MIN_REPEAT = 3;
    private static final int MAX_SHORT_REPEAT_LENGTH = 10;
    private final Stream.StreamKind streamKind;
    private final OrcOutputBuffer buffer;
    private final List<LongStreamCheckpoint> checkpoints = new ArrayList<LongStreamCheckpoint>();
    private long prevDelta;
    private int fixedRunLength;
    private int variableRunLength;
    private final long[] literals = new long[512];
    private final boolean signed;
    private int numLiterals;
    private final long[] zigzagLiterals = new long[512];
    private final long[] baseReducedLiterals = new long[512];
    private final long[] adjDeltas = new long[512];
    private long fixedDelta;
    private int zzBits90p;
    private int zzBits100p;
    private int brBits95p;
    private int brBits100p;
    private int bitsDeltaMax;
    private int patchWidth;
    private int patchGapWidth;
    private int patchLength;
    private long[] gapVsPatchList;
    private long min;
    private boolean isFixedDelta = true;
    private final SerializationUtils utils = new SerializationUtils();
    private boolean closed;

    public LongOutputStreamV2(CompressionKind compression, int bufferSize, boolean signed, Stream.StreamKind streamKind) {
        this.streamKind = Objects.requireNonNull(streamKind, "streamKind is null");
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
        this.signed = signed;
    }

    @Override
    public void writeLong(long value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.numLiterals == 0) {
            this.initializeLiterals(value);
            return;
        }
        if (this.numLiterals == 1) {
            this.prevDelta = value - this.literals[0];
            this.literals[this.numLiterals++] = value;
            if (value == this.literals[0]) {
                this.fixedRunLength = 2;
                this.variableRunLength = 0;
            } else {
                this.fixedRunLength = 0;
                this.variableRunLength = 2;
            }
            return;
        }
        if (this.prevDelta == 0L && value == this.literals[this.numLiterals - 1]) {
            this.literals[this.numLiterals++] = value;
            if (this.variableRunLength > 0) {
                this.fixedRunLength = 2;
            }
            ++this.fixedRunLength;
            if (this.fixedRunLength >= 3 && this.variableRunLength > 0) {
                this.numLiterals -= 3;
                this.variableRunLength -= 2;
                long[] tailValues = new long[3];
                System.arraycopy(this.literals, this.numLiterals, tailValues, 0, 3);
                this.writeValues(this.determineEncoding());
                for (long tailValue : tailValues) {
                    this.literals[this.numLiterals++] = tailValue;
                }
            }
            if (this.fixedRunLength == 512) {
                this.writeValues(this.determineEncoding());
            }
            return;
        }
        if (this.fixedRunLength >= 3) {
            if (this.fixedRunLength <= 10) {
                this.writeValues(EncodingType.SHORT_REPEAT);
            } else {
                this.isFixedDelta = true;
                this.writeValues(EncodingType.DELTA);
            }
        }
        if (this.fixedRunLength > 0 && this.fixedRunLength < 3 && value != this.literals[this.numLiterals - 1]) {
            this.variableRunLength = this.fixedRunLength;
            this.fixedRunLength = 0;
        }
        if (this.numLiterals == 0) {
            this.initializeLiterals(value);
        } else {
            this.prevDelta = value - this.literals[this.numLiterals - 1];
            this.literals[this.numLiterals++] = value;
            ++this.variableRunLength;
            if (this.variableRunLength == 512) {
                this.writeValues(this.determineEncoding());
            }
        }
    }

    private void initializeLiterals(long val) {
        this.literals[this.numLiterals++] = val;
        this.fixedRunLength = 1;
        this.variableRunLength = 1;
    }

    private EncodingType determineEncoding() {
        int i;
        long initialDelta;
        if (this.signed) {
            for (int i1 = 0; i1 < this.numLiterals; ++i1) {
                this.zigzagLiterals[i1] = SerializationUtils.zigzagEncode(this.literals[i1]);
            }
        } else {
            System.arraycopy(this.literals, 0, this.zigzagLiterals, 0, this.numLiterals);
        }
        this.zzBits100p = SerializationUtils.percentileBits(this.zigzagLiterals, 0, this.numLiterals, 1.0);
        if (this.numLiterals <= 3) {
            return EncodingType.DIRECT;
        }
        boolean isIncreasing = true;
        boolean isDecreasing = true;
        this.isFixedDelta = true;
        this.min = this.literals[0];
        long max = this.literals[0];
        long currDelta = initialDelta = this.literals[1] - this.literals[0];
        long deltaMax = initialDelta;
        this.adjDeltas[0] = initialDelta;
        for (i = 1; i < this.numLiterals; ++i) {
            long l1 = this.literals[i];
            long l0 = this.literals[i - 1];
            currDelta = l1 - l0;
            this.min = Math.min(this.min, l1);
            max = Math.max(max, l1);
            isIncreasing &= l0 <= l1;
            isDecreasing &= l0 >= l1;
            this.isFixedDelta &= currDelta == initialDelta;
            if (i <= 1) continue;
            this.adjDeltas[i - 1] = Math.abs(currDelta);
            deltaMax = Math.max(deltaMax, this.adjDeltas[i - 1]);
        }
        if (!SerializationUtils.isSafeSubtract(max, this.min)) {
            return EncodingType.DIRECT;
        }
        if (initialDelta != 0L) {
            if (this.min == max) {
                throw new IllegalStateException("currDelta should be zero");
            }
            if (this.isFixedDelta) {
                this.fixedDelta = currDelta;
                return EncodingType.DELTA;
            }
            this.bitsDeltaMax = SerializationUtils.findClosestNumBits(deltaMax);
            if (isIncreasing || isDecreasing) {
                return EncodingType.DELTA;
            }
        }
        this.zzBits90p = SerializationUtils.percentileBits(this.zigzagLiterals, 0, this.numLiterals, 0.9);
        if (this.zzBits100p - this.zzBits90p <= 1) {
            return EncodingType.DIRECT;
        }
        for (i = 0; i < this.numLiterals; ++i) {
            this.baseReducedLiterals[i] = this.literals[i] - this.min;
        }
        this.brBits95p = SerializationUtils.percentileBits(this.baseReducedLiterals, 0, this.numLiterals, 0.95);
        this.brBits100p = SerializationUtils.percentileBits(this.baseReducedLiterals, 0, this.numLiterals, 1.0);
        if (this.brBits100p == this.brBits95p) {
            return EncodingType.DIRECT;
        }
        return EncodingType.PATCHED_BASE;
    }

    private void writeValues(EncodingType encoding) {
        if (this.numLiterals == 0) {
            return;
        }
        switch (encoding) {
            case SHORT_REPEAT: {
                this.writeShortRepeatValues();
                break;
            }
            case DIRECT: {
                this.writeDirectValues();
                break;
            }
            case PATCHED_BASE: {
                this.writePatchedBaseValues();
                break;
            }
            default: {
                this.writeDeltaValues();
            }
        }
        this.clearEncoder();
    }

    private void writeShortRepeatValues() {
        long repeatVal = this.signed ? SerializationUtils.zigzagEncode(this.literals[0]) : this.literals[0];
        int numBitsRepeatVal = SerializationUtils.findClosestNumBits(repeatVal);
        int numBytesRepeatVal = numBitsRepeatVal % 8 == 0 ? numBitsRepeatVal >>> 3 : (numBitsRepeatVal >>> 3) + 1;
        int header = EncodingType.SHORT_REPEAT.getOpCode();
        header |= numBytesRepeatVal - 1 << 3;
        this.fixedRunLength -= 3;
        this.buffer.write(header |= this.fixedRunLength);
        for (int i = numBytesRepeatVal - 1; i >= 0; --i) {
            int b = (int)(repeatVal >>> i * 8 & 0xFFL);
            this.buffer.write(b);
        }
        this.fixedRunLength = 0;
    }

    private void writeDirectValues() {
        int fixedBits = SerializationUtils.getClosestAlignedFixedBits(this.zzBits100p);
        int encodeBitWidth = SerializationUtils.encodeBitWidth(fixedBits) << 1;
        --this.variableRunLength;
        int tailBits = (this.variableRunLength & 0x100) >>> 8;
        int headerFirstByte = EncodingType.DIRECT.getOpCode() | encodeBitWidth | tailBits;
        int headerSecondByte = this.variableRunLength & 0xFF;
        this.buffer.write(headerFirstByte);
        this.buffer.write(headerSecondByte);
        this.utils.writeInts(this.zigzagLiterals, 0, this.numLiterals, fixedBits, this.buffer);
        this.variableRunLength = 0;
    }

    private void writeDeltaValues() {
        int length;
        int fixedBits = SerializationUtils.getClosestAlignedFixedBits(this.bitsDeltaMax);
        int encodeBitWidth = 0;
        if (this.isFixedDelta) {
            if (this.fixedRunLength > 3) {
                length = this.fixedRunLength - 1;
                this.fixedRunLength = 0;
            } else {
                length = this.variableRunLength - 1;
                this.variableRunLength = 0;
            }
        } else {
            if (fixedBits == 1) {
                fixedBits = 2;
            }
            encodeBitWidth = SerializationUtils.encodeBitWidth(fixedBits) << 1;
            length = this.variableRunLength - 1;
            this.variableRunLength = 0;
        }
        int tailBits = (length & 0x100) >>> 8;
        int headerFirstByte = EncodingType.DELTA.getOpCode() | encodeBitWidth | tailBits;
        int headerSecondByte = length & 0xFF;
        this.buffer.write(headerFirstByte);
        this.buffer.write(headerSecondByte);
        if (this.signed) {
            SerializationUtils.writeVslong(this.buffer, this.literals[0]);
        } else {
            SerializationUtils.writeVulong(this.buffer, this.literals[0]);
        }
        if (this.isFixedDelta) {
            SerializationUtils.writeVslong(this.buffer, this.fixedDelta);
        } else {
            SerializationUtils.writeVslong(this.buffer, this.adjDeltas[0]);
            this.utils.writeInts(this.adjDeltas, 1, this.numLiterals - 2, fixedBits, this.buffer);
        }
    }

    private void writePatchedBaseValues() {
        int baseWidth;
        boolean isNegative;
        this.preparePatchedBlob();
        int fb = this.brBits95p;
        int efb = SerializationUtils.encodeBitWidth(fb) << 1;
        --this.variableRunLength;
        int tailBits = (this.variableRunLength & 0x100) >>> 8;
        int headerFirstByte = EncodingType.PATCHED_BASE.getOpCode() | efb | tailBits;
        int headerSecondByte = this.variableRunLength & 0xFF;
        boolean bl = isNegative = this.min < 0L;
        if (isNegative) {
            this.min = -this.min;
        }
        int baseBytes = (baseWidth = SerializationUtils.findClosestNumBits(this.min) + 1) % 8 == 0 ? baseWidth / 8 : baseWidth / 8 + 1;
        int bb = baseBytes - 1 << 5;
        if (isNegative) {
            this.min |= 1L << baseBytes * 8 - 1;
        }
        int headerThirdByte = bb | SerializationUtils.encodeBitWidth(this.patchWidth);
        int headerFourthByte = this.patchGapWidth - 1 << 5 | this.patchLength;
        this.buffer.write(headerFirstByte);
        this.buffer.write(headerSecondByte);
        this.buffer.write(headerThirdByte);
        this.buffer.write(headerFourthByte);
        for (int i = baseBytes - 1; i >= 0; --i) {
            byte b = (byte)(this.min >>> i * 8 & 0xFFL);
            this.buffer.write(b);
        }
        int closestFixedBits = SerializationUtils.getClosestFixedBits(fb);
        this.utils.writeInts(this.baseReducedLiterals, 0, this.numLiterals, closestFixedBits, this.buffer);
        closestFixedBits = SerializationUtils.getClosestFixedBits(this.patchGapWidth + this.patchWidth);
        this.utils.writeInts(this.gapVsPatchList, 0, this.gapVsPatchList.length, closestFixedBits, this.buffer);
        this.variableRunLength = 0;
    }

    private void preparePatchedBlob() {
        int i;
        long mask = (1L << this.brBits95p) - 1L;
        this.patchLength = (int)Math.ceil((double)this.numLiterals * 0.05);
        int[] gapList = new int[this.patchLength];
        long[] patchList = new long[this.patchLength];
        this.patchWidth = this.brBits100p - this.brBits95p;
        this.patchWidth = SerializationUtils.getClosestFixedBits(this.patchWidth);
        if (this.patchWidth == 64) {
            this.patchWidth = 56;
            this.brBits95p = 8;
            mask = (1L << this.brBits95p) - 1L;
        }
        int gapIdx = 0;
        int patchIdx = 0;
        int prev = 0;
        int maxGap = 0;
        for (i = 0; i < this.numLiterals; ++i) {
            if (this.baseReducedLiterals[i] <= mask) continue;
            int gap = i - prev;
            if (gap > maxGap) {
                maxGap = gap;
            }
            prev = i;
            gapList[gapIdx++] = gap;
            long patch = this.baseReducedLiterals[i] >>> this.brBits95p;
            patchList[patchIdx++] = patch;
            int n = i;
            this.baseReducedLiterals[n] = this.baseReducedLiterals[n] & mask;
        }
        this.patchLength = gapIdx;
        this.patchGapWidth = maxGap == 0 && this.patchLength != 0 ? 1 : SerializationUtils.findClosestNumBits(maxGap);
        if (this.patchGapWidth > 8) {
            this.patchGapWidth = 8;
            this.patchLength = maxGap == 511 ? (this.patchLength += 2) : ++this.patchLength;
        }
        gapIdx = 0;
        patchIdx = 0;
        this.gapVsPatchList = new long[this.patchLength];
        for (i = 0; i < this.patchLength; ++i) {
            long g;
            long p = patchList[patchIdx++];
            for (g = (long)gapList[gapIdx++]; g > 255L; g -= 255L) {
                this.gapVsPatchList[i++] = 255L << this.patchWidth;
            }
            this.gapVsPatchList[i] = g << this.patchWidth | p;
        }
    }

    private void clearEncoder() {
        this.numLiterals = 0;
        this.prevDelta = 0L;
        this.fixedDelta = 0L;
        this.zzBits90p = 0;
        this.zzBits100p = 0;
        this.brBits95p = 0;
        this.brBits100p = 0;
        this.bitsDeltaMax = 0;
        this.patchGapWidth = 0;
        this.patchLength = 0;
        this.patchWidth = 0;
        this.gapVsPatchList = null;
        this.min = 0L;
        this.isFixedDelta = true;
    }

    public void flush() {
        if (this.numLiterals == 0) {
            return;
        }
        if (this.variableRunLength != 0) {
            this.writeValues(this.determineEncoding());
            return;
        }
        if (this.fixedRunLength == 0) {
            throw new IllegalStateException("literals does not agree with run length counters");
        }
        if (this.fixedRunLength < 3) {
            this.variableRunLength = this.fixedRunLength;
            this.fixedRunLength = 0;
            this.writeValues(this.determineEncoding());
            return;
        }
        if (this.fixedRunLength >= 3 && this.fixedRunLength <= 10) {
            this.writeValues(EncodingType.SHORT_REPEAT);
            return;
        }
        this.isFixedDelta = true;
        this.writeValues(EncodingType.DELTA);
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new LongStreamV2Checkpoint(this.numLiterals, this.buffer.getCheckpoint()));
    }

    @Override
    public void close() {
        this.closed = true;
        this.flush();
        this.buffer.close();
    }

    @Override
    public List<LongStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(int column) {
        return new StreamDataOutput(this.buffer::writeDataTo, new Stream(column, this.streamKind, Math.toIntExact(this.buffer.getOutputDataSize()), true));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.estimateOutputDataSize() + (long)(8 * this.numLiterals);
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize() + SizeOf.sizeOf((long[])this.literals) + SizeOf.sizeOf((long[])this.zigzagLiterals) + SizeOf.sizeOf((long[])this.baseReducedLiterals) + SizeOf.sizeOf((long[])this.adjDeltas) + SizeOf.sizeOf((long[])this.gapVsPatchList);
    }

    @Override
    public void reset() {
        this.clearEncoder();
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }

    static final class SerializationUtils {
        private static final int BUFFER_SIZE = 64;
        private final byte[] writeBuffer = new byte[64];

        SerializationUtils() {
        }

        static void writeVulong(SliceOutput output, long value) {
            while (true) {
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    output.write((int)((byte)value));
                    return;
                }
                output.write((int)((byte)(0x80L | value & 0x7FL)));
                value >>>= 7;
            }
        }

        static void writeVslong(SliceOutput output, long value) {
            SerializationUtils.writeVulong(output, value << 1 ^ value >> 63);
        }

        static int findClosestNumBits(long value) {
            int count = 0;
            while (value != 0L) {
                ++count;
                value >>>= 1;
            }
            return SerializationUtils.getClosestFixedBits(count);
        }

        static long zigzagEncode(long value) {
            return value << 1 ^ value >> 63;
        }

        static int percentileBits(long[] data, int offset, int length, double percentile) {
            Preconditions.checkArgument((percentile <= 1.0 && percentile > 0.0 ? 1 : 0) != 0);
            int[] hist = new int[32];
            for (int i = offset; i < offset + length; ++i) {
                int idx;
                int n = idx = SerializationUtils.encodeBitWidth(SerializationUtils.findClosestNumBits(data[i]));
                hist[n] = hist[n] + 1;
            }
            int perLen = (int)((double)length * (1.0 - percentile));
            for (int i = hist.length - 1; i >= 0; --i) {
                if ((perLen -= hist[i]) >= 0) continue;
                return SerializationUtils.decodeBitWidth(i);
            }
            return 0;
        }

        static int getClosestFixedBits(int n) {
            if (n == 0) {
                return 1;
            }
            if (n >= 1 && n <= 24) {
                return n;
            }
            if (n > 24 && n <= 26) {
                return 26;
            }
            if (n > 26 && n <= 28) {
                return 28;
            }
            if (n > 28 && n <= 30) {
                return 30;
            }
            if (n > 30 && n <= 32) {
                return 32;
            }
            if (n > 32 && n <= 40) {
                return 40;
            }
            if (n > 40 && n <= 48) {
                return 48;
            }
            if (n > 48 && n <= 56) {
                return 56;
            }
            return 64;
        }

        public static int getClosestAlignedFixedBits(int n) {
            if (n == 0 || n == 1) {
                return 1;
            }
            if (n > 1 && n <= 2) {
                return 2;
            }
            if (n > 2 && n <= 4) {
                return 4;
            }
            if (n > 4 && n <= 8) {
                return 8;
            }
            if (n > 8 && n <= 16) {
                return 16;
            }
            if (n > 16 && n <= 24) {
                return 24;
            }
            if (n > 24 && n <= 32) {
                return 32;
            }
            if (n > 32 && n <= 40) {
                return 40;
            }
            if (n > 40 && n <= 48) {
                return 48;
            }
            if (n > 48 && n <= 56) {
                return 56;
            }
            return 64;
        }

        static int encodeBitWidth(int n) {
            if ((n = SerializationUtils.getClosestFixedBits(n)) >= 1 && n <= 24) {
                return n - 1;
            }
            if (n > 24 && n <= 26) {
                return FixedBitSizes.TWENTY_SIX.ordinal();
            }
            if (n > 26 && n <= 28) {
                return FixedBitSizes.TWENTY_EIGHT.ordinal();
            }
            if (n > 28 && n <= 30) {
                return FixedBitSizes.THIRTY.ordinal();
            }
            if (n > 30 && n <= 32) {
                return FixedBitSizes.THIRTY_TWO.ordinal();
            }
            if (n > 32 && n <= 40) {
                return FixedBitSizes.FORTY.ordinal();
            }
            if (n > 40 && n <= 48) {
                return FixedBitSizes.FORTY_EIGHT.ordinal();
            }
            if (n > 48 && n <= 56) {
                return FixedBitSizes.FIFTY_SIX.ordinal();
            }
            return FixedBitSizes.SIXTY_FOUR.ordinal();
        }

        static int decodeBitWidth(int n) {
            if (n >= FixedBitSizes.ONE.ordinal() && n <= FixedBitSizes.TWENTY_FOUR.ordinal()) {
                return n + 1;
            }
            if (n == FixedBitSizes.TWENTY_SIX.ordinal()) {
                return 26;
            }
            if (n == FixedBitSizes.TWENTY_EIGHT.ordinal()) {
                return 28;
            }
            if (n == FixedBitSizes.THIRTY.ordinal()) {
                return 30;
            }
            if (n == FixedBitSizes.THIRTY_TWO.ordinal()) {
                return 32;
            }
            if (n == FixedBitSizes.FORTY.ordinal()) {
                return 40;
            }
            if (n == FixedBitSizes.FORTY_EIGHT.ordinal()) {
                return 48;
            }
            if (n == FixedBitSizes.FIFTY_SIX.ordinal()) {
                return 56;
            }
            return 64;
        }

        void writeInts(long[] input, int offset, int length, int bitSize, SliceOutput output) {
            Objects.requireNonNull(input, "input is null");
            Preconditions.checkArgument((input.length != 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((length >= 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((bitSize >= 1 ? 1 : 0) != 0);
            switch (bitSize) {
                case 1: {
                    SerializationUtils.unrolledBitPack1(input, offset, length, output);
                    return;
                }
                case 2: {
                    SerializationUtils.unrolledBitPack2(input, offset, length, output);
                    return;
                }
                case 4: {
                    SerializationUtils.unrolledBitPack4(input, offset, length, output);
                    return;
                }
                case 8: {
                    this.unrolledBitPack8(input, offset, length, output);
                    return;
                }
                case 16: {
                    this.unrolledBitPack16(input, offset, length, output);
                    return;
                }
                case 24: {
                    this.unrolledBitPack24(input, offset, length, output);
                    return;
                }
                case 32: {
                    this.unrolledBitPack32(input, offset, length, output);
                    return;
                }
                case 40: {
                    this.unrolledBitPack40(input, offset, length, output);
                    return;
                }
                case 48: {
                    this.unrolledBitPack48(input, offset, length, output);
                    return;
                }
                case 56: {
                    this.unrolledBitPack56(input, offset, length, output);
                    return;
                }
                case 64: {
                    this.unrolledBitPack64(input, offset, length, output);
                    return;
                }
            }
            int bitsLeft = 8;
            int current = 0;
            for (int i = offset; i < offset + length; ++i) {
                long value = input[i];
                int bitsToWrite = bitSize;
                while (bitsToWrite > bitsLeft) {
                    current = (byte)((long)current | value >>> bitsToWrite - bitsLeft);
                    value &= (1L << (bitsToWrite -= bitsLeft)) - 1L;
                    output.write(current);
                    current = 0;
                    bitsLeft = 8;
                }
                current = (byte)((long)current | value << (bitsLeft -= bitsToWrite));
                if (bitsLeft != 0) continue;
                output.write(current);
                current = 0;
                bitsLeft = 8;
            }
            if (bitsLeft != 8) {
                output.write(current);
            }
        }

        private static void unrolledBitPack1(long[] input, int offset, int len, SliceOutput output) {
            int numHops = 8;
            int remainder = len % 8;
            int endOffset = offset + len;
            int endUnroll = endOffset - remainder;
            int val = 0;
            for (int i = offset; i < endUnroll; i += 8) {
                val = (int)((long)val | (input[i] & 1L) << 7 | (input[i + 1] & 1L) << 6 | (input[i + 2] & 1L) << 5 | (input[i + 3] & 1L) << 4 | (input[i + 4] & 1L) << 3 | (input[i + 5] & 1L) << 2 | (input[i + 6] & 1L) << 1 | input[i + 7] & 1L);
                output.write(val);
                val = 0;
            }
            if (remainder > 0) {
                int startShift = 7;
                for (int i = endUnroll; i < endOffset; ++i) {
                    val = (int)((long)val | (input[i] & 1L) << startShift);
                    --startShift;
                }
                output.write(val);
            }
        }

        private static void unrolledBitPack2(long[] input, int offset, int len, SliceOutput output) {
            int numHops = 4;
            int remainder = len % 4;
            int endOffset = offset + len;
            int endUnroll = endOffset - remainder;
            int val = 0;
            for (int i = offset; i < endUnroll; i += 4) {
                val = (int)((long)val | (input[i] & 3L) << 6 | (input[i + 1] & 3L) << 4 | (input[i + 2] & 3L) << 2 | input[i + 3] & 3L);
                output.write(val);
                val = 0;
            }
            if (remainder > 0) {
                int startShift = 6;
                for (int i = endUnroll; i < endOffset; ++i) {
                    val = (int)((long)val | (input[i] & 3L) << startShift);
                    startShift -= 2;
                }
                output.write(val);
            }
        }

        private static void unrolledBitPack4(long[] input, int offset, int len, SliceOutput output) {
            int numHops = 2;
            int remainder = len % 2;
            int endOffset = offset + len;
            int endUnroll = endOffset - remainder;
            int val = 0;
            for (int i = offset; i < endUnroll; i += 2) {
                val = (int)((long)val | (input[i] & 0xFL) << 4 | input[i + 1] & 0xFL);
                output.write(val);
                val = 0;
            }
            if (remainder > 0) {
                int startShift = 4;
                for (int i = endUnroll; i < endOffset; ++i) {
                    val = (int)((long)val | (input[i] & 0xFL) << startShift);
                    startShift -= 4;
                }
                output.write(val);
            }
        }

        private void unrolledBitPack8(long[] input, int offset, int len, SliceOutput output) {
            this.unrolledBitPackBytes(input, offset, len, output, 1);
        }

        private void unrolledBitPack16(long[] input, int offset, int len, SliceOutput output) {
            this.unrolledBitPackBytes(input, offset, len, output, 2);
        }

        private void unrolledBitPack24(long[] input, int offset, int len, SliceOutput output) {
            this.unrolledBitPackBytes(input, offset, len, output, 3);
        }

        private void unrolledBitPack32(long[] input, int offset, int len, SliceOutput output) {
            this.unrolledBitPackBytes(input, offset, len, output, 4);
        }

        private void unrolledBitPack40(long[] input, int offset, int len, SliceOutput output) {
            this.unrolledBitPackBytes(input, offset, len, output, 5);
        }

        private void unrolledBitPack48(long[] input, int offset, int len, SliceOutput output) {
            this.unrolledBitPackBytes(input, offset, len, output, 6);
        }

        private void unrolledBitPack56(long[] input, int offset, int len, SliceOutput output) {
            this.unrolledBitPackBytes(input, offset, len, output, 7);
        }

        private void unrolledBitPack64(long[] input, int offset, int len, SliceOutput output) {
            this.unrolledBitPackBytes(input, offset, len, output, 8);
        }

        private void unrolledBitPackBytes(long[] input, int offset, int len, SliceOutput output, int numBytes) {
            int i;
            int numHops = 8;
            int remainder = len % 8;
            int endOffset = offset + len;
            int endUnroll = endOffset - remainder;
            for (i = offset; i < endUnroll; i += 8) {
                this.writeLongBE(output, input, i, 8, numBytes);
            }
            if (remainder > 0) {
                this.writeRemainingLongs(output, i, input, remainder, numBytes);
            }
        }

        private void writeRemainingLongs(SliceOutput output, int offset, long[] input, int remainder, int numBytes) {
            int numHops = remainder;
            int idx = 0;
            switch (numBytes) {
                case 1: {
                    while (remainder > 0) {
                        this.writeBuffer[idx] = (byte)(input[offset + idx] & 0xFFL);
                        --remainder;
                        ++idx;
                    }
                    break;
                }
                case 2: {
                    while (remainder > 0) {
                        this.writeLongBE2(input[offset + idx], idx * 2);
                        --remainder;
                        ++idx;
                    }
                    break;
                }
                case 3: {
                    while (remainder > 0) {
                        this.writeLongBE3(input[offset + idx], idx * 3);
                        --remainder;
                        ++idx;
                    }
                    break;
                }
                case 4: {
                    while (remainder > 0) {
                        this.writeLongBE4(input[offset + idx], idx * 4);
                        --remainder;
                        ++idx;
                    }
                    break;
                }
                case 5: {
                    while (remainder > 0) {
                        this.writeLongBE5(input[offset + idx], idx * 5);
                        --remainder;
                        ++idx;
                    }
                    break;
                }
                case 6: {
                    while (remainder > 0) {
                        this.writeLongBE6(input[offset + idx], idx * 6);
                        --remainder;
                        ++idx;
                    }
                    break;
                }
                case 7: {
                    while (remainder > 0) {
                        this.writeLongBE7(input[offset + idx], idx * 7);
                        --remainder;
                        ++idx;
                    }
                    break;
                }
                case 8: {
                    while (remainder > 0) {
                        this.writeLongBE8(input[offset + idx], idx * 8);
                        --remainder;
                        ++idx;
                    }
                    break;
                }
            }
            int toWrite = numHops * numBytes;
            output.write(this.writeBuffer, 0, toWrite);
        }

        private void writeLongBE(SliceOutput output, long[] input, int offset, int numHops, int numBytes) {
            switch (numBytes) {
                case 1: {
                    this.writeBuffer[0] = (byte)(input[offset + 0] & 0xFFL);
                    this.writeBuffer[1] = (byte)(input[offset + 1] & 0xFFL);
                    this.writeBuffer[2] = (byte)(input[offset + 2] & 0xFFL);
                    this.writeBuffer[3] = (byte)(input[offset + 3] & 0xFFL);
                    this.writeBuffer[4] = (byte)(input[offset + 4] & 0xFFL);
                    this.writeBuffer[5] = (byte)(input[offset + 5] & 0xFFL);
                    this.writeBuffer[6] = (byte)(input[offset + 6] & 0xFFL);
                    this.writeBuffer[7] = (byte)(input[offset + 7] & 0xFFL);
                    break;
                }
                case 2: {
                    this.writeLongBE2(input[offset + 0], 0);
                    this.writeLongBE2(input[offset + 1], 2);
                    this.writeLongBE2(input[offset + 2], 4);
                    this.writeLongBE2(input[offset + 3], 6);
                    this.writeLongBE2(input[offset + 4], 8);
                    this.writeLongBE2(input[offset + 5], 10);
                    this.writeLongBE2(input[offset + 6], 12);
                    this.writeLongBE2(input[offset + 7], 14);
                    break;
                }
                case 3: {
                    this.writeLongBE3(input[offset + 0], 0);
                    this.writeLongBE3(input[offset + 1], 3);
                    this.writeLongBE3(input[offset + 2], 6);
                    this.writeLongBE3(input[offset + 3], 9);
                    this.writeLongBE3(input[offset + 4], 12);
                    this.writeLongBE3(input[offset + 5], 15);
                    this.writeLongBE3(input[offset + 6], 18);
                    this.writeLongBE3(input[offset + 7], 21);
                    break;
                }
                case 4: {
                    this.writeLongBE4(input[offset + 0], 0);
                    this.writeLongBE4(input[offset + 1], 4);
                    this.writeLongBE4(input[offset + 2], 8);
                    this.writeLongBE4(input[offset + 3], 12);
                    this.writeLongBE4(input[offset + 4], 16);
                    this.writeLongBE4(input[offset + 5], 20);
                    this.writeLongBE4(input[offset + 6], 24);
                    this.writeLongBE4(input[offset + 7], 28);
                    break;
                }
                case 5: {
                    this.writeLongBE5(input[offset + 0], 0);
                    this.writeLongBE5(input[offset + 1], 5);
                    this.writeLongBE5(input[offset + 2], 10);
                    this.writeLongBE5(input[offset + 3], 15);
                    this.writeLongBE5(input[offset + 4], 20);
                    this.writeLongBE5(input[offset + 5], 25);
                    this.writeLongBE5(input[offset + 6], 30);
                    this.writeLongBE5(input[offset + 7], 35);
                    break;
                }
                case 6: {
                    this.writeLongBE6(input[offset + 0], 0);
                    this.writeLongBE6(input[offset + 1], 6);
                    this.writeLongBE6(input[offset + 2], 12);
                    this.writeLongBE6(input[offset + 3], 18);
                    this.writeLongBE6(input[offset + 4], 24);
                    this.writeLongBE6(input[offset + 5], 30);
                    this.writeLongBE6(input[offset + 6], 36);
                    this.writeLongBE6(input[offset + 7], 42);
                    break;
                }
                case 7: {
                    this.writeLongBE7(input[offset + 0], 0);
                    this.writeLongBE7(input[offset + 1], 7);
                    this.writeLongBE7(input[offset + 2], 14);
                    this.writeLongBE7(input[offset + 3], 21);
                    this.writeLongBE7(input[offset + 4], 28);
                    this.writeLongBE7(input[offset + 5], 35);
                    this.writeLongBE7(input[offset + 6], 42);
                    this.writeLongBE7(input[offset + 7], 49);
                    break;
                }
                case 8: {
                    this.writeLongBE8(input[offset + 0], 0);
                    this.writeLongBE8(input[offset + 1], 8);
                    this.writeLongBE8(input[offset + 2], 16);
                    this.writeLongBE8(input[offset + 3], 24);
                    this.writeLongBE8(input[offset + 4], 32);
                    this.writeLongBE8(input[offset + 5], 40);
                    this.writeLongBE8(input[offset + 6], 48);
                    this.writeLongBE8(input[offset + 7], 56);
                    break;
                }
            }
            int toWrite = numHops * numBytes;
            output.write(this.writeBuffer, 0, toWrite);
        }

        private void writeLongBE2(long val, int wbOffset) {
            this.writeBuffer[wbOffset + 0] = (byte)(val >>> 8);
            this.writeBuffer[wbOffset + 1] = (byte)(val >>> 0);
        }

        private void writeLongBE3(long val, int wbOffset) {
            this.writeBuffer[wbOffset + 0] = (byte)(val >>> 16);
            this.writeBuffer[wbOffset + 1] = (byte)(val >>> 8);
            this.writeBuffer[wbOffset + 2] = (byte)(val >>> 0);
        }

        private void writeLongBE4(long val, int wbOffset) {
            this.writeBuffer[wbOffset + 0] = (byte)(val >>> 24);
            this.writeBuffer[wbOffset + 1] = (byte)(val >>> 16);
            this.writeBuffer[wbOffset + 2] = (byte)(val >>> 8);
            this.writeBuffer[wbOffset + 3] = (byte)(val >>> 0);
        }

        private void writeLongBE5(long val, int wbOffset) {
            this.writeBuffer[wbOffset + 0] = (byte)(val >>> 32);
            this.writeBuffer[wbOffset + 1] = (byte)(val >>> 24);
            this.writeBuffer[wbOffset + 2] = (byte)(val >>> 16);
            this.writeBuffer[wbOffset + 3] = (byte)(val >>> 8);
            this.writeBuffer[wbOffset + 4] = (byte)(val >>> 0);
        }

        private void writeLongBE6(long val, int wbOffset) {
            this.writeBuffer[wbOffset + 0] = (byte)(val >>> 40);
            this.writeBuffer[wbOffset + 1] = (byte)(val >>> 32);
            this.writeBuffer[wbOffset + 2] = (byte)(val >>> 24);
            this.writeBuffer[wbOffset + 3] = (byte)(val >>> 16);
            this.writeBuffer[wbOffset + 4] = (byte)(val >>> 8);
            this.writeBuffer[wbOffset + 5] = (byte)(val >>> 0);
        }

        private void writeLongBE7(long val, int wbOffset) {
            this.writeBuffer[wbOffset + 0] = (byte)(val >>> 48);
            this.writeBuffer[wbOffset + 1] = (byte)(val >>> 40);
            this.writeBuffer[wbOffset + 2] = (byte)(val >>> 32);
            this.writeBuffer[wbOffset + 3] = (byte)(val >>> 24);
            this.writeBuffer[wbOffset + 4] = (byte)(val >>> 16);
            this.writeBuffer[wbOffset + 5] = (byte)(val >>> 8);
            this.writeBuffer[wbOffset + 6] = (byte)(val >>> 0);
        }

        private void writeLongBE8(long val, int wbOffset) {
            this.writeBuffer[wbOffset + 0] = (byte)(val >>> 56);
            this.writeBuffer[wbOffset + 1] = (byte)(val >>> 48);
            this.writeBuffer[wbOffset + 2] = (byte)(val >>> 40);
            this.writeBuffer[wbOffset + 3] = (byte)(val >>> 32);
            this.writeBuffer[wbOffset + 4] = (byte)(val >>> 24);
            this.writeBuffer[wbOffset + 5] = (byte)(val >>> 16);
            this.writeBuffer[wbOffset + 6] = (byte)(val >>> 8);
            this.writeBuffer[wbOffset + 7] = (byte)(val >>> 0);
        }

        public static boolean isSafeSubtract(long left, long right) {
            return (left ^ right) >= 0L | (left ^ left - right) >= 0L;
        }

        static enum FixedBitSizes {
            ONE,
            TWO,
            THREE,
            FOUR,
            FIVE,
            SIX,
            SEVEN,
            EIGHT,
            NINE,
            TEN,
            ELEVEN,
            TWELVE,
            THIRTEEN,
            FOURTEEN,
            FIFTEEN,
            SIXTEEN,
            SEVENTEEN,
            EIGHTEEN,
            NINETEEN,
            TWENTY,
            TWENTY_ONE,
            TWENTY_TWO,
            TWENTY_THREE,
            TWENTY_FOUR,
            TWENTY_SIX,
            TWENTY_EIGHT,
            THIRTY,
            THIRTY_TWO,
            FORTY,
            FORTY_EIGHT,
            FIFTY_SIX,
            SIXTY_FOUR;

        }
    }

    private static enum EncodingType {
        SHORT_REPEAT,
        DIRECT,
        PATCHED_BASE,
        DELTA;


        private int getOpCode() {
            return this.ordinal() << 6;
        }
    }
}

