/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.MuxOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DemuxDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hive.common.util.ReflectionUtil;

public class DemuxOperator
extends Operator<DemuxDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log LOG = LogFactory.getLog(DemuxOperator.class.getName());
    private transient long[] cntrs;
    private transient long[] nextCntrs;
    private int[] newTagToOldTag;
    private int[] newTagToChildIndex;
    private ObjectInspector[][] childInputObjInspectors;
    private int childrenDone;
    private int lastChildIndex;
    private int[][] newChildOperatorsTag;

    @Override
    protected Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        int i;
        Collection<Future<?>> result = super.initializeOp(hconf);
        if (this.childOperatorsArray.length == 0) {
            throw new HiveException("Expected number of children is at least 1. Found : " + this.childOperatorsArray.length);
        }
        this.newTagToOldTag = this.toArray(((DemuxDesc)this.conf).getNewTagToOldTag());
        this.newTagToChildIndex = this.toArray(((DemuxDesc)this.conf).getNewTagToChildIndex());
        this.childInputObjInspectors = new ObjectInspector[this.childOperators.size()][];
        this.cntrs = new long[this.newTagToOldTag.length];
        this.nextCntrs = new long[this.newTagToOldTag.length];
        try {
            for (i = 0; i < this.newTagToOldTag.length; ++i) {
                int newTag = i;
                int oldTag = this.newTagToOldTag[i];
                int childIndex = this.newTagToChildIndex[newTag];
                this.cntrs[newTag] = 0L;
                this.nextCntrs[newTag] = 0L;
                TableDesc keyTableDesc = ((DemuxDesc)this.conf).getKeysSerializeInfos().get(newTag);
                Deserializer inputKeyDeserializer = ReflectionUtil.newInstance(keyTableDesc.getDeserializerClass(), null);
                SerDeUtils.initializeSerDe(inputKeyDeserializer, null, keyTableDesc.getProperties(), null);
                TableDesc valueTableDesc = ((DemuxDesc)this.conf).getValuesSerializeInfos().get(newTag);
                Deserializer inputValueDeserializer = ReflectionUtil.newInstance(valueTableDesc.getDeserializerClass(), null);
                SerDeUtils.initializeSerDe(inputValueDeserializer, null, valueTableDesc.getProperties(), null);
                ArrayList<ObjectInspector> oi = new ArrayList<ObjectInspector>();
                oi.add(inputKeyDeserializer.getObjectInspector());
                oi.add(inputValueDeserializer.getObjectInspector());
                int childParentsCount = ((DemuxDesc)this.conf).getChildIndexToOriginalNumParents().get(childIndex);
                if (this.childInputObjInspectors[childIndex] == null) {
                    this.childInputObjInspectors[childIndex] = new ObjectInspector[childParentsCount];
                }
                ObjectInspector[] ois = this.childInputObjInspectors[childIndex];
                ois[oldTag] = ObjectInspectorFactory.getStandardStructObjectInspector(Utilities.reduceFieldNameList, oi);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.childrenDone = 0;
        this.newChildOperatorsTag = new int[this.childOperators.size()][];
        for (i = 0; i < this.childOperators.size(); ++i) {
            Operator child = (Operator)this.childOperators.get(i);
            ArrayList<Integer> childOperatorTags = new ArrayList<Integer>();
            if (child instanceof MuxOperator) {
                int index = 0;
                for (Operator<OperatorDesc> parent : child.getParentOperators()) {
                    if (this == parent) {
                        childOperatorTags.add(index);
                    }
                    ++index;
                }
            } else {
                childOperatorTags.add(child.getParentOperators().indexOf(this));
            }
            this.newChildOperatorsTag[i] = this.toArray(childOperatorTags);
        }
        if (this.isLogInfoEnabled) {
            LOG.info("newChildOperatorsTag " + Arrays.toString((Object[])this.newChildOperatorsTag));
        }
        return result;
    }

    private int[] toArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    private int[] toArray(Map<Integer, Integer> map) {
        int[] array = new int[map.size()];
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            array[entry.getKey().intValue()] = entry.getValue();
        }
        return array;
    }

    @Override
    protected void initializeChildren(Configuration hconf) throws HiveException {
        int i;
        this.state = Operator.State.INIT;
        if (this.isLogInfoEnabled) {
            LOG.info("Operator " + this.id + " " + this.getName() + " initialized");
            LOG.info("Initializing children of " + this.id + " " + this.getName());
        }
        for (i = 0; i < this.childOperatorsArray.length; ++i) {
            if (this.isLogInfoEnabled) {
                LOG.info("Initializing child " + i + " " + this.childOperatorsArray[i].getIdentifier() + " " + this.childOperatorsArray[i].getName() + " " + this.childInputObjInspectors[i].length);
            }
            if (!(this.childOperatorsArray[i] instanceof MuxOperator)) continue;
            ObjectInspector[] ois = this.childInputObjInspectors[i];
            for (int j = 0; j < ois.length; ++j) {
                if (ois[j] == null) continue;
                this.childOperatorsArray[i].initialize(hconf, ois[j], j);
            }
            if (this.reporter == null) continue;
            this.childOperatorsArray[i].setReporter(this.reporter);
        }
        for (i = 0; i < this.childOperatorsArray.length; ++i) {
            if (this.isLogInfoEnabled) {
                LOG.info("Initializing child " + i + " " + this.childOperatorsArray[i].getIdentifier() + " " + this.childOperatorsArray[i].getName() + " " + this.childInputObjInspectors[i].length);
            }
            if (this.childOperatorsArray[i] instanceof MuxOperator) continue;
            this.childOperatorsArray[i].initialize(hconf, this.childInputObjInspectors[i]);
            if (this.reporter == null) continue;
            this.childOperatorsArray[i].setReporter(this.reporter);
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        Operator child;
        int currentChildIndex = this.newTagToChildIndex[tag];
        this.endGroupIfNecessary(currentChildIndex);
        int oldTag = this.newTagToOldTag[tag];
        if (this.isLogDebugEnabled) {
            int n = tag;
            this.cntrs[n] = this.cntrs[n] + 1L;
            if (this.cntrs[tag] == this.nextCntrs[tag]) {
                LOG.debug(this.id + " (newTag, childIndex, oldTag)=(" + tag + ", " + currentChildIndex + ", " + oldTag + "), forwarding " + this.cntrs[tag] + " rows");
                this.nextCntrs[tag] = this.getNextCntr(this.cntrs[tag]);
            }
        }
        if ((child = this.childOperatorsArray[currentChildIndex]).getDone()) {
            ++this.childrenDone;
        } else {
            child.process(row, oldTag);
        }
        if (this.childrenDone == this.childOperatorsArray.length) {
            this.setDone(true);
        }
    }

    @Override
    public void forward(Object row, ObjectInspector rowInspector) throws HiveException {
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        for (int i = 0; i < this.newTagToOldTag.length; ++i) {
            int newTag = i;
            int oldTag = this.newTagToOldTag[i];
            int childIndex = this.newTagToChildIndex[newTag];
            if (!this.isLogInfoEnabled) continue;
            LOG.info(this.id + " (newTag, childIndex, oldTag)=(" + newTag + ", " + childIndex + ", " + oldTag + "),  forwarded " + this.cntrs[newTag] + " rows");
        }
    }

    private void endGroupIfNecessary(int currentChildIndex) throws HiveException {
        if (this.lastChildIndex != currentChildIndex) {
            for (int i = this.lastChildIndex; i < currentChildIndex; ++i) {
                Operator child = this.childOperatorsArray[i];
                child.flush();
                child.endGroup();
                for (int childTag : this.newChildOperatorsTag[i]) {
                    child.processGroup(childTag);
                }
            }
            this.lastChildIndex = currentChildIndex;
        }
    }

    @Override
    public void startGroup() throws HiveException {
        this.lastChildIndex = 0;
        super.startGroup();
    }

    @Override
    public void endGroup() throws HiveException {
        if (this.childOperators == null) {
            return;
        }
        for (int i = this.lastChildIndex; i < this.childOperatorsArray.length; ++i) {
            Operator child = this.childOperatorsArray[i];
            child.flush();
            child.endGroup();
            for (int childTag : this.newChildOperatorsTag[i]) {
                child.processGroup(childTag);
            }
        }
    }

    @Override
    public String getName() {
        return DemuxOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "DEMUX";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.DEMUX;
    }
}

