/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterExprOrExpr
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final transient int[] initialSelected = new int[1024];
    private transient int[] unselected = new int[1024];
    private final transient int[] tmp = new int[1024];

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        int i;
        int j;
        int n = batch.size;
        if (n <= 0) {
            return;
        }
        VectorExpression childExpr1 = this.childExpressions[0];
        VectorExpression childExpr2 = this.childExpressions[1];
        boolean prevSelectInUse = batch.selectedInUse;
        int[] sel = batch.selected;
        if (batch.selectedInUse) {
            System.arraycopy(sel, 0, this.initialSelected, 0, n);
        } else {
            for (int i2 = 0; i2 < n; ++i2) {
                this.initialSelected[i2] = i2;
                sel[i2] = i2;
            }
            batch.selectedInUse = true;
        }
        childExpr1.evaluate(batch);
        int sizeAfterFirstChild = batch.size;
        int[] selectedAfterFirstChild = batch.selected;
        for (j = 0; j < n; ++j) {
            this.tmp[this.initialSelected[j]] = 0;
        }
        for (j = 0; j < batch.size; ++j) {
            this.tmp[selectedAfterFirstChild[j]] = 1;
        }
        int unselectedSize = 0;
        for (int j2 = 0; j2 < n; ++j2) {
            i = this.initialSelected[j2];
            if (this.tmp[i] != 0) continue;
            this.unselected[unselectedSize++] = i;
        }
        batch.selected = this.unselected;
        batch.size = unselectedSize;
        childExpr2.evaluate(batch);
        int newSize = batch.size + sizeAfterFirstChild;
        for (i = 0; i < batch.size; ++i) {
            this.tmp[batch.selected[i]] = 1;
        }
        int k = 0;
        for (int j3 = 0; j3 < n; ++j3) {
            int i3 = this.initialSelected[j3];
            if (this.tmp[i3] != 1) continue;
            batch.selected[k++] = i3;
        }
        batch.size = newSize;
        if (newSize == n) {
            batch.selectedInUse = prevSelectInUse;
        }
        this.unselected = selectedAfterFirstChild;
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

