/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMultiSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorMapJoinInnerBigOnlyStringOperator
extends VectorMapJoinInnerBigOnlyGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(VectorMapJoinInnerBigOnlyStringOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinInnerBigOnlyStringOperator.class.getName();
    private transient VectorMapJoinBytesHashMultiSet hashMultiSet;
    private transient int singleJoinColumn;

    public VectorMapJoinInnerBigOnlyStringOperator() {
    }

    public VectorMapJoinInnerBigOnlyStringOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMultiSet = (VectorMapJoinBytesHashMultiSet)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " empty");
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            boolean numSel = false;
            BytesColumnVector joinColVector = (BytesColumnVector)batch.cols[this.singleJoinColumn];
            byte[][] vector = joinColVector.vector;
            int[] start = joinColVector.start;
            int[] length = joinColVector.length;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                byte[] keyBytes = vector[0];
                int keyStart = start[0];
                int keyLength = length[0];
                JoinUtil.JoinResult joinResult = this.hashMultiSet.contains(keyBytes, keyStart, keyLength, this.hashMultiSetResults[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                this.finishInnerBigOnlyRepeated(batch, joinResult, this.hashMultiSetResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMultiSetResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                int saveKeyBatchIndex = -1;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block21: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex;
                    int n = batchIndex = selectedInUse ? selected[logical] : logical;
                    if (!haveSaveKey || StringExpr.compare(vector[saveKeyBatchIndex], start[saveKeyBatchIndex], length[saveKeyBatchIndex], vector[batchIndex], start[batchIndex], length[batchIndex]) != 0) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMultiSetResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        saveKeyBatchIndex = batchIndex;
                        byte[] keyBytes = vector[batchIndex];
                        int keyStart = start[batchIndex];
                        int keyLength = length[batchIndex];
                        saveJoinResult = this.hashMultiSet.contains(keyBytes, keyStart, keyLength, this.hashMultiSetResults[hashMultiSetResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesValueCounts[equalKeySeriesCount] = this.hashMultiSetResults[hashMultiSetResultCount].count();
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMultiSetResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n2 = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n2] = this.equalKeySeriesDuplicateCounts[n2] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block21;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMultiSetResultCount;
                            ++spillCount;
                            continue block21;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMultiSetResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " allMatchs " + VectorMapJoinInnerBigOnlyStringOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesValueCounts " + VectorMapJoinInnerBigOnlyStringOperator.longArrayToRangesString(this.equalKeySeriesValueCounts, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinInnerBigOnlyStringOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesDuplicateCounts " + VectorMapJoinInnerBigOnlyStringOperator.intArrayToRangesString(this.equalKeySeriesDuplicateCounts, equalKeySeriesCount) + " spills " + VectorMapJoinInnerBigOnlyStringOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinInnerBigOnlyStringOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMultiSetResults, 0, hashMultiSetResultCount)));
                }
                this.finishInnerBigOnly(batch, allMatchCount, equalKeySeriesCount, spillCount, this.hashMultiSetResults, hashMultiSetResultCount);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

