/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.stats.annotation;

import com.facebook.presto.hive.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hive.$internal.com.google.common.collect.Maps;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.AnnotateStatsProcCtx;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public class StatsRulesProcFactory {
    private static final Log LOG = LogFactory.getLog(StatsRulesProcFactory.class.getName());
    private static final boolean isDebugEnabled = LOG.isDebugEnabled();

    public static NodeProcessor getTableScanRule() {
        return new TableScanStatsRule();
    }

    public static NodeProcessor getSelectRule() {
        return new SelectStatsRule();
    }

    public static NodeProcessor getFilterRule() {
        return new FilterStatsRule();
    }

    public static NodeProcessor getGroupByRule() {
        return new GroupByStatsRule();
    }

    public static NodeProcessor getJoinRule() {
        return new JoinStatsRule();
    }

    public static NodeProcessor getLimitRule() {
        return new LimitStatsRule();
    }

    public static NodeProcessor getReduceSinkRule() {
        return new ReduceSinkStatsRule();
    }

    public static NodeProcessor getDefaultRule() {
        return new DefaultStatsRule();
    }

    static void updateStats(Statistics stats, long newNumRows, boolean useColStats, Operator<? extends OperatorDesc> op) {
        StatsRulesProcFactory.updateStats(stats, newNumRows, useColStats, op, true);
    }

    static void updateStats(Statistics stats, long newNumRows, boolean useColStats, Operator<? extends OperatorDesc> op, boolean updateNDV) {
        if (newNumRows < 0L) {
            LOG.info("STATS-" + op.toString() + ": Overflow in number of rows." + newNumRows + " rows will be set to Long.MAX_VALUE");
            newNumRows = StatsUtils.getMaxIfOverflow(newNumRows);
        }
        if (newNumRows == 0L) {
            LOG.info("STATS-" + op.toString() + ": Equals 0 in number of rows." + newNumRows + " rows will be set to 1");
            newNumRows = 1L;
        }
        long oldRowCount = stats.getNumRows();
        double ratio = (double)newNumRows / (double)oldRowCount;
        stats.setNumRows(newNumRows);
        if (useColStats) {
            List<ColStatistics> colStats = stats.getColumnStats();
            for (ColStatistics cs : colStats) {
                long oldNumNulls = cs.getNumNulls();
                long oldDV = cs.getCountDistint();
                long newNumNulls = Math.round(ratio * (double)oldNumNulls);
                cs.setNumNulls(newNumNulls);
                if (!updateNDV) continue;
                long newDV = oldDV;
                if (ratio <= 1.0) {
                    newDV = (long)Math.ceil(ratio * (double)oldDV);
                }
                cs.setCountDistint(newDV);
            }
            stats.setColumnStats(colStats);
            long newDataSize = StatsUtils.getDataSizeFromColumnStats(newNumRows, colStats);
            stats.setDataSize(StatsUtils.getMaxIfOverflow(newDataSize));
        } else {
            long newDataSize = (long)(ratio * (double)stats.getDataSize());
            stats.setDataSize(StatsUtils.getMaxIfOverflow(newDataSize));
        }
    }

    static boolean satisfyPrecondition(Statistics stats) {
        return stats != null && stats.getBasicStatsState().equals((Object)Statistics.State.COMPLETE) && !stats.getColumnStatsState().equals((Object)Statistics.State.NONE);
    }

    public static class DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Statistics stats;
            Operator op = (Operator)nd;
            Object conf = op.getConf();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf hconf = aspCtx.getConf();
            if (conf != null && (stats = conf.getStatistics()) == null && op.getParentOperators() != null && this.isAllParentsContainStatistics(op)) {
                stats = new Statistics();
                for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                    if (parent.getStatistics() == null) continue;
                    Statistics parentStats = parent.getStatistics();
                    stats.addToNumRows(parentStats.getNumRows());
                    stats.addToDataSize(parentStats.getDataSize());
                    stats.updateColumnStatsState(parentStats.getColumnStatsState());
                    List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(hconf, parentStats, op.getColumnExprMap(), op.getSchema());
                    stats.addToColumnStats(colStats);
                    op.getConf().setStatistics(stats);
                    if (!isDebugEnabled) continue;
                    LOG.debug("[0] STATS-" + op.toString() + ": " + stats.extendedToString());
                }
            }
            return null;
        }

        private boolean isAllParentsContainStatistics(Operator<? extends OperatorDesc> op) {
            for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                if (parent.getStatistics() != null) continue;
                return false;
            }
            return true;
        }
    }

    public static class ReduceSinkStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator rop = (ReduceSinkOperator)nd;
            Operator<OperatorDesc> parent = rop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            if (parentStats != null) {
                AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
                HiveConf conf = aspCtx.getConf();
                ArrayList<String> outKeyColNames = ((ReduceSinkDesc)rop.getConf()).getOutputKeyColumnNames();
                ArrayList<String> outValueColNames = ((ReduceSinkDesc)rop.getConf()).getOutputValueColumnNames();
                Map<String, ExprNodeDesc> colExprMap = rop.getColumnExprMap();
                try {
                    Statistics outStats = parentStats.clone();
                    if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                        ColStatistics cs;
                        ExprNodeDesc end;
                        ArrayList<ColStatistics> colStats = Lists.newArrayList();
                        for (String key : outKeyColNames) {
                            String prefixedKey = Utilities.ReduceField.KEY.toString() + "." + key;
                            end = colExprMap.get(prefixedKey);
                            if (end == null || (cs = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end)) == null) continue;
                            cs.setColumnName(prefixedKey);
                            colStats.add(cs);
                        }
                        for (String val : outValueColNames) {
                            String prefixedVal = Utilities.ReduceField.VALUE.toString() + "." + val;
                            end = colExprMap.get(prefixedVal);
                            if (end == null || (cs = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end)) == null) continue;
                            cs.setColumnName(prefixedVal);
                            colStats.add(cs);
                        }
                        outStats.setColumnStats(colStats);
                    }
                    rop.setStatistics(outStats);
                    if (isDebugEnabled) {
                        LOG.debug("[0] STATS-" + rop.toString() + ": " + outStats.extendedToString());
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
                }
            }
            return null;
        }
    }

    public static class LimitStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LimitOperator lop = (LimitOperator)nd;
            Operator<OperatorDesc> parent = lop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            try {
                long limit = -1L;
                limit = ((LimitDesc)lop.getConf()).getLimit();
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    Statistics stats = parentStats.clone();
                    List<ColStatistics> colStats = StatsUtils.getColStatisticsUpdatingTableAlias(parentStats, lop.getSchema());
                    stats.setColumnStats(colStats);
                    if (limit <= parentStats.getNumRows()) {
                        StatsRulesProcFactory.updateStats(stats, limit, true, lop);
                    }
                    lop.setStatistics(stats);
                    if (isDebugEnabled) {
                        LOG.debug("[0] STATS-" + lop.toString() + ": " + stats.extendedToString());
                    }
                } else if (parentStats != null) {
                    Statistics wcStats = parentStats.clone();
                    if ((limit = StatsUtils.getMaxIfOverflow(limit)) <= parentStats.getNumRows()) {
                        long numRows = limit;
                        long avgRowSize = parentStats.getAvgRowSize();
                        long dataSize = StatsUtils.safeMult(avgRowSize, limit);
                        wcStats.setNumRows(numRows);
                        wcStats.setDataSize(dataSize);
                    }
                    lop.setStatistics(wcStats);
                    if (isDebugEnabled) {
                        LOG.debug("[1] STATS-" + lop.toString() + ": " + wcStats.extendedToString());
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            return null;
        }
    }

    public static class JoinStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            long newNumRows = 0L;
            CommonJoinOperator jop = (CommonJoinOperator)nd;
            List<Operator<? extends OperatorDesc>> parents = jop.getParentOperators();
            int numAttr = 1;
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            boolean allStatsAvail = true;
            boolean allSatisfyPreCondition = true;
            for (Operator<OperatorDesc> operator : parents) {
                if (operator.getStatistics() != null) continue;
                allStatsAvail = false;
            }
            if (allStatsAvail) {
                for (Operator<OperatorDesc> operator : parents) {
                    if (StatsRulesProcFactory.satisfyPrecondition(operator.getStatistics())) continue;
                    allSatisfyPreCondition = false;
                }
                if (allSatisfyPreCondition) {
                    Statistics stats = new Statistics();
                    ArrayList<Long> arrayList = Lists.newArrayList();
                    int numParent = parents.size();
                    HashMap<Integer, Long> rowCountParents = Maps.newHashMap();
                    HashMap<Integer, Statistics> joinStats = Maps.newHashMap();
                    HashMap<Integer, List<String>> joinKeys = Maps.newHashMap();
                    ArrayList<Long> rowCounts = Lists.newArrayList();
                    ReduceSinkOperator rsOp = (ReduceSinkOperator)jop.getParentOperators().get(0);
                    List<String> keyExprs = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames());
                    numAttr = keyExprs.size();
                    long inferredRowCount = this.inferPKFKRelationship(numAttr, parents, jop);
                    for (int pos = 0; pos < parents.size(); ++pos) {
                        ReduceSinkOperator parent = (ReduceSinkOperator)jop.getParentOperators().get(pos);
                        Statistics parentStats = parent.getStatistics();
                        keyExprs = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)parent.getConf()).getOutputKeyColumnNames());
                        rowCountParents.put(pos, parentStats.getNumRows());
                        rowCounts.add(parentStats.getNumRows());
                        joinKeys.put(pos, keyExprs);
                        joinStats.put(pos, parentStats);
                        stats.updateColumnStatsState(parentStats.getColumnStatsState());
                    }
                    long denom = 1L;
                    if (numAttr > 1) {
                        ArrayList perAttrDVs = Lists.newArrayList();
                        for (int idx = 0; idx < numAttr; ++idx) {
                            for (Integer i : joinKeys.keySet()) {
                                String col = (String)((List)joinKeys.get(i)).get(idx);
                                ColStatistics cs = ((Statistics)joinStats.get(i)).getColumnStatisticsFromColName(col);
                                if (cs == null) continue;
                                perAttrDVs.add(cs.getCountDistint());
                            }
                            arrayList.add(this.getDenominator(perAttrDVs));
                            perAttrDVs.clear();
                        }
                        if (numAttr > numParent) {
                            denom = this.getEasedOutDenominator(arrayList);
                        } else {
                            for (Long l : arrayList) {
                                denom = StatsUtils.safeMult(denom, l);
                            }
                        }
                    } else {
                        if (numAttr == 1) {
                            for (Integer i : joinKeys.keySet()) {
                                String col = (String)((List)joinKeys.get(i)).get(0);
                                ColStatistics cs = ((Statistics)joinStats.get(i)).getColumnStatisticsFromColName(col);
                                if (cs == null) continue;
                                arrayList.add(cs.getCountDistint());
                            }
                        }
                        denom = this.getDenominator(arrayList);
                    }
                    this.updateJoinColumnsNDV(joinKeys, joinStats, numAttr);
                    Map<String, ExprNodeDesc> colExprMap = jop.getColumnExprMap();
                    RowSchema rs = jop.getSchema();
                    ArrayList<ColStatistics> outColStats = Lists.newArrayList();
                    for (ColumnInfo ci : rs.getSignature()) {
                        String key = ci.getInternalName();
                        ExprNodeDesc end = colExprMap.get(key);
                        if (!(end instanceof ExprNodeColumnDesc)) continue;
                        String colName = ((ExprNodeColumnDesc)end).getColumn();
                        byte pos = ((JoinDesc)jop.getConf()).getReversedExprs().get(key);
                        ColStatistics cs = ((Statistics)joinStats.get(pos)).getColumnStatisticsFromColName(colName);
                        String outColName = key;
                        if (cs != null) {
                            cs.setColumnName(outColName);
                        }
                        outColStats.add(cs);
                    }
                    stats.setColumnStats(outColStats);
                    long newRowCount = inferredRowCount != -1L ? inferredRowCount : this.computeNewRowCount(rowCounts, denom);
                    this.updateStatsForJoinType(stats, newRowCount, jop, rowCountParents);
                    jop.setStatistics(stats);
                    if (isDebugEnabled) {
                        LOG.debug("[0] STATS-" + jop.toString() + ": " + stats.extendedToString());
                    }
                } else {
                    float joinFactor = HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_JOIN_FACTOR);
                    int n = parents.size();
                    ArrayList<Long> parentRows = Lists.newArrayList();
                    ArrayList<Long> parentSizes = Lists.newArrayList();
                    int maxRowIdx = 0;
                    long maxRowCount = 0L;
                    int idx = 0;
                    for (Operator<OperatorDesc> operator : parents) {
                        Statistics ps = operator.getStatistics();
                        long rowCount = ps.getNumRows();
                        if (rowCount > maxRowCount) {
                            maxRowCount = rowCount;
                            maxRowIdx = idx;
                        }
                        parentRows.add(rowCount);
                        parentSizes.add(ps.getDataSize());
                        ++idx;
                    }
                    long maxDataSize = (Long)parentSizes.get(maxRowIdx);
                    newNumRows = StatsUtils.safeMult(StatsUtils.safeMult(maxRowCount, n - 1), joinFactor);
                    long newDataSize = StatsUtils.safeMult(StatsUtils.safeMult(maxDataSize, n - 1), joinFactor);
                    Statistics wcStats = new Statistics();
                    wcStats.setNumRows(newNumRows);
                    wcStats.setDataSize(newDataSize);
                    jop.setStatistics(wcStats);
                    if (isDebugEnabled) {
                        LOG.debug("[1] STATS-" + jop.toString() + ": " + wcStats.extendedToString());
                    }
                }
            }
            return null;
        }

        private long inferPKFKRelationship(int numAttr, List<Operator<? extends OperatorDesc>> parents, CommonJoinOperator<? extends JoinDesc> jop) {
            long newNumRows = -1L;
            if (numAttr == 1) {
                Map<Integer, ColStatistics> parentsWithPK = this.getPrimaryKeyCandidates(parents);
                if (parentsWithPK.size() != 1) {
                    LOG.debug("STATS-" + jop.toString() + ": detects none/multiple PK parents.");
                    return newNumRows;
                }
                Integer pkPos = parentsWithPK.keySet().iterator().next();
                ColStatistics csPK = parentsWithPK.values().iterator().next();
                Map<Integer, ColStatistics> csFKs = this.getForeignKeyCandidates(parents, csPK);
                if (csFKs.size() + 1 == parents.size()) {
                    newNumRows = this.getCardinality(parents, pkPos, csPK, csFKs, jop);
                    if (isDebugEnabled) {
                        ArrayList<String> parentIds = Lists.newArrayList();
                        for (Integer i : parentsWithPK.keySet()) {
                            parentIds.add(parents.get(i).toString());
                        }
                        LOG.debug("STATS-" + jop.toString() + ": PK parent id(s) - " + parentIds);
                        parentIds.clear();
                        for (Integer i : csFKs.keySet()) {
                            parentIds.add(parents.get(i).toString());
                        }
                        LOG.debug("STATS-" + jop.toString() + ": FK parent id(s) - " + parentIds);
                    }
                }
            }
            return newNumRows;
        }

        private long getCardinality(List<Operator<? extends OperatorDesc>> ops, Integer pkPos, ColStatistics csPK, Map<Integer, ColStatistics> csFKs, CommonJoinOperator<? extends JoinDesc> jop) {
            double pkfkSelectivity = Double.MAX_VALUE;
            int fkInd = -1;
            for (Map.Entry<Integer, ColStatistics> entry : csFKs.entrySet()) {
                int pos = entry.getKey();
                Operator<? extends OperatorDesc> opWithPK = ops.get(pkPos);
                double selectivity = this.getSelectivitySimpleTree(opWithPK);
                double selectivityAdjustment = StatsUtils.getScaledSelectivity(csPK, entry.getValue());
                double d = selectivityAdjustment * selectivity > 1.0 ? selectivity : selectivityAdjustment * selectivity;
                selectivity = d;
                if (!(selectivity < pkfkSelectivity)) continue;
                pkfkSelectivity = selectivity;
                fkInd = pos;
            }
            long newrows = 1L;
            ArrayList<Long> rowCounts = Lists.newArrayList();
            ArrayList<Long> distinctVals = Lists.newArrayList();
            for (Map.Entry<Integer, ColStatistics> entry : csFKs.entrySet()) {
                int pos = entry.getKey();
                ColStatistics csFK = entry.getValue();
                ReduceSinkOperator parent = (ReduceSinkOperator)jop.getParentOperators().get(pos);
                Statistics parentStats = parent.getStatistics();
                if (fkInd == pos) {
                    newrows = (long)Math.ceil((double)parentStats.getNumRows() * pkfkSelectivity);
                    rowCounts.add(newrows);
                    distinctVals.add(Math.min(csFK.getCountDistint(), csPK.getCountDistint()));
                    continue;
                }
                rowCounts.add(parentStats.getNumRows());
                distinctVals.add(csFK.getCountDistint());
            }
            long newNumRows = csFKs.size() == 1 ? newrows : this.computeNewRowCount(rowCounts, this.getDenominator(distinctVals));
            return newNumRows;
        }

        private float getSelectivitySimpleTree(Operator<? extends OperatorDesc> op) {
            TableScanOperator tsOp = OperatorUtils.findSingleOperatorUpstream(op, TableScanOperator.class);
            if (tsOp == null) {
                return this.getSelectivityComplexTree(op);
            }
            long inputRow = tsOp.getStatistics().getNumRows();
            long outputRow = op.getStatistics().getNumRows();
            return (float)outputRow / (float)inputRow;
        }

        private float getSelectivityComplexTree(Operator<? extends OperatorDesc> op) {
            Operator<? extends OperatorDesc> multiParentOp = null;
            Operator<? extends OperatorDesc> currentOp = op;
            while (multiParentOp == null) {
                if (op.getParentOperators().size() > 1) {
                    multiParentOp = op;
                    continue;
                }
                op = op.getParentOperators().get(0);
            }
            float selMultiParent = 1.0f;
            for (Operator<OperatorDesc> parent : multiParentOp.getParentOperators()) {
                selMultiParent *= this.getSelectivitySimpleTree(parent);
            }
            float selCurrOp = (float)currentOp.getStatistics().getNumRows() / (float)multiParentOp.getStatistics().getNumRows() * selMultiParent;
            return selCurrOp;
        }

        private Map<Integer, ColStatistics> getForeignKeyCandidates(List<Operator<? extends OperatorDesc>> ops, ColStatistics csPK) {
            HashMap<Integer, ColStatistics> result = new HashMap<Integer, ColStatistics>();
            if (csPK == null || ops == null) {
                return result;
            }
            for (int i = 0; i < ops.size(); ++i) {
                ColStatistics cs;
                ReduceSinkOperator rsOp;
                List<String> keys;
                Operator<? extends OperatorDesc> op = ops.get(i);
                if (op == null || !(op instanceof ReduceSinkOperator) || (keys = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)(rsOp = (ReduceSinkOperator)op).getConf()).getOutputKeyColumnNames())).size() != 1) continue;
                String joinCol = keys.get(0);
                if (rsOp.getStatistics() == null || (cs = rsOp.getStatistics().getColumnStatisticsFromColName(joinCol)) == null || cs.isPrimaryKey() || !StatsUtils.inferForeignKey(csPK, cs)) continue;
                result.put(i, cs);
            }
            return result;
        }

        private Map<Integer, ColStatistics> getPrimaryKeyCandidates(List<Operator<? extends OperatorDesc>> ops) {
            HashMap<Integer, ColStatistics> result = new HashMap<Integer, ColStatistics>();
            if (ops != null && !ops.isEmpty()) {
                for (int i = 0; i < ops.size(); ++i) {
                    ColStatistics cs;
                    ReduceSinkOperator rsOp;
                    List<String> keys;
                    Operator<? extends OperatorDesc> op = ops.get(i);
                    if (!(op instanceof ReduceSinkOperator) || (keys = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)(rsOp = (ReduceSinkOperator)op).getConf()).getOutputKeyColumnNames())).size() != 1) continue;
                    String joinCol = keys.get(0);
                    if (rsOp.getStatistics() == null || (cs = rsOp.getStatistics().getColumnStatisticsFromColName(joinCol)) == null || !cs.isPrimaryKey()) continue;
                    result.put(i, cs);
                }
            }
            return result;
        }

        private Long getEasedOutDenominator(List<Long> distinctVals) {
            Collections.sort(distinctVals, Collections.reverseOrder());
            long denom = distinctVals.get(0);
            for (int i = 1; i < distinctVals.size(); ++i) {
                denom = (long)((double)denom * Math.pow(distinctVals.get(i).longValue(), 1.0 / (double)(1 << i)));
            }
            return denom;
        }

        private void updateStatsForJoinType(Statistics stats, long newNumRows, CommonJoinOperator<? extends JoinDesc> jop, Map<Integer, Long> rowCountParents) {
            if (newNumRows < 0L) {
                LOG.info("STATS-" + jop.toString() + ": Overflow in number of rows." + newNumRows + " rows will be set to Long.MAX_VALUE");
            }
            if (newNumRows == 0L) {
                LOG.info("STATS-" + jop.toString() + ": Equals 0 in number of rows." + newNumRows + " rows will be set to 1");
                newNumRows = 1L;
            }
            newNumRows = StatsUtils.getMaxIfOverflow(newNumRows);
            stats.setNumRows(newNumRows);
            List<ColStatistics> colStats = stats.getColumnStats();
            for (ColStatistics cs : colStats) {
                long oldDV;
                byte pos = ((JoinDesc)jop.getConf()).getReversedExprs().get(cs.getColumnName());
                long oldRowCount = rowCountParents.get(pos);
                double ratio = (double)newNumRows / (double)oldRowCount;
                long newDV = oldDV = cs.getCountDistint();
                if (ratio <= 1.0) {
                    newDV = (long)Math.ceil(ratio * (double)oldDV);
                }
                cs.setNumNulls(0L);
                cs.setCountDistint(newDV);
            }
            stats.setColumnStats(colStats);
            long newDataSize = StatsUtils.getDataSizeFromColumnStats(newNumRows, colStats);
            stats.setDataSize(StatsUtils.getMaxIfOverflow(newDataSize));
        }

        private long computeNewRowCount(List<Long> rowCountParents, long denom) {
            int i;
            double factor = 0.0;
            long result = 1L;
            long max = rowCountParents.get(0);
            long maxIdx = 0L;
            for (i = 1; i < rowCountParents.size(); ++i) {
                if (rowCountParents.get(i) <= max) continue;
                max = rowCountParents.get(i);
                maxIdx = i;
            }
            factor = (double)max / (double)denom;
            for (i = 0; i < rowCountParents.size(); ++i) {
                if ((long)i == maxIdx) continue;
                result = StatsUtils.safeMult(result, rowCountParents.get(i));
            }
            result = (long)((double)result * factor);
            return result;
        }

        private void updateJoinColumnsNDV(Map<Integer, List<String>> joinKeys, Map<Integer, Statistics> joinStats, int numAttr) {
            int joinColIdx = 0;
            while (numAttr > 0) {
                ColStatistics cs;
                String key;
                int pos;
                long minNDV = Long.MAX_VALUE;
                for (Map.Entry<Integer, List<String>> entry : joinKeys.entrySet()) {
                    pos = entry.getKey();
                    key = entry.getValue().get(joinColIdx);
                    cs = joinStats.get(pos).getColumnStatisticsFromColName(key);
                    if (cs == null || cs.getCountDistint() >= minNDV) continue;
                    minNDV = cs.getCountDistint();
                }
                if (minNDV != Long.MAX_VALUE) {
                    for (Map.Entry<Integer, List<String>> entry : joinKeys.entrySet()) {
                        pos = entry.getKey();
                        key = entry.getValue().get(joinColIdx);
                        cs = joinStats.get(pos).getColumnStatisticsFromColName(key);
                        if (cs == null) continue;
                        cs.setCountDistint(minNDV);
                    }
                }
                ++joinColIdx;
                --numAttr;
            }
        }

        private long getDenominator(List<Long> distinctVals) {
            if (distinctVals.isEmpty()) {
                return 2L;
            }
            if (distinctVals.size() <= 2) {
                return Collections.max(distinctVals);
            }
            long minNDV = distinctVals.get(0);
            int minIdx = 0;
            for (int i = 1; i < distinctVals.size(); ++i) {
                if (distinctVals.get(i) >= minNDV) continue;
                minNDV = distinctVals.get(i);
                minIdx = i;
            }
            long denom = 1L;
            for (int i = 0; i < distinctVals.size(); ++i) {
                if (i == minIdx) continue;
                denom = StatsUtils.safeMult(denom, distinctVals.get(i));
            }
            return denom;
        }
    }

    public static class GroupByStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            long sizeOfGroupingSet;
            GroupByOperator gop = (GroupByOperator)nd;
            Operator<OperatorDesc> parent = gop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            if (parentStats == null) {
                return null;
            }
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            long maxSplitSize = HiveConf.getLongVar(conf, HiveConf.ConfVars.MAPREDMAXSPLITSIZE);
            ArrayList<AggregationDesc> aggDesc = ((GroupByDesc)gop.getConf()).getAggregators();
            Map<String, ExprNodeDesc> colExprMap = gop.getColumnExprMap();
            RowSchema rs = gop.getSchema();
            Statistics stats = null;
            List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(conf, parentStats, colExprMap, rs);
            long parallelism = 1L;
            boolean interReduction = false;
            boolean hashAgg = false;
            long inputSize = 1L;
            boolean containsGroupingSet = ((GroupByDesc)gop.getConf()).isGroupingSetsPresent();
            long l = sizeOfGroupingSet = containsGroupingSet ? (long)((GroupByDesc)gop.getConf()).getListGroupingSets().size() : 1L;
            if (!(((GroupByDesc)gop.getConf()).getMode().equals((Object)GroupByDesc.Mode.MERGEPARTIAL) || ((GroupByDesc)gop.getConf()).getMode().equals((Object)GroupByDesc.Mode.COMPLETE) || ((GroupByDesc)gop.getConf()).getMode().equals((Object)GroupByDesc.Mode.FINAL))) {
                interReduction = true;
                TableScanOperator top = OperatorUtils.findSingleOperatorUpstream(gop, TableScanOperator.class);
                if (top == null) {
                    inputSize = parentStats.getDataSize();
                    maxSplitSize = HiveConf.getLongVar(conf, HiveConf.ConfVars.BYTESPERREDUCER);
                } else {
                    inputSize = ((TableScanDesc)top.getConf()).getStatistics().getDataSize();
                }
                parallelism = (int)Math.ceil((double)inputSize / (double)maxSplitSize);
            }
            if (isDebugEnabled) {
                LOG.debug("STATS-" + gop.toString() + ": inputSize: " + inputSize + " maxSplitSize: " + maxSplitSize + " parallelism: " + parallelism + " containsGroupingSet: " + containsGroupingSet + " sizeOfGroupingSet: " + sizeOfGroupingSet);
            }
            try {
                long cardinality;
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    hashAgg = this.checkMapSideAggregation(gop, colStats, conf);
                    if (isDebugEnabled) {
                        LOG.debug("STATS-" + gop.toString() + " hashAgg: " + hashAgg);
                    }
                    stats = parentStats.clone();
                    stats.setColumnStats(colStats);
                    long ndvProduct = 1L;
                    long parentNumRows = stats.getNumRows();
                    for (ColStatistics cs : colStats) {
                        if (cs != null) {
                            long ndv = cs.getCountDistint();
                            if (cs.getNumNulls() > 0L) {
                                ndv = StatsUtils.safeAdd(ndv, 1L);
                            }
                            ndvProduct = StatsUtils.safeMult(ndvProduct, ndv);
                            continue;
                        }
                        if (parentStats.getColumnStatsState().equals((Object)Statistics.State.COMPLETE)) continue;
                        ndvProduct = 0L;
                        break;
                    }
                    if (ndvProduct == 0L) {
                        ndvProduct = parentNumRows / 2L;
                        if (isDebugEnabled) {
                            LOG.debug("STATS-" + gop.toString() + ": ndvProduct became 0 as some column does not" + " have stats. ndvProduct changed to: " + ndvProduct);
                        }
                    }
                    if (interReduction) {
                        if (hashAgg) {
                            if (containsGroupingSet) {
                                cardinality = Math.min(StatsUtils.safeMult(parentNumRows, sizeOfGroupingSet) / 2L, StatsUtils.safeMult(StatsUtils.safeMult(ndvProduct, parallelism), sizeOfGroupingSet));
                                if (isDebugEnabled) {
                                    LOG.debug("[Case 4] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                                }
                            } else {
                                cardinality = Math.min(parentNumRows / 2L, StatsUtils.safeMult(ndvProduct, parallelism));
                                if (isDebugEnabled) {
                                    LOG.debug("[Case 3] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                                }
                            }
                        } else if (containsGroupingSet) {
                            cardinality = StatsUtils.safeMult(parentNumRows, sizeOfGroupingSet);
                            if (isDebugEnabled) {
                                LOG.debug("[Case 6] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        } else {
                            cardinality = parentNumRows;
                            if (isDebugEnabled) {
                                LOG.debug("[Case 5] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        }
                    } else {
                        GroupByOperator mGop = OperatorUtils.findSingleOperatorUpstream(parent, GroupByOperator.class);
                        if (mGop != null) {
                            containsGroupingSet = ((GroupByDesc)mGop.getConf()).isGroupingSetsPresent();
                        }
                        if (containsGroupingSet) {
                            sizeOfGroupingSet = ((GroupByDesc)mGop.getConf()).getListGroupingSets().size();
                            cardinality = Math.min(parentNumRows, StatsUtils.safeMult(ndvProduct, sizeOfGroupingSet));
                            if (isDebugEnabled) {
                                LOG.debug("[Case 8] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        } else {
                            cardinality = Math.min(parentNumRows, ndvProduct);
                            if (isDebugEnabled) {
                                LOG.debug("[Case 9] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        }
                    }
                    StatsRulesProcFactory.updateStats(stats, cardinality, true, gop, false);
                } else if (parentStats != null) {
                    stats = parentStats.clone();
                    long parentNumRows = stats.getNumRows();
                    if (interReduction) {
                        if (containsGroupingSet) {
                            cardinality = StatsUtils.safeMult(parentNumRows, sizeOfGroupingSet);
                            if (isDebugEnabled) {
                                LOG.debug("[Case 2] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        } else {
                            cardinality = parentNumRows;
                            if (isDebugEnabled) {
                                LOG.debug("[Case 1] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        }
                    } else {
                        cardinality = parentNumRows / 2L;
                        if (isDebugEnabled) {
                            LOG.debug("[Case 7] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    }
                    StatsRulesProcFactory.updateStats(stats, cardinality, false, gop);
                }
                if (!aggDesc.isEmpty() && stats != null) {
                    ArrayList<ColStatistics> aggColStats = Lists.newArrayList();
                    for (ColumnInfo ci : rs.getSignature()) {
                        ColStatistics cs;
                        if (colExprMap.containsKey(ci.getInternalName())) continue;
                        String colName = ci.getInternalName();
                        String colType = ci.getTypeName();
                        cs = new ColStatistics(colName, colType);
                        cs.setCountDistint(stats.getNumRows());
                        cs.setNumNulls(0L);
                        cs.setAvgColLen(StatsUtils.getAvgColLenOfFixedLengthTypes(colType));
                        aggColStats.add(cs);
                    }
                    if (aggColStats.size() > 0) {
                        stats.addToColumnStats(aggColStats);
                        if (!stats.getColumnStatsState().equals((Object)Statistics.State.NONE)) {
                            StatsRulesProcFactory.updateStats(stats, stats.getNumRows(), true, gop);
                        }
                    }
                    if (colExprMap.isEmpty()) {
                        stats.setNumRows(1L);
                        StatsRulesProcFactory.updateStats(stats, 1L, true, gop);
                    }
                }
                gop.setStatistics(stats);
                if (isDebugEnabled && stats != null) {
                    LOG.debug("[0] STATS-" + gop.toString() + ": " + stats.extendedToString());
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            return null;
        }

        private boolean checkMapSideAggregation(GroupByOperator gop, List<ColStatistics> colStats, HiveConf conf) {
            ArrayList<AggregationDesc> aggDesc = ((GroupByDesc)gop.getConf()).getAggregators();
            GroupByDesc desc = (GroupByDesc)gop.getConf();
            GroupByDesc.Mode mode = desc.getMode();
            if (mode.equals((Object)GroupByDesc.Mode.HASH)) {
                Object agg;
                int i;
                float hashAggMem = conf.getFloatVar(HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
                float hashAggMaxThreshold = conf.getFloatVar(HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
                long totalMemory = StatsUtils.getAvailableMemory(conf) * 1000L * 1000L;
                long maxMemHashAgg = Math.round((float)totalMemory * hashAggMem * hashAggMaxThreshold);
                long numEstimatedRows = 1L;
                long avgKeySize = 0L;
                for (ColStatistics cs : colStats) {
                    if (cs == null) continue;
                    numEstimatedRows = StatsUtils.safeMult(numEstimatedRows, cs.getCountDistint());
                    avgKeySize = (long)((double)avgKeySize + Math.ceil(cs.getAvgColLen()));
                }
                long avgValSize = 0L;
                GenericUDAFEvaluator[] aggregationEvaluators = new GenericUDAFEvaluator[aggDesc.size()];
                for (i = 0; i < aggregationEvaluators.length; ++i) {
                    agg = (AggregationDesc)aggDesc.get(i);
                    aggregationEvaluators[i] = ((AggregationDesc)agg).getGenericUDAFEvaluator();
                }
                for (i = 0; i < aggregationEvaluators.length; ++i) {
                    Field[] fArr;
                    avgValSize += 64L;
                    agg = null;
                    try {
                        agg = aggregationEvaluators[i].getNewAggregationBuffer();
                    }
                    catch (HiveException e) {
                        avgValSize += 256L;
                    }
                    if (agg == null) continue;
                    if (GenericUDAFEvaluator.isEstimable((GenericUDAFEvaluator.AggregationBuffer)agg)) {
                        avgValSize += (long)((GenericUDAFEvaluator.AbstractAggregationBuffer)agg).estimate();
                        continue;
                    }
                    for (Field f : fArr = ObjectInspectorUtils.getDeclaredNonStaticFields(agg.getClass())) {
                        long avgSize = StatsUtils.getAvgColLenOfFixedLengthTypes(f.getType().getName());
                        avgValSize += avgSize == 0L ? 256L : avgSize;
                    }
                }
                long hashEntrySize = 64L + avgKeySize + avgValSize;
                long estHashTableSize = StatsUtils.safeMult(numEstimatedRows, hashEntrySize);
                if (estHashTableSize < maxMemHashAgg) {
                    return true;
                }
            }
            return false;
        }

        private long applyGBYRule(long numRows, long dvProd) {
            long newNumRows = numRows;
            if (numRows > 1L) {
                newNumRows = dvProd != 0L ? Math.min(numRows / 2L, dvProd) : numRows / 2L;
            }
            return newNumRows;
        }
    }

    public static class FilterStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            FilterOperator fop = (FilterOperator)nd;
            Operator<OperatorDesc> parent = fop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            List<String> neededCols = null;
            if (parent instanceof TableScanOperator) {
                TableScanOperator tsop = (TableScanOperator)parent;
                neededCols = tsop.getNeededColumns();
            }
            try {
                if (parentStats != null) {
                    ExprNodeDesc pred = ((FilterDesc)fop.getConf()).getPredicate();
                    long newNumRows = this.evaluateExpression(parentStats, pred, aspCtx, neededCols, fop);
                    Statistics st = parentStats.clone();
                    if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                        if (newNumRows <= parentStats.getNumRows()) {
                            StatsRulesProcFactory.updateStats(st, newNumRows, true, fop);
                        }
                        if (isDebugEnabled) {
                            LOG.debug("[0] STATS-" + fop.toString() + ": " + st.extendedToString());
                        }
                    } else {
                        if (newNumRows <= parentStats.getNumRows()) {
                            StatsRulesProcFactory.updateStats(st, newNumRows, false, fop);
                        }
                        if (isDebugEnabled) {
                            LOG.debug("[1] STATS-" + fop.toString() + ": " + st.extendedToString());
                        }
                    }
                    fop.setStatistics(st);
                    aspCtx.setAndExprStats(null);
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            return null;
        }

        private long evaluateExpression(Statistics stats, ExprNodeDesc pred, AnnotateStatsProcCtx aspCtx, List<String> neededCols, FilterOperator fop) throws CloneNotSupportedException {
            long newNumRows = 0L;
            Statistics andStats = null;
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                GenericUDF udf = genFunc.getGenericUDF();
                if (udf instanceof GenericUDFOPAnd) {
                    andStats = stats.clone();
                    aspCtx.setAndExprStats(andStats);
                    for (ExprNodeDesc child : genFunc.getChildren()) {
                        newNumRows = this.evaluateChildExpr(aspCtx.getAndExprStats(), child, aspCtx, neededCols, fop);
                        if (StatsRulesProcFactory.satisfyPrecondition(aspCtx.getAndExprStats())) {
                            StatsRulesProcFactory.updateStats(aspCtx.getAndExprStats(), newNumRows, true, fop);
                            continue;
                        }
                        StatsRulesProcFactory.updateStats(aspCtx.getAndExprStats(), newNumRows, false, fop);
                    }
                } else if (udf instanceof GenericUDFOPOr) {
                    for (ExprNodeDesc child : genFunc.getChildren()) {
                        newNumRows = StatsUtils.safeAdd(this.evaluateChildExpr(stats, child, aspCtx, neededCols, fop), newNumRows);
                    }
                } else {
                    newNumRows = udf instanceof GenericUDFOPNot ? this.evaluateNotExpr(stats, pred, aspCtx, neededCols, fop) : this.evaluateChildExpr(stats, pred, aspCtx, neededCols, fop);
                }
            } else {
                if (pred instanceof ExprNodeColumnDesc) {
                    ColStatistics cs;
                    ExprNodeColumnDesc encd = (ExprNodeColumnDesc)pred;
                    String colName = encd.getColumn();
                    String colType = encd.getTypeString();
                    if (colType.equalsIgnoreCase("boolean") && (cs = stats.getColumnStatisticsFromColName(colName)) != null) {
                        return cs.getNumTrues();
                    }
                    return stats.getNumRows() / 2L;
                }
                if (pred instanceof ExprNodeConstantDesc) {
                    ExprNodeConstantDesc encd = (ExprNodeConstantDesc)pred;
                    if (Boolean.FALSE.equals(encd.getValue())) {
                        return 0L;
                    }
                    return stats.getNumRows();
                }
            }
            return newNumRows;
        }

        private long evaluateNotExpr(Statistics stats, ExprNodeDesc pred, AnnotateStatsProcCtx aspCtx, List<String> neededCols, FilterOperator fop) throws CloneNotSupportedException {
            long numRows = stats.getNumRows();
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                for (ExprNodeDesc leaf : genFunc.getChildren()) {
                    ColStatistics cs;
                    if (leaf instanceof ExprNodeGenericFuncDesc) {
                        long newNumRows = 0L;
                        for (ExprNodeDesc child : genFunc.getChildren()) {
                            newNumRows = this.evaluateChildExpr(stats, child, aspCtx, neededCols, fop);
                        }
                        return numRows - newNumRows;
                    }
                    if (leaf instanceof ExprNodeConstantDesc) {
                        ExprNodeConstantDesc encd = (ExprNodeConstantDesc)leaf;
                        if (Boolean.TRUE.equals(encd.getValue())) {
                            return 0L;
                        }
                        return numRows;
                    }
                    if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                    ExprNodeColumnDesc encd = (ExprNodeColumnDesc)leaf;
                    String colName = encd.getColumn();
                    String colType = encd.getTypeString();
                    if (colType.equalsIgnoreCase("boolean") && (cs = stats.getColumnStatisticsFromColName(colName)) != null) {
                        return cs.getNumFalses();
                    }
                    return numRows / 2L;
                }
            }
            return numRows / 2L;
        }

        private long evaluateColEqualsNullExpr(Statistics stats, ExprNodeDesc pred) {
            long numRows = stats.getNumRows();
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                for (ExprNodeDesc leaf : genFunc.getChildren()) {
                    ExprNodeColumnDesc colDesc;
                    String colName;
                    ColStatistics cs;
                    if (!(leaf instanceof ExprNodeColumnDesc) || (cs = stats.getColumnStatisticsFromColName(colName = (colDesc = (ExprNodeColumnDesc)leaf).getColumn())) == null) continue;
                    return cs.getNumNulls();
                }
            }
            return numRows / 2L;
        }

        private long evaluateChildExpr(Statistics stats, ExprNodeDesc child, AnnotateStatsProcCtx aspCtx, List<String> neededCols, FilterOperator fop) throws CloneNotSupportedException {
            long numRows = stats.getNumRows();
            if (child instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)child;
                GenericUDF udf = genFunc.getGenericUDF();
                if (udf instanceof GenericUDFOPEqual || udf instanceof GenericUDFOPEqualNS) {
                    String colName = null;
                    boolean isConst = false;
                    Object prevConst = null;
                    for (ExprNodeDesc leaf : genFunc.getChildren()) {
                        if (leaf instanceof ExprNodeConstantDesc) {
                            if (isConst) {
                                if (prevConst != null && !prevConst.equals(((ExprNodeConstantDesc)leaf).getValue())) {
                                    return 0L;
                                }
                                return numRows;
                            }
                            if (colName == null) {
                                isConst = true;
                                prevConst = ((ExprNodeConstantDesc)leaf).getValue();
                                continue;
                            }
                            if (neededCols != null && !neededCols.contains(colName)) {
                                return numRows;
                            }
                            ColStatistics cs = stats.getColumnStatisticsFromColName(colName);
                            if (cs == null) continue;
                            long dvs = cs.getCountDistint();
                            numRows = dvs == 0L ? numRows / 2L : numRows / dvs;
                            return numRows;
                        }
                        if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                        ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)leaf;
                        colName = colDesc.getColumn();
                        if (!isConst) continue;
                        if (neededCols != null && neededCols.indexOf(colName) == -1) {
                            return numRows;
                        }
                        ColStatistics cs = stats.getColumnStatisticsFromColName(colName);
                        if (cs == null) continue;
                        long dvs = cs.getCountDistint();
                        numRows = dvs == 0L ? numRows / 2L : numRows / dvs;
                        return numRows;
                    }
                } else {
                    if (udf instanceof GenericUDFOPNotEqual) {
                        return numRows;
                    }
                    if (udf instanceof GenericUDFOPEqualOrGreaterThan || udf instanceof GenericUDFOPEqualOrLessThan || udf instanceof GenericUDFOPGreaterThan || udf instanceof GenericUDFOPLessThan) {
                        return numRows / 3L;
                    }
                    if (udf instanceof GenericUDFOPNotNull) {
                        long newNumRows = this.evaluateColEqualsNullExpr(stats, genFunc);
                        return stats.getNumRows() - newNumRows;
                    }
                    if (udf instanceof GenericUDFOPNull) {
                        return this.evaluateColEqualsNullExpr(stats, genFunc);
                    }
                    if (udf instanceof GenericUDFOPAnd || udf instanceof GenericUDFOPOr || udf instanceof GenericUDFOPNot) {
                        return this.evaluateExpression(stats, genFunc, aspCtx, neededCols, fop);
                    }
                }
            }
            return numRows / 2L;
        }
    }

    public static class SelectStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator sop = (SelectOperator)nd;
            Operator<OperatorDesc> parent = sop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            Statistics stats = null;
            if (parentStats != null) {
                try {
                    stats = parentStats.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
                }
            }
            try {
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(conf, parentStats, sop.getColumnExprMap(), sop.getSchema());
                    stats.setColumnStats(colStats);
                    if (!((SelectDesc)sop.getConf()).isSelectStar() && !((SelectDesc)sop.getConf()).isSelStarNoCompute()) {
                        long dataSize = StatsUtils.getDataSizeFromColumnStats(stats.getNumRows(), colStats);
                        stats.setDataSize(dataSize);
                    }
                    sop.setStatistics(stats);
                    if (isDebugEnabled) {
                        LOG.debug("[0] STATS-" + sop.toString() + ": " + stats.extendedToString());
                    }
                } else if (parentStats != null) {
                    sop.setStatistics(parentStats.clone());
                    if (isDebugEnabled) {
                        LOG.debug("[1] STATS-" + sop.toString() + ": " + parentStats.extendedToString());
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            return null;
        }
    }

    public static class TableScanStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator tsop = (TableScanOperator)nd;
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            PrunedPartitionList partList = aspCtx.getParseContext().getPrunedPartitions(tsop.getName(), tsop);
            Table table = ((TableScanDesc)tsop.getConf()).getTableMetadata();
            try {
                Statistics stats = StatsUtils.collectStatistics(aspCtx.getConf(), partList, table, tsop);
                tsop.setStatistics(stats.clone());
                if (isDebugEnabled) {
                    LOG.debug("[0] STATS-" + tsop.toString() + " (" + table.getTableName() + "): " + stats.extendedToString());
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            catch (HiveException e) {
                LOG.debug(e);
                throw new SemanticException(e);
            }
            return null;
        }
    }
}

