/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TableAccessCtx;
import org.apache.hadoop.hive.ql.parse.TableAccessInfo;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class TableAccessAnalyzer {
    private static final Log LOG = LogFactory.getLog(TableAccessAnalyzer.class.getName());
    private final ParseContext pGraphContext;

    public TableAccessAnalyzer() {
        this.pGraphContext = null;
    }

    public TableAccessAnalyzer(ParseContext pactx) {
        this.pGraphContext = pactx;
    }

    public TableAccessInfo analyzeTableAccess() throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", GroupByOperator.getOperatorName() + "%"), new GroupByProcessor(this.pGraphContext));
        opRules.put(new RuleRegExp("R2", JoinOperator.getOperatorName() + "%"), new JoinProcessor(this.pGraphContext));
        opRules.put(new RuleRegExp("R3", MapJoinOperator.getOperatorName() + "%"), new JoinProcessor(this.pGraphContext));
        TableAccessCtx tableAccessCtx = new TableAccessCtx();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, tableAccessCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pGraphContext.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return tableAccessCtx.getTableAccessInfo();
    }

    private NodeProcessor getDefaultProc() {
        return new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }

    public static TableScanOperator genRootTableScan(Operator<? extends OperatorDesc> op, List<String> keyNames) {
        Operator<? extends OperatorDesc> currOp = op;
        List<String> currColNames = keyNames;
        List<Operator<OperatorDesc>> parentOps = null;
        while ((parentOps = currOp.getParentOperators()) != null && !parentOps.isEmpty()) {
            if (parentOps.size() > 1 || !currOp.columnNamesRowResolvedCanBeObtained()) {
                return null;
            }
            if (!TableAccessAnalyzer.genColNameMap(currOp, currColNames)) {
                return null;
            }
            currOp = parentOps.get(0);
        }
        return (TableScanOperator)currOp;
    }

    private static boolean genColNameMap(Operator<? extends OperatorDesc> op, List<String> currColNames) {
        SelectDesc selectDesc;
        List<ExprNodeDesc> colList = null;
        List<String> outputColNames = null;
        assert (op.columnNamesRowResolvedCanBeObtained());
        if (op instanceof SelectOperator && !(selectDesc = (SelectDesc)((SelectOperator)op).getConf()).isSelStarNoCompute()) {
            colList = selectDesc.getColList();
            outputColNames = selectDesc.getOutputColumnNames();
            for (int pos = 0; pos < colList.size(); ++pos) {
                ExprNodeDesc colExpr = colList.get(pos);
                String outputColName = outputColNames.get(pos);
                if (!currColNames.contains(outputColName)) continue;
                if (colExpr instanceof ExprNodeConstantDesc) {
                    currColNames.remove(outputColName);
                    continue;
                }
                if (colExpr instanceof ExprNodeColumnDesc) {
                    String inputColName = ((ExprNodeColumnDesc)colExpr).getColumn();
                    if (outputColName.equals(inputColName)) continue;
                    currColNames.set(currColNames.indexOf(outputColName), inputColName);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private static List<String> getKeyColNames(List<ExprNodeDesc> keys) {
        ArrayList<String> colList = new ArrayList<String>();
        for (ExprNodeDesc expr : keys) {
            if (expr instanceof ExprNodeColumnDesc) {
                ExprNodeColumnDesc colExpr = (ExprNodeColumnDesc)expr;
                colList.add(colExpr.getColumn());
                continue;
            }
            if (expr instanceof ExprNodeConstantDesc) continue;
            return null;
        }
        return colList;
    }

    public class JoinProcessor
    implements NodeProcessor {
        protected ParseContext pGraphContext;

        public JoinProcessor(ParseContext pGraphContext) {
            this.pGraphContext = pGraphContext;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) {
            JoinOperator op = (JoinOperator)nd;
            TableAccessCtx tableAccessCtx = (TableAccessCtx)procCtx;
            LinkedHashMap<String, List<String>> tableToKeysMap = new LinkedHashMap<String, List<String>>();
            List<Operator<OperatorDesc>> parentOps = op.getParentOperators();
            assert (parentOps.size() == ((JoinDesc)op.getConf()).getBaseSrc().length);
            int pos = 0;
            for (String src : ((JoinDesc)op.getConf()).getBaseSrc()) {
                TableScanOperator tso;
                List keyColNames;
                if (src != null) {
                    assert (parentOps.get(pos) instanceof ReduceSinkOperator);
                    ReduceSinkOperator reduceSinkOp = (ReduceSinkOperator)parentOps.get(pos);
                    keyColNames = TableAccessAnalyzer.getKeyColNames(((ReduceSinkDesc)reduceSinkOp.getConf()).getKeyCols());
                    if (keyColNames == null) {
                        return null;
                    }
                    tso = TableAccessAnalyzer.genRootTableScan(reduceSinkOp.getParentOperators().get(0), keyColNames);
                    if (tso == null) {
                        return null;
                    }
                } else {
                    return null;
                }
                Table tbl = ((TableScanDesc)tso.getConf()).getTableMetadata();
                tableToKeysMap.put(tbl.getCompleteName(), keyColNames);
                ++pos;
            }
            tableAccessCtx.addOperatorTableAccess(op, tableToKeysMap);
            return null;
        }
    }

    public class GroupByProcessor
    implements NodeProcessor {
        protected ParseContext pGraphContext;

        public GroupByProcessor(ParseContext pGraphContext) {
            this.pGraphContext = pGraphContext;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) {
            GroupByOperator op = (GroupByOperator)nd;
            TableAccessCtx tableAccessCtx = (TableAccessCtx)procCtx;
            List keyColNames = TableAccessAnalyzer.getKeyColNames(((GroupByDesc)op.getConf()).getKeys());
            if (keyColNames == null) {
                return null;
            }
            TableScanOperator tso = TableAccessAnalyzer.genRootTableScan(op.getParentOperators().get(0), keyColNames);
            if (tso == null) {
                return null;
            }
            LinkedHashMap<String, List<String>> tableToKeysMap = new LinkedHashMap<String, List<String>>();
            Table tbl = ((TableScanDesc)tso.getConf()).getTableMetadata();
            tableToKeysMap.put(tbl.getCompleteName(), keyColNames);
            tableAccessCtx.addOperatorTableAccess(op, tableToKeysMap);
            return null;
        }
    }
}

