/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.binary;

import com.facebook.presto.rcfile.RcFileDecoderUtils;
import com.facebook.presto.rcfile.binary.BinaryColumnEncoding;
import com.facebook.presto.rcfile.binary.BlockEncoding;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class MapEncoding
extends BlockEncoding {
    private final BinaryColumnEncoding keyReader;
    private final BinaryColumnEncoding valueReader;

    public MapEncoding(Type type, BinaryColumnEncoding keyReader, BinaryColumnEncoding valueReader) {
        super(type);
        this.keyReader = keyReader;
        this.valueReader = valueReader;
    }

    @Override
    public void encodeValue(Block block, int position, SliceOutput output) {
        int elementIndex;
        Block map = (Block)block.getObject(position, Block.class);
        RcFileDecoderUtils.writeVInt(output, map.getPositionCount() / 2);
        int nullByte = 85;
        int bits = 0;
        for (elementIndex = 0; elementIndex < map.getPositionCount(); elementIndex += 2) {
            if (map.isNull(elementIndex)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Map must never contain null keys");
            }
            if (bits == 8) {
                output.writeByte(nullByte);
                nullByte = 85;
                bits = 0;
            }
            if (!map.isNull(elementIndex + 1)) {
                nullByte |= 1 << bits + 1;
            }
            bits += 2;
        }
        output.writeByte(nullByte);
        for (elementIndex = 0; elementIndex < map.getPositionCount(); elementIndex += 2) {
            if (map.isNull(elementIndex)) continue;
            this.keyReader.encodeValueInto(map, elementIndex, output);
            if (map.isNull(elementIndex + 1)) continue;
            this.valueReader.encodeValueInto(map, elementIndex + 1, output);
        }
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        int nullByteEnd;
        int entries = Math.toIntExact(RcFileDecoderUtils.readVInt(slice, offset));
        offset += RcFileDecoderUtils.decodeVIntSize(slice.getByte(offset));
        int nullByteCur = offset;
        int elementOffset = nullByteEnd = offset + (entries * 2 + 7) / 8;
        BlockBuilder mapBuilder = builder.beginBlockEntry();
        for (int i = 0; i < entries; ++i) {
            boolean nullKey;
            if ((slice.getByte(nullByteCur) & 1 << i * 2 % 8) != 0) {
                int keyOffset = this.keyReader.getValueOffset(slice, elementOffset);
                int keyLength = this.keyReader.getValueLength(slice, elementOffset);
                this.keyReader.decodeValueInto(mapBuilder, slice, elementOffset + keyOffset, keyLength);
                nullKey = false;
                elementOffset = elementOffset + keyOffset + keyLength;
            } else {
                nullKey = true;
            }
            if ((slice.getByte(nullByteCur) & 1 << (i * 2 + 1) % 8) != 0) {
                int valueOffset = this.valueReader.getValueOffset(slice, elementOffset);
                int valueLength = this.valueReader.getValueLength(slice, elementOffset);
                if (!nullKey) {
                    this.valueReader.decodeValueInto(mapBuilder, slice, elementOffset + valueOffset, valueLength);
                }
                elementOffset = elementOffset + valueOffset + valueLength;
            } else if (!nullKey) {
                mapBuilder.appendNull();
            }
            if (3 != i % 4) continue;
            ++nullByteCur;
        }
        builder.closeEntry();
    }
}

