/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.GroupField;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetValidationUtils;
import com.facebook.presto.parquet.PrimitiveField;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.parquet.reader.ColumnChunkDescriptor;
import com.facebook.presto.parquet.reader.ListColumnReader;
import com.facebook.presto.parquet.reader.ParquetColumnChunk;
import com.facebook.presto.parquet.reader.PrimitiveColumnReader;
import com.facebook.presto.parquet.reader.StructColumnReader;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.RowBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;

public class ParquetReader
implements Closeable {
    private static final int MAX_VECTOR_LENGTH = 1024;
    private final List<BlockMetaData> blocks;
    private final List<PrimitiveColumnIO> columns;
    private final ParquetDataSource dataSource;
    private final AggregatedMemoryContext systemMemoryContext;
    private int currentBlock;
    private BlockMetaData currentBlockMetadata;
    private long currentPosition;
    private long currentGroupRowCount;
    private long nextRowInGroup;
    private int batchSize;
    private final PrimitiveColumnReader[] columnReaders;
    private AggregatedMemoryContext currentRowGroupMemoryContext;

    public ParquetReader(MessageColumnIO messageColumnIO, List<BlockMetaData> blocks, ParquetDataSource dataSource, AggregatedMemoryContext systemMemoryContext) {
        this.blocks = blocks;
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.currentRowGroupMemoryContext = systemMemoryContext.newAggregatedMemoryContext();
        this.columns = messageColumnIO.getLeaves();
        this.columnReaders = new PrimitiveColumnReader[this.columns.size()];
    }

    @Override
    public void close() throws IOException {
        this.currentRowGroupMemoryContext.close();
        this.dataSource.close();
    }

    public long getPosition() {
        return this.currentPosition;
    }

    public int nextBatch() {
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            return -1;
        }
        this.batchSize = Math.toIntExact(Math.min(1024L, this.currentGroupRowCount - this.nextRowInGroup));
        this.nextRowInGroup += (long)this.batchSize;
        this.currentPosition += (long)this.batchSize;
        Arrays.stream(this.columnReaders).forEach(reader -> reader.prepareNextRead(this.batchSize));
        return this.batchSize;
    }

    private boolean advanceToNextRowGroup() {
        this.currentRowGroupMemoryContext.close();
        this.currentRowGroupMemoryContext = this.systemMemoryContext.newAggregatedMemoryContext();
        if (this.currentBlock == this.blocks.size()) {
            return false;
        }
        this.currentBlockMetadata = this.blocks.get(this.currentBlock);
        ++this.currentBlock;
        this.nextRowInGroup = 0L;
        this.currentGroupRowCount = this.currentBlockMetadata.getRowCount();
        this.initializeColumnReaders();
        return true;
    }

    private ColumnChunk readArray(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 1 ? 1 : 0) != 0, (String)"Arrays must have a single type parameter, found %d", (int)parameters.size());
        Field elementField = field.getChildren().get(0).get();
        ColumnChunk columnChunk = this.readColumnChunk(elementField);
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block arrayBlock = ArrayBlock.fromElementBlock((int)valueIsNull.size(), Optional.of(valueIsNull.toBooleanArray()), (int[])offsets.toIntArray(), (Block)columnChunk.getBlock());
        return new ColumnChunk(arrayBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readMap(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Maps must have two type parameters, found %d", (int)parameters.size());
        Block[] blocks = new Block[parameters.size()];
        ColumnChunk columnChunk = this.readColumnChunk(field.getChildren().get(0).get());
        blocks[0] = columnChunk.getBlock();
        blocks[1] = this.readColumnChunk(field.getChildren().get(1).get()).getBlock();
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block mapBlock = ((MapType)field.getType()).createBlockFromKeyValue(Optional.of(valueIsNull.toBooleanArray()), offsets.toIntArray(), blocks[0], blocks[1]);
        return new ColumnChunk(mapBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readStruct(GroupField field) throws IOException {
        int i;
        List fields = field.getType().getTypeSignature().getParameters();
        Block[] blocks = new Block[fields.size()];
        ColumnChunk columnChunk = null;
        List<Optional<Field>> parameters = field.getChildren();
        for (i = 0; i < fields.size(); ++i) {
            Optional<Field> parameter = parameters.get(i);
            if (!parameter.isPresent()) continue;
            columnChunk = this.readColumnChunk(parameter.get());
            blocks[i] = columnChunk.getBlock();
        }
        for (i = 0; i < fields.size(); ++i) {
            if (blocks[i] != null) continue;
            blocks[i] = RunLengthEncodedBlock.create((Type)field.getType(), null, (int)columnChunk.getBlock().getPositionCount());
        }
        BooleanList structIsNull = StructColumnReader.calculateStructOffsets(field, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        boolean[] structIsNullVector = structIsNull.toBooleanArray();
        Block rowBlock = RowBlock.fromFieldBlocks((int)structIsNullVector.length, Optional.of(structIsNullVector), (Block[])blocks);
        return new ColumnChunk(rowBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readPrimitive(PrimitiveField field) throws IOException {
        RichColumnDescriptor columnDescriptor = field.getDescriptor();
        PrimitiveColumnReader columnReader = this.columnReaders[field.getId()];
        if (columnReader.getPageReader() == null) {
            ParquetValidationUtils.validateParquet(this.currentBlockMetadata.getRowCount() > 0L, "Row group has 0 rows", new Object[0]);
            ColumnChunkMetaData metadata = this.getColumnChunkMetaData(columnDescriptor);
            long startingPosition = metadata.getStartingPos();
            int totalSize = Math.toIntExact(metadata.getTotalSize());
            byte[] buffer = this.allocateBlock(totalSize);
            this.dataSource.readFully(startingPosition, buffer);
            ColumnChunkDescriptor descriptor = new ColumnChunkDescriptor(columnDescriptor, metadata, totalSize);
            ParquetColumnChunk columnChunk = new ParquetColumnChunk(descriptor, buffer, 0);
            columnReader.setPageReader(columnChunk.readAllPages());
        }
        return columnReader.readPrimitive(field);
    }

    private byte[] allocateBlock(int length) {
        byte[] buffer = new byte[length];
        LocalMemoryContext blockMemoryContext = this.currentRowGroupMemoryContext.newLocalMemoryContext(ParquetReader.class.getSimpleName());
        blockMemoryContext.setBytes((long)buffer.length);
        return buffer;
    }

    private ColumnChunkMetaData getColumnChunkMetaData(ColumnDescriptor columnDescriptor) throws IOException {
        for (ColumnChunkMetaData metadata : this.currentBlockMetadata.getColumns()) {
            if (!metadata.getPath().equals((Object)ColumnPath.get((String[])columnDescriptor.getPath()))) continue;
            return metadata;
        }
        throw new ParquetCorruptionException("Metadata is missing for column: %s", columnDescriptor);
    }

    private void initializeColumnReaders() {
        for (PrimitiveColumnIO columnIO : this.columns) {
            RichColumnDescriptor column = new RichColumnDescriptor(columnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
            this.columnReaders[columnIO.getId()] = PrimitiveColumnReader.createReader(column);
        }
    }

    public Block readBlock(Field field) throws IOException {
        return this.readColumnChunk(field).getBlock();
    }

    private ColumnChunk readColumnChunk(Field field) throws IOException {
        ColumnChunk columnChunk = "row".equals(field.getType().getTypeSignature().getBase()) ? this.readStruct((GroupField)field) : ("map".equals(field.getType().getTypeSignature().getBase()) ? this.readMap((GroupField)field) : ("array".equals(field.getType().getTypeSignature().getBase()) ? this.readArray((GroupField)field) : this.readPrimitive((PrimitiveField)field)));
        return columnChunk;
    }

    public ParquetDataSource getDataSource() {
        return this.dataSource;
    }

    public AggregatedMemoryContext getSystemMemoryContext() {
        return this.systemMemoryContext;
    }
}

