/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.facebook.presto.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.$internal.com.google.common.cache.Cache;
import com.facebook.presto.hadoop.$internal.com.google.common.cache.CacheBuilder;
import com.facebook.presto.hadoop.$internal.com.google.common.cache.RemovalListener;
import com.facebook.presto.hadoop.$internal.com.google.common.cache.RemovalNotification;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.hdfs.DFSUtil;

public class KeyProviderCache {
    public static final Log LOG = LogFactory.getLog(KeyProviderCache.class);
    private final Cache<URI, KeyProvider> cache;

    public KeyProviderCache(long expiryMs) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(expiryMs, TimeUnit.MILLISECONDS).removalListener(new RemovalListener<URI, KeyProvider>(){

            @Override
            public void onRemoval(RemovalNotification<URI, KeyProvider> notification) {
                try {
                    notification.getValue().close();
                }
                catch (Throwable e) {
                    LOG.error("Error closing KeyProvider with uri [" + notification.getKey() + "]", e);
                }
            }
        }).build();
    }

    public KeyProvider get(final Configuration conf) {
        URI kpURI = this.createKeyProviderURI(conf);
        if (kpURI == null) {
            return null;
        }
        try {
            return this.cache.get(kpURI, new Callable<KeyProvider>(){

                @Override
                public KeyProvider call() throws Exception {
                    return DFSUtil.createKeyProvider(conf);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Could not create KeyProvider for DFSClient !!", e.getCause());
            return null;
        }
    }

    private URI createKeyProviderURI(Configuration conf) {
        URI providerUri;
        String providerUriStr = conf.getTrimmed("dfs.encryption.key.provider.uri", "");
        if (providerUriStr.isEmpty()) {
            LOG.error("Could not find uri with key [dfs.encryption.key.provider.uri] to create a keyProvider !!");
            return null;
        }
        try {
            providerUri = new URI(providerUriStr);
        }
        catch (URISyntaxException e) {
            LOG.error("KeyProvider URI string is invalid [" + providerUriStr + "]!!", e.getCause());
            return null;
        }
        return providerUri;
    }

    @VisibleForTesting
    public void setKeyProvider(Configuration conf, KeyProvider keyProvider) throws IOException {
        URI uri = this.createKeyProviderURI(conf);
        this.cache.put(uri, keyProvider);
    }
}

