/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HiveBucketHandle {
    private final List<HiveColumnHandle> columns;
    private final int tableBucketCount;
    private final int readBucketCount;

    @JsonCreator
    public HiveBucketHandle(@JsonProperty(value="columns") List<HiveColumnHandle> columns, @JsonProperty(value="tableBucketCount") int tableBucketCount, @JsonProperty(value="readBucketCount") int readBucketCount) {
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.tableBucketCount = tableBucketCount;
        this.readBucketCount = readBucketCount;
    }

    @JsonProperty
    public List<HiveColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getTableBucketCount() {
        return this.tableBucketCount;
    }

    @JsonProperty
    public int getReadBucketCount() {
        return this.readBucketCount;
    }

    public boolean isVirtuallyBucketed() {
        return this.columns.size() == 1 && this.columns.get(0).equals(HiveColumnHandle.pathColumnHandle());
    }

    public HiveBucketProperty toTableBucketProperty() {
        Preconditions.checkState((!this.isVirtuallyBucketed() ? 1 : 0) != 0, (Object)"Virtual bucket does not have table bucket property");
        return new HiveBucketProperty(this.columns.stream().map(HiveColumnHandle::getName).collect(Collectors.toList()), this.tableBucketCount, (List<SortingColumn>)ImmutableList.of());
    }

    public static HiveBucketHandle createVirtualBucketHandle(int virtualBucketCount) {
        return new HiveBucketHandle((List<HiveColumnHandle>)ImmutableList.of((Object)HiveColumnHandle.pathColumnHandle()), virtualBucketCount, virtualBucketCount);
    }
}

