/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.DynamicConfigurationProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class HiveHdfsConfiguration
implements HdfsConfiguration {
    private static final Configuration INITIAL_CONFIGURATION = ConfigurationUtils.getInitialConfiguration();
    private final ThreadLocal<Configuration> hadoopConfiguration = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            Configuration configuration = new Configuration(false);
            ConfigurationUtils.copy(INITIAL_CONFIGURATION, configuration);
            HiveHdfsConfiguration.this.initializer.updateConfiguration(configuration);
            return configuration;
        }
    };
    private final HdfsConfigurationInitializer initializer;
    private final Set<DynamicConfigurationProvider> dynamicProviders;

    @Inject
    public HiveHdfsConfiguration(HdfsConfigurationInitializer initializer, Set<DynamicConfigurationProvider> dynamicProviders) {
        this.initializer = Objects.requireNonNull(initializer, "initializer is null");
        this.dynamicProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(dynamicProviders, "dynamicProviders is null"));
    }

    @Override
    public Configuration getConfiguration(HdfsEnvironment.HdfsContext context, URI uri) {
        if (this.dynamicProviders.isEmpty()) {
            return this.hadoopConfiguration.get();
        }
        Configuration config = new Configuration(false);
        ConfigurationUtils.copy(this.hadoopConfiguration.get(), config);
        for (DynamicConfigurationProvider provider : this.dynamicProviders) {
            provider.updateConfiguration(config, context, uri);
        }
        return config;
    }
}

