/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveBucketAdapterRecordCursor;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCoercionRecordCursor;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePageSource;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSelectivePageSourceFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public class HivePageSourceProvider
implements ConnectorPageSourceProvider {
    private final DateTimeZone hiveStorageTimeZone;
    private final HdfsEnvironment hdfsEnvironment;
    private final Set<HiveRecordCursorProvider> cursorProviders;
    private final Set<HiveBatchPageSourceFactory> pageSourceFactories;
    private final Set<HiveSelectivePageSourceFactory> selectivePageSourceFactories;
    private final TypeManager typeManager;
    private final RowExpressionService rowExpressionService;

    @Inject
    public HivePageSourceProvider(HiveClientConfig hiveClientConfig, HdfsEnvironment hdfsEnvironment, Set<HiveRecordCursorProvider> cursorProviders, Set<HiveBatchPageSourceFactory> pageSourceFactories, Set<HiveSelectivePageSourceFactory> selectivePageSourceFactories, TypeManager typeManager, RowExpressionService rowExpressionService) {
        Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        this.hiveStorageTimeZone = hiveClientConfig.getDateTimeZone();
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.cursorProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(cursorProviders, "cursorProviders is null"));
        this.pageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(pageSourceFactories, "pageSourceFactories is null"));
        this.selectivePageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(selectivePageSourceFactories, "selectivePageSourceFactories is null"));
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableLayoutHandle layout, List<ColumnHandle> columns) {
        HiveTableLayoutHandle hiveLayout = (HiveTableLayoutHandle)layout;
        List<HiveColumnHandle> selectedColumns = columns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList());
        HiveSplit hiveSplit = (HiveSplit)split;
        Path path = new Path(hiveSplit.getPath());
        Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, hiveSplit.getDatabase(), hiveSplit.getTable()), path);
        if (HiveSessionProperties.isPushdownFilterEnabled(session)) {
            return HivePageSourceProvider.createSelectivePageSource(this.selectivePageSourceFactories, configuration, session, hiveSplit, hiveLayout, HivePageSourceProvider.assignUniqueIndicesToPartitionColumns(selectedColumns), this.hiveStorageTimeZone, this.rowExpressionService);
        }
        Optional<ConnectorPageSource> pageSource = HivePageSourceProvider.createHivePageSource(this.cursorProviders, this.pageSourceFactories, configuration, session, path, hiveSplit.getTableBucketNumber(), hiveSplit.getStart(), hiveSplit.getLength(), hiveSplit.getFileSize(), hiveSplit.getStorage(), (TupleDomain<HiveColumnHandle>)hiveLayout.getDomainPredicate().transform(Subfield::getRootName).transform(hiveLayout.getPredicateColumns()::get), selectedColumns, hiveSplit.getPartitionKeys(), this.hiveStorageTimeZone, this.typeManager, hiveLayout.getSchemaTableName(), hiveLayout.getPartitionColumns(), hiveLayout.getDataColumns(), hiveLayout.getTableParameters(), hiveSplit.getPartitionDataColumnCount(), hiveSplit.getPartitionSchemaDifference(), hiveSplit.getBucketConversion(), hiveSplit.isS3SelectPushdownEnabled());
        if (pageSource.isPresent()) {
            return pageSource.get();
        }
        throw new IllegalStateException("Could not find a file reader for split " + hiveSplit);
    }

    private static ConnectorPageSource createSelectivePageSource(Set<HiveSelectivePageSourceFactory> selectivePageSourceFactories, Configuration configuration, ConnectorSession session, HiveSplit split, HiveTableLayoutHandle layout, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, RowExpressionService rowExpressionService) {
        ImmutableSet interimColumns = ImmutableSet.builder().addAll(layout.getPredicateColumns().values()).addAll((Iterable)split.getBucketConversion().map(HiveSplit.BucketConversion::getBucketColumnHandles).orElse((List)ImmutableList.of())).build();
        Set columnNames = (Set)columns.stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        ImmutableList allColumns = ImmutableList.builder().addAll(columns).addAll((Iterable)interimColumns.stream().filter(column -> !columnNames.contains(column.getName())).collect(ImmutableList.toImmutableList())).build();
        Path path = new Path(split.getPath());
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(split.getPartitionKeys(), (List<HiveColumnHandle>)allColumns, (List<HiveColumnHandle>)ImmutableList.of(), split.getPartitionSchemaDifference(), path, split.getTableBucketNumber());
        Optional<BucketAdaptation> bucketAdaptation = split.getBucketConversion().map(conversion -> HivePageSourceProvider.toBucketAdaptation(conversion, columnMappings, split.getTableBucketNumber()));
        Preconditions.checkArgument((!bucketAdaptation.isPresent() ? 1 : 0) != 0, (Object)"Bucket conversion is not supported yet");
        Map prefilledValues = (Map)columnMappings.stream().filter(mapping -> mapping.getKind() == ColumnMappingKind.PREFILLED).collect(ImmutableMap.toImmutableMap(mapping -> mapping.getHiveColumnHandle().getHiveColumnIndex(), ColumnMapping::getPrefilledValue));
        List outputColumns = (List)columns.stream().map(HiveColumnHandle::getHiveColumnIndex).collect(ImmutableList.toImmutableList());
        RowExpression optimizedRemainingPredicate = rowExpressionService.getExpressionOptimizer().optimize(layout.getRemainingPredicate(), ExpressionOptimizer.Level.OPTIMIZED, session);
        for (HiveSelectivePageSourceFactory pageSourceFactory : selectivePageSourceFactories) {
            Optional<? extends ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(configuration, session, path, split.getStart(), split.getLength(), split.getFileSize(), split.getStorage(), ColumnMapping.toColumnHandles(columnMappings, true), prefilledValues, outputColumns, layout.getDomainPredicate(), optimizedRemainingPredicate, hiveStorageTimeZone);
            if (!pageSource.isPresent()) continue;
            return pageSource.get();
        }
        throw new IllegalStateException("Could not find a file reader for split " + split);
    }

    private static List<HiveColumnHandle> assignUniqueIndicesToPartitionColumns(List<HiveColumnHandle> columns) {
        int nextIndex = -13;
        ImmutableList.Builder newColumns = ImmutableList.builder();
        for (HiveColumnHandle column : columns) {
            if (column.isPartitionKey()) {
                newColumns.add((Object)new HiveColumnHandle(column.getName(), column.getHiveType(), column.getTypeSignature(), nextIndex--, column.getColumnType(), column.getComment(), column.getRequiredSubfields()));
                continue;
            }
            newColumns.add((Object)column);
        }
        return newColumns.build();
    }

    public static Optional<ConnectorPageSource> createHivePageSource(Set<HiveRecordCursorProvider> cursorProviders, Set<HiveBatchPageSourceFactory> pageSourceFactories, Configuration configuration, ConnectorSession session, Path path, OptionalInt tableBucketNumber, long start, long length, long fileSize, Storage storage, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> hiveColumns, List<HivePartitionKey> partitionKeys, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, SchemaTableName tableName, List<HiveColumnHandle> partitionKeyColumnHandles, List<Column> tableDataColumns, Map<String, String> tableParameters, int partitionDataColumnCount, Map<Integer, Column> partitionSchemaDifference, Optional<HiveSplit.BucketConversion> bucketConversion, boolean s3SelectPushdownEnabled) {
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(partitionKeys, hiveColumns, bucketConversion.map(HiveSplit.BucketConversion::getBucketColumnHandles).orElse((List)ImmutableList.of()), partitionSchemaDifference, path, tableBucketNumber);
        List<ColumnMapping> regularAndInterimColumnMappings = ColumnMapping.extractRegularAndInterimColumnMappings(columnMappings);
        Optional<BucketAdaptation> bucketAdaptation = bucketConversion.map(conversion -> HivePageSourceProvider.toBucketAdaptation(conversion, regularAndInterimColumnMappings, tableBucketNumber));
        for (HiveBatchPageSourceFactory pageSourceFactory : pageSourceFactories) {
            Optional<? extends ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(configuration, session, path, start, length, fileSize, storage, tableParameters, ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, true), effectivePredicate, hiveStorageTimeZone);
            if (!pageSource.isPresent()) continue;
            return Optional.of(new HivePageSource(columnMappings, bucketAdaptation, hiveStorageTimeZone, typeManager, pageSource.get()));
        }
        for (HiveRecordCursorProvider provider : cursorProviders) {
            boolean doCoercion = !(provider instanceof GenericHiveRecordCursorProvider);
            List<Column> partitionDataColumns = MetastoreUtil.reconstructPartitionSchema(tableDataColumns, partitionDataColumnCount, partitionSchemaDifference);
            List partitionKeyColumns = (List)partitionKeyColumnHandles.stream().map(handle -> new Column(handle.getName(), handle.getHiveType(), handle.getComment())).collect(ImmutableList.toImmutableList());
            Properties schema = MetastoreUtil.getHiveSchema(storage, partitionDataColumns, tableDataColumns, tableParameters, tableName.getSchemaName(), tableName.getTableName(), partitionKeyColumns);
            Optional<RecordCursor> cursor = provider.createRecordCursor(configuration, session, path, start, length, fileSize, schema, ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, doCoercion), effectivePredicate, hiveStorageTimeZone, typeManager, s3SelectPushdownEnabled);
            if (!cursor.isPresent()) continue;
            RecordCursor delegate = cursor.get();
            if (bucketAdaptation.isPresent()) {
                delegate = new HiveBucketAdapterRecordCursor(bucketAdaptation.get().getBucketColumnIndices(), bucketAdaptation.get().getBucketColumnHiveTypes(), bucketAdaptation.get().getTableBucketCount(), bucketAdaptation.get().getPartitionBucketCount(), bucketAdaptation.get().getBucketToKeep(), typeManager, delegate);
            }
            if (doCoercion) {
                delegate = new HiveCoercionRecordCursor(regularAndInterimColumnMappings, typeManager, delegate);
            }
            HiveRecordCursor hiveRecordCursor = new HiveRecordCursor(columnMappings, hiveStorageTimeZone, typeManager, delegate);
            List columnTypes = hiveColumns.stream().map(input -> typeManager.getType(input.getTypeSignature())).collect(Collectors.toList());
            return Optional.of(new RecordPageSource(columnTypes, (RecordCursor)hiveRecordCursor));
        }
        return Optional.empty();
    }

    private static BucketAdaptation toBucketAdaptation(HiveSplit.BucketConversion conversion, List<ColumnMapping> columnMappings, OptionalInt tableBucketNumber) {
        ImmutableMap hiveIndexToBlockIndex = Maps.uniqueIndex(columnMappings, columnMapping -> columnMapping.getHiveColumnHandle().getHiveColumnIndex());
        int[] bucketColumnIndices = conversion.getBucketColumnHandles().stream().map(HiveColumnHandle::getHiveColumnIndex).map(((Map)hiveIndexToBlockIndex)::get).mapToInt(ColumnMapping::getIndex).toArray();
        List bucketColumnHiveTypes = (List)conversion.getBucketColumnHandles().stream().map(HiveColumnHandle::getHiveColumnIndex).map(((Map)hiveIndexToBlockIndex)::get).map(ColumnMapping::getHiveColumnHandle).map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList());
        return new BucketAdaptation(bucketColumnIndices, bucketColumnHiveTypes, conversion.getTableBucketCount(), conversion.getPartitionBucketCount(), tableBucketNumber.getAsInt());
    }

    public static class BucketAdaptation {
        private final int[] bucketColumnIndices;
        private final List<HiveType> bucketColumnHiveTypes;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final int bucketToKeep;

        public BucketAdaptation(int[] bucketColumnIndices, List<HiveType> bucketColumnHiveTypes, int tableBucketCount, int partitionBucketCount, int bucketToKeep) {
            this.bucketColumnIndices = bucketColumnIndices;
            this.bucketColumnHiveTypes = bucketColumnHiveTypes;
            this.tableBucketCount = tableBucketCount;
            this.partitionBucketCount = partitionBucketCount;
            this.bucketToKeep = bucketToKeep;
        }

        public int[] getBucketColumnIndices() {
            return this.bucketColumnIndices;
        }

        public List<HiveType> getBucketColumnHiveTypes() {
            return this.bucketColumnHiveTypes;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getPartitionBucketCount() {
            return this.partitionBucketCount;
        }

        public int getBucketToKeep() {
            return this.bucketToKeep;
        }
    }

    public static enum ColumnMappingKind {
        REGULAR,
        PREFILLED,
        INTERIM;

    }

    public static class ColumnMapping {
        private final ColumnMappingKind kind;
        private final HiveColumnHandle hiveColumnHandle;
        private final Optional<String> prefilledValue;
        private final OptionalInt index;
        private final Optional<HiveType> coercionFrom;

        public static ColumnMapping regular(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> coerceFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.REGULAR, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), coerceFrom);
        }

        public static ColumnMapping prefilled(HiveColumnHandle hiveColumnHandle, String prefilledValue, Optional<HiveType> coerceFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.PARTITION_KEY || hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.PREFILLED, hiveColumnHandle, Optional.of(prefilledValue), OptionalInt.empty(), coerceFrom);
        }

        public static ColumnMapping interim(HiveColumnHandle hiveColumnHandle, int index) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.INTERIM, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), Optional.empty());
        }

        private ColumnMapping(ColumnMappingKind kind, HiveColumnHandle hiveColumnHandle, Optional<String> prefilledValue, OptionalInt index, Optional<HiveType> coerceFrom) {
            this.kind = Objects.requireNonNull(kind, "kind is null");
            this.hiveColumnHandle = Objects.requireNonNull(hiveColumnHandle, "hiveColumnHandle is null");
            this.prefilledValue = Objects.requireNonNull(prefilledValue, "prefilledValue is null");
            this.index = Objects.requireNonNull(index, "index is null");
            this.coercionFrom = Objects.requireNonNull(coerceFrom, "coerceFrom is null");
        }

        public ColumnMappingKind getKind() {
            return this.kind;
        }

        public String getPrefilledValue() {
            Preconditions.checkState((this.kind == ColumnMappingKind.PREFILLED ? 1 : 0) != 0);
            return this.prefilledValue.get();
        }

        public HiveColumnHandle getHiveColumnHandle() {
            return this.hiveColumnHandle;
        }

        public int getIndex() {
            Preconditions.checkState((this.kind == ColumnMappingKind.REGULAR || this.kind == ColumnMappingKind.INTERIM ? 1 : 0) != 0);
            return this.index.getAsInt();
        }

        public Optional<HiveType> getCoercionFrom() {
            return this.coercionFrom;
        }

        public static List<ColumnMapping> buildColumnMappings(List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, List<HiveColumnHandle> requiredInterimColumns, Map<Integer, Column> partitionSchemaDifference, Path path, OptionalInt bucketNumber) {
            ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
            int regularIndex = 0;
            HashSet<Integer> regularColumnIndices = new HashSet<Integer>();
            ImmutableList.Builder columnMappings = ImmutableList.builder();
            for (HiveColumnHandle column : columns) {
                Optional<Column> partitionColumn = Optional.ofNullable(partitionSchemaDifference.get(column.getHiveColumnIndex()));
                Optional<HiveType> coercionFrom = Optional.empty();
                if (partitionColumn.isPresent() && !partitionColumn.get().getType().equals(column.getHiveType())) {
                    coercionFrom = Optional.of(partitionColumn.get().getType());
                }
                if (column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR) {
                    Preconditions.checkArgument((boolean)regularColumnIndices.add(column.getHiveColumnIndex()), (Object)"duplicate hiveColumnIndex in columns list");
                    columnMappings.add((Object)ColumnMapping.regular(column, regularIndex, coercionFrom));
                    ++regularIndex;
                    continue;
                }
                columnMappings.add((Object)ColumnMapping.prefilled(column, HiveUtil.getPrefilledColumnValue(column, (HivePartitionKey)partitionKeysByName.get(column.getName()), path, bucketNumber), coercionFrom));
            }
            for (HiveColumnHandle column : requiredInterimColumns) {
                Preconditions.checkArgument((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
                if (regularColumnIndices.contains(column.getHiveColumnIndex())) continue;
                columnMappings.add((Object)ColumnMapping.interim(column, regularIndex));
                ++regularIndex;
            }
            return columnMappings.build();
        }

        public static List<ColumnMapping> extractRegularAndInterimColumnMappings(List<ColumnMapping> columnMappings) {
            return (List)columnMappings.stream().filter(columnMapping -> columnMapping.getKind() == ColumnMappingKind.REGULAR || columnMapping.getKind() == ColumnMappingKind.INTERIM).collect(ImmutableList.toImmutableList());
        }

        public static List<HiveColumnHandle> toColumnHandles(List<ColumnMapping> regularColumnMappings, boolean doCoercion) {
            return regularColumnMappings.stream().map(columnMapping -> {
                HiveColumnHandle columnHandle = columnMapping.getHiveColumnHandle();
                if (!doCoercion || !columnMapping.getCoercionFrom().isPresent()) {
                    return columnHandle;
                }
                return new HiveColumnHandle(columnHandle.getName(), columnMapping.getCoercionFrom().get(), columnMapping.getCoercionFrom().get().getTypeSignature(), columnHandle.getHiveColumnIndex(), columnHandle.getColumnType(), Optional.empty(), columnHandle.getRequiredSubfields());
            }).collect(Collectors.toList());
        }
    }
}

