/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class HivePartitionManager {
    private static final String PARTITION_VALUE_WILDCARD = "";
    private final DateTimeZone timeZone;
    private final boolean assumeCanonicalPartitionKeys;
    private final TypeManager typeManager;
    private final int maxPartitionsPerScan;
    private final int domainCompactionThreshold;

    @Inject
    public HivePartitionManager(TypeManager typeManager, HiveClientConfig hiveClientConfig) {
        this(typeManager, hiveClientConfig.getDateTimeZone(), hiveClientConfig.isAssumeCanonicalPartitionKeys(), hiveClientConfig.getMaxPartitionsPerScan(), hiveClientConfig.getDomainCompactionThreshold());
    }

    public HivePartitionManager(TypeManager typeManager, DateTimeZone timeZone, boolean assumeCanonicalPartitionKeys, int maxPartitionsPerScan, int domainCompactionThreshold) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.maxPartitionsPerScan = maxPartitionsPerScan;
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        this.domainCompactionThreshold = domainCompactionThreshold;
    }

    public Iterable<HivePartition> getPartitionsIterator(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, ConnectorSession session) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicate = constraint.getSummary();
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(metastore, tableName, HiveSessionProperties.isOfflineDataDebugModeEnabled(session));
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List partitionTypes = partitionColumns.stream().map(column -> this.typeManager.getType(column.getTypeSignature())).collect(Collectors.toList());
        return partitionColumns.isEmpty() ? ImmutableList.of((Object)new HivePartition(tableName)) : () -> this.getFilteredPartitionNames(metastore, tableName, partitionColumns, (TupleDomain<ColumnHandle>)effectivePredicate).stream().map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionTypes, constraint)).filter(Optional::isPresent).map(Optional::get).iterator();
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, ConnectorSession session) {
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter;
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicate = constraint.getSummary();
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(metastore, tableName, HiveSessionProperties.isOfflineDataDebugModeEnabled(session));
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List<HivePartition> partitions = this.getPartitionsAsList(this.getPartitionsIterator(metastore, tableHandle, constraint, session).iterator());
        boolean shouldIgnoreTableBucketing = !table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE) && HiveSessionProperties.shouldIgnoreTableBucketing(session);
        Optional<HiveBucketHandle> hiveBucketHandle = shouldIgnoreTableBucketing ? Optional.empty() : HiveBucketing.getHiveBucketHandle(table);
        Optional<HiveBucketing.HiveBucketFilter> optional = bucketFilter = shouldIgnoreTableBucketing ? Optional.empty() : HiveBucketing.getHiveBucketFilter(table, (TupleDomain<ColumnHandle>)effectivePredicate);
        if (!this.queryUsesHiveBucketColumn((TupleDomain<ColumnHandle>)effectivePredicate) && hiveBucketHandle.isPresent() && this.queryAccessesTooManyBuckets((HiveBucketHandle)hiveBucketHandle.get(), bucketFilter, partitions, session)) {
            hiveBucketHandle = Optional.empty();
            bucketFilter = Optional.empty();
        }
        if (effectivePredicate.isNone()) {
            return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitions, (TupleDomain<? extends ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), hiveBucketHandle, Optional.empty());
        }
        TupleDomain compactEffectivePredicate = effectivePredicate.compact(this.domainCompactionThreshold);
        if (partitionColumns.isEmpty()) {
            return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitions, (TupleDomain<? extends ColumnHandle>)compactEffectivePredicate, (TupleDomain<ColumnHandle>)effectivePredicate, (TupleDomain<ColumnHandle>)TupleDomain.none(), hiveBucketHandle, bucketFilter);
        }
        TupleDomain remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(partitionColumns))));
        TupleDomain enforcedTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (com.google.common.base.Predicate)Predicates.in(partitionColumns)));
        return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitions, (TupleDomain<? extends ColumnHandle>)compactEffectivePredicate, (TupleDomain<ColumnHandle>)remainingTupleDomain, (TupleDomain<ColumnHandle>)enforcedTupleDomain, hiveBucketHandle, bucketFilter);
    }

    private boolean queryUsesHiveBucketColumn(TupleDomain<ColumnHandle> effectivePredicate) {
        if (!effectivePredicate.getDomains().isPresent()) {
            return false;
        }
        return ((Map)effectivePredicate.getDomains().get()).keySet().stream().anyMatch(key -> ((HiveColumnHandle)key).getName().equals("$bucket"));
    }

    private boolean queryAccessesTooManyBuckets(HiveBucketHandle handle, Optional<HiveBucketing.HiveBucketFilter> filter, List<HivePartition> partitions, ConnectorSession session) {
        int bucketsPerPartition = filter.map(hiveBucketFilter -> hiveBucketFilter.getBucketsToKeep().size()).orElseGet(handle::getReadBucketCount);
        return bucketsPerPartition * partitions.size() > HiveSessionProperties.getMaxBucketsForGroupedExecution(session);
    }

    private List<HivePartition> getPartitionsAsList(Iterator<HivePartition> partitionsIterator) {
        ImmutableList.Builder partitionList = ImmutableList.builder();
        int count = 0;
        while (partitionsIterator.hasNext()) {
            HivePartition partition = partitionsIterator.next();
            if (count == this.maxPartitionsPerScan) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_EXCEEDED_PARTITION_LIMIT, String.format("Query over table '%s' can potentially read more than %s partitions", partition.getTableName(), this.maxPartitionsPerScan));
            }
            partitionList.add((Object)partition);
            ++count;
        }
        return partitionList.build();
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, List<List<String>> partitionValuesList, ConnectorSession session) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(metastore, tableName, HiveSessionProperties.isOfflineDataDebugModeEnabled(session));
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List partitionColumnTypes = (List)partitionColumns.stream().map(column -> this.typeManager.getType(column.getTypeSignature())).collect(ImmutableList.toImmutableList());
        List partitionList = (List)partitionValuesList.stream().map(partitionValues -> MetastoreUtil.makePartName(table.getPartitionColumns(), partitionValues)).map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionColumnTypes, (Constraint<ColumnHandle>)Constraint.alwaysTrue())).map(partition -> (HivePartition)partition.orElseThrow(() -> new VerifyException("partition must exist"))).collect(ImmutableList.toImmutableList());
        Optional<HiveBucketHandle> bucketHandle = HiveSessionProperties.shouldIgnoreTableBucketing(session) ? Optional.empty() : HiveBucketing.getHiveBucketHandle(table);
        return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitionList, (TupleDomain<? extends ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.none(), bucketHandle, Optional.empty());
    }

    private Optional<HivePartition> parseValuesAndFilterPartition(SchemaTableName tableName, String partitionId, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes, Constraint<ColumnHandle> constraint) {
        HivePartition partition = HivePartitionManager.parsePartition(tableName, partitionId, partitionColumns, partitionColumnTypes, this.timeZone);
        Map domains = (Map)constraint.getSummary().getDomains().get();
        for (HiveColumnHandle column : partitionColumns) {
            NullableValue value = partition.getKeys().get(column);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return Optional.empty();
        }
        if (constraint.predicate().isPresent() && !((Predicate)constraint.predicate().get()).test(partition.getKeys())) {
            return Optional.empty();
        }
        return Optional.of(partition);
    }

    private Table getTable(SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, boolean offlineDataDebugModeEnabled) {
        Optional<Table> target = metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        Table table = target.get();
        if (!offlineDataDebugModeEnabled) {
            MetastoreUtil.verifyOnline(tableName, Optional.empty(), MetastoreUtil.getProtectMode(table), table.getParameters());
        }
        return table;
    }

    private List<String> getFilteredPartitionNames(SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, List<HiveColumnHandle> partitionKeys, TupleDomain<ColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return ImmutableList.of();
        }
        ArrayList<String> filter = new ArrayList<String>();
        for (HiveColumnHandle partitionKey : partitionKeys) {
            Domain domain = (Domain)((Map)effectivePredicate.getDomains().get()).get(partitionKey);
            if (domain != null && domain.isNullableSingleValue()) {
                Slice slice;
                Object value = domain.getNullableSingleValue();
                Type type = domain.getType();
                if (value == null) {
                    filter.add("__HIVE_DEFAULT_PARTITION__");
                    continue;
                }
                if (type instanceof CharType) {
                    slice = (Slice)value;
                    filter.add(Chars.padSpaces((Slice)slice, (Type)type).toStringUtf8());
                    continue;
                }
                if (type instanceof VarcharType) {
                    slice = (Slice)value;
                    filter.add(slice.toStringUtf8());
                    continue;
                }
                if (!this.assumeCanonicalPartitionKeys) {
                    filter.add(PARTITION_VALUE_WILDCARD);
                    continue;
                }
                if (type instanceof DecimalType && !((DecimalType)type).isShort()) {
                    slice = (Slice)value;
                    filter.add(Decimals.toString((Slice)slice, (int)((DecimalType)type).getScale()));
                    continue;
                }
                if (type instanceof DecimalType && ((DecimalType)type).isShort()) {
                    filter.add(Decimals.toString((long)((Long)value), (int)((DecimalType)type).getScale()));
                    continue;
                }
                if (type instanceof DateType) {
                    DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.date().withZoneUTC();
                    filter.add(dateTimeFormatter.print(TimeUnit.DAYS.toMillis((Long)value)));
                    continue;
                }
                if (type instanceof TimestampType) {
                    filter.add(PARTITION_VALUE_WILDCARD);
                    continue;
                }
                if (type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof DoubleType || type instanceof RealType || type instanceof BooleanType) {
                    filter.add(value.toString());
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported partition key type: %s", type.getDisplayName()));
            }
            filter.add(PARTITION_VALUE_WILDCARD);
        }
        return metastore.getPartitionNamesByParts(tableName.getSchemaName(), tableName.getTableName(), filter).orElseThrow(() -> new TableNotFoundException(tableName));
    }

    public static HivePartition parsePartition(SchemaTableName tableName, String partitionName, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes, DateTimeZone timeZone) {
        List<String> partitionValues = HivePartitionManager.extractPartitionValues(partitionName);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue(partitionName, partitionValues.get(i), partitionColumnTypes.get(i), timeZone);
            builder.put((Object)column, (Object)parsedValue);
        }
        ImmutableMap values = builder.build();
        return new HivePartition(tableName, partitionName, (Map<ColumnHandle, NullableValue>)values);
    }

    public static List<String> extractPartitionValues(String partitionName) {
        ImmutableList.Builder values = ImmutableList.builder();
        boolean inKey = true;
        int valueStart = -1;
        for (int i = 0; i < partitionName.length(); ++i) {
            char current = partitionName.charAt(i);
            if (inKey) {
                Preconditions.checkArgument((current != '/' ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
                if (current != '=') continue;
                inKey = false;
                valueStart = i + 1;
                continue;
            }
            if (current != '/') continue;
            Preconditions.checkArgument((valueStart != -1 ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
            values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, i)));
            inKey = true;
            valueStart = -1;
        }
        Preconditions.checkArgument((!inKey ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
        values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, partitionName.length())));
        return values.build();
    }
}

