/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ForFileRename;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HiveStagingFileCommitter
implements StagingFileCommitter {
    private final HdfsEnvironment hdfsEnvironment;
    private final ListeningExecutorService fileRenameExecutor;

    @Inject
    public HiveStagingFileCommitter(HdfsEnvironment hdfsEnvironment, @ForFileRename ListeningExecutorService fileRenameExecutor) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.fileRenameExecutor = Objects.requireNonNull(fileRenameExecutor, "fileRenameExecutor is null");
    }

    @Override
    public void commitFiles(ConnectorSession session, String schemaName, String tableName, List<PartitionUpdate> partitionUpdates) {
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, schemaName, tableName);
        ArrayList<ListenableFuture> commitFutures = new ArrayList<ListenableFuture>();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            Path path = partitionUpdate.getWritePath();
            FileSystem fileSystem = MetastoreUtil.getFileSystem(this.hdfsEnvironment, context, path);
            for (PartitionUpdate.FileWriteInfo fileWriteInfo : partitionUpdate.getFileWriteInfos()) {
                Preconditions.checkState((!fileWriteInfo.getWriteFileName().equals(fileWriteInfo.getTargetFileName()) ? 1 : 0) != 0);
                Path source = new Path(path, fileWriteInfo.getWriteFileName());
                Path target = new Path(path, fileWriteInfo.getTargetFileName());
                commitFutures.add(this.fileRenameExecutor.submit(() -> MetastoreUtil.renameFile(fileSystem, source, target)));
            }
        }
        ListenableFuture listenableFutureAggregate = Futures.whenAllSucceed(commitFutures).call(() -> null, MoreExecutors.directExecutor());
        try {
            MoreFutures.getFutureValue((Future)listenableFutureAggregate, PrestoException.class);
        }
        catch (RuntimeException e) {
            listenableFutureAggregate.cancel(true);
            throw e;
        }
    }
}

