/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.RowExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class HiveTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final SchemaTableName schemaTableName;
    private final List<HiveColumnHandle> partitionColumns;
    private final List<Column> dataColumns;
    private final Map<String, String> tableParameters;
    private final TupleDomain<Subfield> domainPredicate;
    private final RowExpression remainingPredicate;
    private final Map<String, HiveColumnHandle> predicateColumns;
    private final TupleDomain<ColumnHandle> partitionColumnPredicate;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;
    private final String layoutString;
    @Nullable
    private final List<HivePartition> partitions;

    @JsonCreator
    public HiveTableLayoutHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="partitionColumns") List<HiveColumnHandle> partitionColumns, @JsonProperty(value="dataColumns") List<Column> dataColumns, @JsonProperty(value="tableParameters") Map<String, String> tableParameters, @JsonProperty(value="domainPredicate") TupleDomain<Subfield> domainPredicate, @JsonProperty(value="remainingPredicate") RowExpression remainingPredicate, @JsonProperty(value="predicateColumns") Map<String, HiveColumnHandle> predicateColumns, @JsonProperty(value="partitionColumnPredicate") TupleDomain<ColumnHandle> partitionColumnPredicate, @JsonProperty(value="bucketHandle") Optional<HiveBucketHandle> bucketHandle, @JsonProperty(value="bucketFilter") Optional<HiveBucketing.HiveBucketFilter> bucketFilter, @JsonProperty(value="layoutString") String layoutString) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "table is null");
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.tableParameters = ImmutableMap.copyOf(Objects.requireNonNull(tableParameters, "tableProperties is null"));
        this.domainPredicate = Objects.requireNonNull(domainPredicate, "domainPredicate is null");
        this.remainingPredicate = Objects.requireNonNull(remainingPredicate, "remainingPredicate is null");
        this.predicateColumns = Objects.requireNonNull(predicateColumns, "predicateColumns is null");
        this.partitionColumnPredicate = Objects.requireNonNull(partitionColumnPredicate, "partitionColumnPredicate is null");
        this.partitions = null;
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        this.layoutString = Objects.requireNonNull(layoutString, "layoutString is null");
    }

    public HiveTableLayoutHandle(SchemaTableName schemaTableName, List<HiveColumnHandle> partitionColumns, List<Column> dataColumns, Map<String, String> tableParameters, List<HivePartition> partitions, TupleDomain<Subfield> domainPredicate, RowExpression remainingPredicate, Map<String, HiveColumnHandle> predicateColumns, TupleDomain<ColumnHandle> partitionColumnPredicate, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter, String layoutString) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "table is null");
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.tableParameters = ImmutableMap.copyOf(Objects.requireNonNull(tableParameters, "tableProperties is null"));
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.domainPredicate = Objects.requireNonNull(domainPredicate, "domainPredicate is null");
        this.remainingPredicate = Objects.requireNonNull(remainingPredicate, "remainingPredicate is null");
        this.predicateColumns = Objects.requireNonNull(predicateColumns, "predicateColumns is null");
        this.partitionColumnPredicate = Objects.requireNonNull(partitionColumnPredicate, "partitionColumnPredicate is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        this.layoutString = Objects.requireNonNull(layoutString, "layoutString is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public List<HiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonProperty
    public List<Column> getDataColumns() {
        return this.dataColumns;
    }

    @JsonProperty
    public Map<String, String> getTableParameters() {
        return this.tableParameters;
    }

    @JsonIgnore
    public Optional<List<HivePartition>> getPartitions() {
        return Optional.ofNullable(this.partitions);
    }

    @JsonProperty
    public TupleDomain<Subfield> getDomainPredicate() {
        return this.domainPredicate;
    }

    @JsonProperty
    public RowExpression getRemainingPredicate() {
        return this.remainingPredicate;
    }

    @JsonProperty
    public Map<String, HiveColumnHandle> getPredicateColumns() {
        return this.predicateColumns;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getPartitionColumnPredicate() {
        return this.partitionColumnPredicate;
    }

    @JsonProperty
    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    @JsonProperty
    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }

    @JsonProperty
    public String getLayoutString() {
        return this.layoutString;
    }

    public String toString() {
        return this.layoutString;
    }
}

