/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class HiveTableProperties {
    public static final String EXTERNAL_LOCATION_PROPERTY = "external_location";
    public static final String STORAGE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    public static final String BUCKETED_BY_PROPERTY = "bucketed_by";
    public static final String BUCKET_COUNT_PROPERTY = "bucket_count";
    public static final String SORTED_BY_PROPERTY = "sorted_by";
    public static final String ORC_BLOOM_FILTER_COLUMNS = "orc_bloom_filter_columns";
    public static final String ORC_BLOOM_FILTER_FPP = "orc_bloom_filter_fpp";
    public static final String AVRO_SCHEMA_URL = "avro_schema_url";
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public HiveTableProperties(TypeManager typeManager, HiveClientConfig config) {
        this.tableProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)EXTERNAL_LOCATION_PROPERTY, (String)"File system location URI for external table", null, (boolean)false), (Object)new PropertyMetadata(STORAGE_FORMAT_PROPERTY, "Hive storage format for the table", (Type)VarcharType.createUnboundedVarcharType(), HiveStorageFormat.class, (Object)config.getHiveStorageFormat(), false, value -> HiveStorageFormat.valueOf(((String)value).toUpperCase(Locale.ENGLISH)), Enum::toString), (Object)new PropertyMetadata(PARTITIONED_BY_PROPERTY, "Partition columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value), (Object)new PropertyMetadata(BUCKETED_BY_PROPERTY, "Bucketing columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value), (Object)new PropertyMetadata(SORTED_BY_PROPERTY, "Bucket sorting columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> (ImmutableList)((Collection)value).stream().map(String.class::cast).map(HiveTableProperties::sortingColumnFromString).collect(ImmutableList.toImmutableList()), value -> (ImmutableList)value.stream().map(SortingColumn.class::cast).map(HiveTableProperties::sortingColumnToString).collect(ImmutableList.toImmutableList())), (Object)new PropertyMetadata(ORC_BLOOM_FILTER_COLUMNS, "ORC Bloom filter index columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> (ImmutableList)((Collection)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.doubleProperty((String)ORC_BLOOM_FILTER_FPP, (String)"ORC Bloom filter false positive probability", (Double)config.getOrcDefaultBloomFilterFpp(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)BUCKET_COUNT_PROPERTY, (String)"Number of buckets", (Integer)0, (boolean)false), (Object)PropertyMetadata.stringProperty((String)AVRO_SCHEMA_URL, (String)"URI pointing to Avro schema for the table", null, (boolean)false));
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static String getExternalLocation(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(EXTERNAL_LOCATION_PROPERTY);
    }

    public static String getAvroSchemaUrl(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(AVRO_SCHEMA_URL);
    }

    public static HiveStorageFormat getHiveStorageFormat(Map<String, Object> tableProperties) {
        return (HiveStorageFormat)((Object)tableProperties.get(STORAGE_FORMAT_PROPERTY));
    }

    public static List<String> getPartitionedBy(Map<String, Object> tableProperties) {
        List partitionedBy = (List)tableProperties.get(PARTITIONED_BY_PROPERTY);
        return partitionedBy == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitionedBy);
    }

    public static Optional<HiveBucketProperty> getBucketProperty(Map<String, Object> tableProperties) {
        List<String> bucketedBy = HiveTableProperties.getBucketedBy(tableProperties);
        List<SortingColumn> sortedBy = HiveTableProperties.getSortedBy(tableProperties);
        int bucketCount = (Integer)tableProperties.get(BUCKET_COUNT_PROPERTY);
        if (bucketedBy.isEmpty() && bucketCount == 0) {
            if (!sortedBy.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s may be specified only when %s is specified", SORTED_BY_PROPERTY, BUCKETED_BY_PROPERTY));
            }
            return Optional.empty();
        }
        if (bucketCount < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be greater than zero", BUCKET_COUNT_PROPERTY));
        }
        if (bucketedBy.isEmpty() || bucketCount == 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s and %s must be specified together", BUCKETED_BY_PROPERTY, BUCKET_COUNT_PROPERTY));
        }
        return Optional.of(new HiveBucketProperty(bucketedBy, bucketCount, sortedBy));
    }

    private static List<String> getBucketedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(BUCKETED_BY_PROPERTY);
    }

    private static List<SortingColumn> getSortedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(SORTED_BY_PROPERTY);
    }

    public static List<String> getOrcBloomFilterColumns(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(ORC_BLOOM_FILTER_COLUMNS);
    }

    public static Double getOrcBloomFilterFpp(Map<String, Object> tableProperties) {
        return (Double)tableProperties.get(ORC_BLOOM_FILTER_FPP);
    }

    private static SortingColumn sortingColumnFromString(String name) {
        SortingColumn.Order order = SortingColumn.Order.ASCENDING;
        String lower = name.toUpperCase(Locale.ENGLISH);
        if (lower.endsWith(" ASC")) {
            name = name.substring(0, name.length() - 4).trim();
        } else if (lower.endsWith(" DESC")) {
            name = name.substring(0, name.length() - 5).trim();
            order = SortingColumn.Order.DESCENDING;
        }
        return new SortingColumn(name, order);
    }

    private static String sortingColumnToString(SortingColumn column) {
        return column.getColumnName() + (column.getOrder() == SortingColumn.Order.DESCENDING ? " DESC" : "");
    }
}

