/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveTypeTranslator
implements TypeTranslator {
    @Override
    public TypeInfo translate(Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return HiveType.HIVE_BOOLEAN.getTypeInfo();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return HiveType.HIVE_LONG.getTypeInfo();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return HiveType.HIVE_INT.getTypeInfo();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return HiveType.HIVE_SHORT.getTypeInfo();
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return HiveType.HIVE_BYTE.getTypeInfo();
        }
        if (RealType.REAL.equals((Object)type)) {
            return HiveType.HIVE_FLOAT.getTypeInfo();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return HiveType.HIVE_DOUBLE.getTypeInfo();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            int varcharLength = varcharType.getLength();
            if (varcharLength <= 65535) {
                return TypeInfoFactory.getVarcharTypeInfo((int)varcharLength);
            }
            if (varcharLength == Integer.MAX_VALUE) {
                return HiveType.HIVE_STRING.getTypeInfo();
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported VARCHAR types: VARCHAR(<=%d), VARCHAR.", type, 65535));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            int charLength = charType.getLength();
            if (charLength <= 255) {
                return TypeInfoFactory.getCharTypeInfo((int)charLength);
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported CHAR types: CHAR(<=%d).", type, 255));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return HiveType.HIVE_BINARY.getTypeInfo();
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveType.HIVE_DATE.getTypeInfo();
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return HiveType.HIVE_TIMESTAMP.getTypeInfo();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
        }
        if (HiveUtil.isArrayType(type)) {
            TypeInfo elementType = this.translate((Type)type.getTypeParameters().get(0));
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementType);
        }
        if (HiveUtil.isMapType(type)) {
            TypeInfo keyType = this.translate((Type)type.getTypeParameters().get(0));
            TypeInfo valueType = this.translate((Type)type.getTypeParameters().get(1));
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyType, (TypeInfo)valueType);
        }
        if (HiveUtil.isRowType(type)) {
            ImmutableList.Builder fieldNames = ImmutableList.builder();
            for (TypeSignatureParameter parameter : type.getTypeSignature().getParameters()) {
                if (!parameter.isNamedTypeSignature()) {
                    throw new IllegalArgumentException(String.format("Expected all parameters to be named type, but got %s", parameter));
                }
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                if (!namedTypeSignature.getName().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Anonymous row type is not supported in Hive. Please give each field a name: %s", type));
                }
                fieldNames.add(namedTypeSignature.getName().get());
            }
            return TypeInfoFactory.getStructTypeInfo((List)fieldNames.build(), type.getTypeParameters().stream().map(this::translate).collect(Collectors.toList()));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
    }
}

