/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.HiveWriter;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.RecordFileWriter;
import com.facebook.presto.hive.SortingFileWriterFactory;
import com.facebook.presto.hive.WriteCompletedEvent;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HivePageSinkMetadataProvider;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.event.client.EventClient;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;

public class HiveWriterFactory {
    private static final int MAX_BUCKET_COUNT = 100000;
    private static final int BUCKET_NUMBER_PADDING = Integer.toString(99999).length();
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final String schemaName;
    private final String tableName;
    private final List<DataColumn> dataColumns;
    private final List<String> partitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final HiveCompressionCodec compressionCodec;
    private final LocationHandle locationHandle;
    private final LocationService locationService;
    private final String filePrefix;
    private final HivePageSinkMetadataProvider pageSinkMetadataProvider;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final JobConf conf;
    private final Table table;
    private final Optional<SortingFileWriterFactory> sortingFileWriterFactory;
    private final boolean immutablePartitions;
    private final HiveSessionProperties.InsertExistingPartitionsBehavior insertExistingPartitionsBehavior;
    private final ConnectorSession session;
    private final OptionalInt bucketCount;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final Map<String, String> sessionProperties;
    private final HiveWriterStats hiveWriterStats;
    private final boolean partitionCommitRequired;

    public HiveWriterFactory(Set<HiveFileWriterFactory> fileWriterFactories, String schemaName, String tableName, boolean isCreateTable, List<HiveColumnHandle> inputColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, HiveCompressionCodec compressionCodec, OptionalInt bucketCount, List<SortingColumn> sortedBy, LocationHandle locationHandle, LocationService locationService, String filePrefix, HivePageSinkMetadataProvider pageSinkMetadataProvider, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, PageSorter pageSorter, DataSize sortBufferSize, int maxOpenSortFiles, boolean immutablePartitions, ConnectorSession session, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties, HiveWriterStats hiveWriterStats, OrcFileWriterFactory orcFileWriterFactory, boolean partitionCommitRequired) {
        Path writePath;
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.filePrefix = Objects.requireNonNull(filePrefix, "filePrefix is null");
        this.pageSinkMetadataProvider = Objects.requireNonNull(pageSinkMetadataProvider, "pageSinkMetadataProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.immutablePartitions = immutablePartitions;
        this.insertExistingPartitionsBehavior = HiveSessionProperties.getInsertExistingPartitionsBehavior(session);
        if (immutablePartitions) {
            Preconditions.checkArgument((this.insertExistingPartitionsBehavior != HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND ? 1 : 0) != 0, (Object)"insertExistingPartitionsBehavior cannot be APPEND");
        }
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        ImmutableList.Builder partitionColumnNames = ImmutableList.builder();
        ImmutableList.Builder partitionColumnTypes = ImmutableList.builder();
        ImmutableList.Builder dataColumns = ImmutableList.builder();
        for (HiveColumnHandle column2 : inputColumns) {
            HiveType hiveType = column2.getHiveType();
            if (column2.isPartitionKey()) {
                partitionColumnNames.add((Object)column2.getName());
                partitionColumnTypes.add((Object)typeManager.getType(column2.getTypeSignature()));
                continue;
            }
            dataColumns.add((Object)new DataColumn(column2.getName(), hiveType));
        }
        this.partitionColumnNames = partitionColumnNames.build();
        this.partitionColumnTypes = partitionColumnTypes.build();
        this.dataColumns = dataColumns.build();
        if (isCreateTable) {
            this.table = null;
            LocationService.WriteInfo writeInfo = locationService.getQueryWriteInfo(locationHandle);
            Preconditions.checkArgument((writeInfo.getWriteMode() != LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY ? 1 : 0) != 0, (Object)"CREATE TABLE write mode cannot be DIRECT_TO_TARGET_EXISTING_DIRECTORY");
            writePath = writeInfo.getWritePath();
        } else {
            Optional<Table> table = pageSinkMetadataProvider.getTable();
            if (!table.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table %s.%s was dropped during insert", schemaName, tableName));
            }
            this.table = table.get();
            writePath = locationService.getQueryWriteInfo(locationHandle).getWritePath();
        }
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        if (bucketCount.isPresent()) {
            Preconditions.checkArgument((bucketCount.getAsInt() < 100000 ? 1 : 0) != 0, (Object)"bucketCount must be smaller than 100000");
        }
        this.session = Objects.requireNonNull(session, "session is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
        this.sessionProperties = (Map)hiveSessionProperties.getSessionProperties().stream().collect(ImmutableMap.toImmutableMap(PropertyMetadata::getName, entry -> session.getProperty(entry.getName(), entry.getJavaType()).toString()));
        this.conf = ConfigurationUtils.configureCompression(hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, schemaName, tableName), writePath), compressionCodec);
        if (!sortedBy.isEmpty()) {
            List types = (List)this.dataColumns.stream().map(column -> column.getHiveType().getType(typeManager)).collect(ImmutableList.toImmutableList());
            HashMap<String, Integer> columnIndexes = new HashMap<String, Integer>();
            for (int i = 0; i < this.dataColumns.size(); ++i) {
                columnIndexes.put(this.dataColumns.get(i).getName(), i);
            }
            ArrayList<Integer> sortFields = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (SortingColumn column3 : sortedBy) {
                Integer index = (Integer)columnIndexes.get(column3.getColumnName());
                if (index == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Sorting column '%s' does exist in table '%s.%s'", column3.getColumnName(), schemaName, tableName));
                }
                sortFields.add(index);
                sortOrders.add(column3.getOrder().getSortOrder());
            }
            this.sortingFileWriterFactory = Optional.of(new SortingFileWriterFactory(hdfsEnvironment, session, this.conf, types, sortFields, sortOrders, sortBufferSize, maxOpenSortFiles, pageSorter, orcFileWriterFactory, HiveSessionProperties.isSortedWriteToTempPathEnabled(session), HiveSessionProperties.getSortedWriteTempPathSubdirectoryCount(session)));
        } else {
            this.sortingFileWriterFactory = Optional.empty();
        }
        try {
            hdfsEnvironment.getFileSystem(session.getUser(), writePath, (Configuration)this.conf);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + writePath, (Throwable)e);
        }
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
        this.partitionCommitRequired = partitionCommitRequired;
    }

    public HiveWriter createWriter(Page partitionColumns, int position, OptionalInt bucketNumber) {
        StorageFormat outputStorageFormat;
        LocationService.WriteInfo writeInfo;
        Properties schema;
        PartitionUpdate.UpdateMode updateMode;
        if (this.bucketCount.isPresent()) {
            Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"Bucket not provided for bucketed table");
            Preconditions.checkArgument((bucketNumber.getAsInt() < this.bucketCount.getAsInt() ? 1 : 0) != 0, (String)"Bucket number %s must be less than bucket count %s", (Object)bucketNumber, (Object)this.bucketCount);
        } else {
            Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0, (Object)"Bucket number provided by for table that is not bucketed");
        }
        List<String> partitionValues = HiveWriteUtils.createPartitionValues(this.partitionColumnTypes, partitionColumns, position);
        Optional<Object> partitionName = !this.partitionColumnNames.isEmpty() ? Optional.of(FileUtils.makePartName(this.partitionColumnNames, partitionValues)) : Optional.empty();
        Optional<Partition> partition = Optional.empty();
        if (!partitionValues.isEmpty() && this.table != null) {
            partition = this.pageSinkMetadataProvider.getPartition(partitionValues);
        }
        if (!partition.isPresent()) {
            if (this.table == null) {
                updateMode = PartitionUpdate.UpdateMode.NEW;
                schema = new Properties();
                schema.setProperty("columns", this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.joining(",")));
                schema.setProperty("columns.types", this.dataColumns.stream().map(DataColumn::getHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
                if (!partitionName.isPresent()) {
                    writeInfo = this.locationService.getTableWriteInfo(this.locationHandle);
                } else {
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                    if (!writeInfo.getWriteMode().isWritePathSameAsTargetPath() && HiveWriteUtils.pathExists(new HdfsEnvironment.HdfsContext(this.session, this.schemaName, this.tableName), this.hdfsEnvironment, writeInfo.getTargetPath())) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for new partition '%s' of table '%s.%s' already exists: %s", partitionName, this.schemaName, this.tableName, writeInfo.getTargetPath()));
                    }
                }
            } else {
                if (partitionName.isPresent()) {
                    updateMode = PartitionUpdate.UpdateMode.NEW;
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                } else if (this.table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE)) {
                    updateMode = PartitionUpdate.UpdateMode.APPEND;
                    writeInfo = this.locationService.getTableWriteInfo(this.locationHandle);
                } else {
                    if (bucketNumber.isPresent()) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into bucketed unpartitioned Hive table");
                    }
                    if (this.immutablePartitions) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Unpartitioned Hive tables are immutable");
                    }
                    updateMode = PartitionUpdate.UpdateMode.APPEND;
                    writeInfo = this.locationService.getTableWriteInfo(this.locationHandle);
                }
                schema = MetastoreUtil.getHiveSchema(this.table);
            }
            outputStorageFormat = partitionName.isPresent() ? StorageFormat.fromHiveStorageFormat(this.partitionStorageFormat) : StorageFormat.fromHiveStorageFormat(this.tableStorageFormat);
        } else if (this.insertExistingPartitionsBehavior == HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND) {
            Preconditions.checkState((!this.immutablePartitions ? 1 : 0) != 0);
            if (bucketNumber.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into existing partition of bucketed Hive table: " + (String)partitionName.get());
            }
            updateMode = PartitionUpdate.UpdateMode.APPEND;
            List<Column> tableColumns = this.table.getDataColumns();
            List<Column> existingPartitionColumns = partition.get().getColumns();
            for (int i = 0; i < Math.min(existingPartitionColumns.size(), tableColumns.size()); ++i) {
                HiveType partitionType;
                HiveType tableType = tableColumns.get(i).getType();
                if (tableType.equals(partitionType = existingPartitionColumns.get(i).getType())) continue;
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("You are trying to write into an existing partition in a table. The table schema has changed since the creation of the partition. Inserting rows into such partition is not supported. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumns.get(i).getName(), this.tableName, tableType, partitionName, existingPartitionColumns.get(i).getName(), partitionType));
            }
            HiveWriteUtils.checkPartitionIsWritable((String)partitionName.get(), partition.get());
            outputStorageFormat = partition.get().getStorage().getStorageFormat();
            schema = MetastoreUtil.getHiveSchema(partition.get(), this.table);
            writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
        } else if (this.insertExistingPartitionsBehavior == HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE) {
            updateMode = PartitionUpdate.UpdateMode.OVERWRITE;
            outputStorageFormat = StorageFormat.fromHiveStorageFormat(this.partitionStorageFormat);
            schema = MetastoreUtil.getHiveSchema(this.table);
            writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, Optional.empty(), (String)partitionName.get());
            Preconditions.checkState((writeInfo.getWriteMode() != LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY ? 1 : 0) != 0, (Object)"Overwriting existing partition doesn't support DIRECT_TO_TARGET_EXISTING_DIRECTORY write mode");
        } else {
            if (this.insertExistingPartitionsBehavior == HiveSessionProperties.InsertExistingPartitionsBehavior.ERROR) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into an existing partition of Hive table: " + (String)partitionName.get());
            }
            throw new IllegalArgumentException(String.format("Unsupported insert existing partitions behavior: %s", new Object[]{this.insertExistingPartitionsBehavior}));
        }
        this.validateSchema(partitionName, schema);
        String extension = HiveWriterFactory.getFileExtension(outputStorageFormat, this.compressionCodec);
        String targetFileName = bucketNumber.isPresent() ? HiveWriterFactory.computeBucketedFileName(this.filePrefix, bucketNumber.getAsInt()) + extension : this.filePrefix + "_" + UUID.randomUUID() + extension;
        String writeFileName = this.partitionCommitRequired ? ".tmp.presto." + this.filePrefix + "_" + UUID.randomUUID() + extension : targetFileName;
        Path path = new Path(writeInfo.getWritePath(), writeFileName);
        Object hiveFileWriter = null;
        for (HiveFileWriterFactory fileWriterFactory : this.fileWriterFactories) {
            Optional<HiveFileWriter> fileWriter = fileWriterFactory.createFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, this.conf, this.session);
            if (!fileWriter.isPresent()) continue;
            hiveFileWriter = fileWriter.get();
            break;
        }
        if (hiveFileWriter == null) {
            hiveFileWriter = new RecordFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, this.partitionStorageFormat.getEstimatedWriterSystemMemoryUsage(), this.conf, this.typeManager, this.session);
        }
        String writerImplementation = hiveFileWriter.getClass().getName();
        Consumer<HiveWriter> onCommit = hiveWriter -> {
            Optional<Object> size;
            try {
                size = Optional.of(this.hdfsEnvironment.getFileSystem(this.session.getUser(), path, (Configuration)this.conf).getFileStatus(path).getLen());
            }
            catch (IOException | RuntimeException e) {
                size = Optional.empty();
            }
            this.eventClient.post((Object[])new WriteCompletedEvent[]{new WriteCompletedEvent(this.session.getQueryId(), path.toString(), this.schemaName, this.tableName, partitionName.orElse(null), outputStorageFormat.getOutputFormat(), writerImplementation, this.nodeManager.getCurrentNode().getVersion(), this.nodeManager.getCurrentNode().getHost(), this.session.getIdentity().getPrincipal().map(Principal::getName).orElse(null), this.nodeManager.getEnvironment(), this.sessionProperties, size.orElse(null), hiveWriter.getRowCount())});
        };
        if (this.sortingFileWriterFactory.isPresent()) {
            Preconditions.checkState((boolean)bucketNumber.isPresent(), (Object)"missing bucket number for sorted table write");
            hiveFileWriter = this.sortingFileWriterFactory.get().createSortingFileWriter(path, (HiveFileWriter)hiveFileWriter, bucketNumber.getAsInt(), writeInfo.getTempPath());
        }
        return new HiveWriter((HiveFileWriter)hiveFileWriter, partitionName, updateMode, new PartitionUpdate.FileWriteInfo(writeFileName, targetFileName), writeInfo.getWritePath().toString(), writeInfo.getTargetPath().toString(), onCommit, this.hiveWriterStats);
    }

    private void validateSchema(Optional<String> partitionName, Properties schema) {
        List fileColumnNames = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)schema.getProperty("columns", ""));
        List<HiveType> fileColumnHiveTypes = HiveType.toHiveTypes(schema.getProperty("columns.types", ""));
        Map inputColumnMap = this.dataColumns.stream().collect(Collectors.toMap(DataColumn::getName, Function.identity()));
        Sets.SetView missingColumns = Sets.difference(inputColumnMap.keySet(), new HashSet(fileColumnNames));
        if (!missingColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table %s.%s does not have columns %s", schema, this.tableName, missingColumns));
        }
        if (fileColumnNames.size() != fileColumnHiveTypes.size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Partition '%s' in table '%s.%s' has mismatched metadata for column names and types", partitionName, this.schemaName, this.tableName));
        }
        for (int fileIndex = 0; fileIndex < fileColumnNames.size(); ++fileIndex) {
            HiveType inputHiveType;
            String columnName = (String)fileColumnNames.get(fileIndex);
            HiveType fileColumnHiveType = fileColumnHiveTypes.get(fileIndex);
            if (fileColumnHiveType.equals(inputHiveType = ((DataColumn)inputColumnMap.get(columnName)).getHiveType())) continue;
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s.%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", columnName, this.schemaName, this.tableName, inputHiveType, partitionName, columnName, fileColumnHiveType));
        }
    }

    public static String computeBucketedFileName(String filePrefix, int bucket) {
        return filePrefix + "_bucket-" + Strings.padStart((String)Integer.toString(bucket), (int)BUCKET_NUMBER_PADDING, (char)'0');
    }

    public static String getFileExtension(StorageFormat storageFormat, HiveCompressionCodec compressionCodec) {
        if (compressionCodec == HiveCompressionCodec.NONE || !HiveIgnoreKeyTextOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return "";
        }
        if (!compressionCodec.getCodec().isPresent()) {
            return new DefaultCodec().getDefaultExtension();
        }
        try {
            return compressionCodec.getCodec().get().getConstructor(new Class[0]).newInstance(new Object[0]).getDefaultExtension();
        }
        catch (ReflectiveOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Failed to load compression codec: " + compressionCodec.getCodec().get(), (Throwable)e);
        }
    }

    private static class DataColumn {
        private final String name;
        private final HiveType hiveType;

        public DataColumn(String name, HiveType hiveType) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        }

        public String getName() {
            return this.name;
        }

        public HiveType getHiveType() {
            return this.hiveType;
        }
    }
}

