/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ForZeroRowFileCreator;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.ZeroRowFileCreator;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.mapred.JobConf;

public class HiveZeroRowFileCreator
implements ZeroRowFileCreator {
    private final HdfsEnvironment hdfsEnvironment;
    private final ListeningExecutorService executor;

    @Inject
    public HiveZeroRowFileCreator(HdfsEnvironment hdfsEnvironment, @ForZeroRowFileCreator ListeningExecutorService zeroRowFileCreatorExecutor) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.executor = Objects.requireNonNull(zeroRowFileCreatorExecutor, "zeroRowFileCreatorExecutor is null");
    }

    @Override
    public void createFiles(ConnectorSession session, HdfsEnvironment.HdfsContext hdfsContext, Path destinationDirectory, List<String> fileNames, StorageFormat format, HiveCompressionCodec compressionCodec, Properties schema) {
        JobConf conf = ConfigurationUtils.configureCompression(this.hdfsEnvironment.getConfiguration(hdfsContext, destinationDirectory), compressionCodec);
        ArrayList<ListenableFuture> commitFutures = new ArrayList<ListenableFuture>();
        for (String fileName : fileNames) {
            commitFutures.add(this.executor.submit(() -> HiveZeroRowFileCreator.writeZeroRowFile(session, new Path(destinationDirectory, fileName), conf, schema, format.getSerDe(), format.getOutputFormat())));
        }
        ListenableFuture listenableFutureAggregate = Futures.whenAllSucceed(commitFutures).call(() -> null, MoreExecutors.directExecutor());
        try {
            MoreFutures.getFutureValue((Future)listenableFutureAggregate, PrestoException.class);
        }
        catch (RuntimeException e) {
            listenableFutureAggregate.cancel(true);
            throw e;
        }
    }

    private static void writeZeroRowFile(ConnectorSession session, Path target, JobConf conf, Properties properties, String serDe, String outputFormatName) {
        HiveWriteUtils.initializeSerializer((Configuration)conf, properties, serDe);
        FileSinkOperator.RecordWriter recordWriter = HiveWriteUtils.createRecordWriter(target, conf, properties, outputFormatName, session);
        try {
            recordWriter.close(false);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error write zero-row file to Hive", (Throwable)e);
        }
    }
}

