/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.RetryDriver;
import com.facebook.presto.hive.s3.HiveS3Config;
import com.facebook.presto.hive.s3.PrestoS3ClientFactory;
import com.facebook.presto.hive.s3.PrestoS3SelectClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.io.Closer;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.LineReader;

@ThreadSafe
public abstract class S3SelectLineRecordReader
implements RecordReader<LongWritable, Text> {
    private InputStream selectObjectContent;
    private long processedRecords;
    private long recordsFromS3;
    private long position;
    private LineReader reader;
    private boolean isFirstLine;
    private static final Duration BACKOFF_MIN_SLEEP = new Duration(1.0, TimeUnit.SECONDS);
    private final PrestoS3SelectClient selectClient;
    private final long start;
    private final long end;
    private final int maxAttempts;
    private final Duration maxBackoffTime;
    private final Duration maxRetryTime;
    private final Closer closer = Closer.create();
    private final SelectObjectContentRequest selectObjectContentRequest;
    protected final CompressionCodecFactory compressionCodecFactory;
    protected final String lineDelimiter;

    S3SelectLineRecordReader(Configuration configuration, HiveClientConfig clientConfig, Path path, long start, long length, Properties schema, String ionSqlQuery, PrestoS3ClientFactory s3ClientFactory) {
        Objects.requireNonNull(configuration, "configuration is null");
        Objects.requireNonNull(clientConfig, "clientConfig is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(ionSqlQuery, "ionSqlQuery is null");
        Objects.requireNonNull(s3ClientFactory, "s3ClientFactory is null");
        this.lineDelimiter = schema.getProperty("line.delim", "\n");
        this.processedRecords = 0L;
        this.recordsFromS3 = 0L;
        this.position = this.start = start;
        this.end = this.start + length;
        this.isFirstLine = true;
        this.compressionCodecFactory = new CompressionCodecFactory(configuration);
        this.selectObjectContentRequest = this.buildSelectObjectRequest(schema, ionSqlQuery, path);
        HiveS3Config defaults = new HiveS3Config();
        this.maxAttempts = configuration.getInt("presto.s3.max-client-retries", defaults.getS3MaxClientRetries()) + 1;
        this.maxBackoffTime = Duration.valueOf((String)configuration.get("presto.s3.max-backoff-time", defaults.getS3MaxBackoffTime().toString()));
        this.maxRetryTime = Duration.valueOf((String)configuration.get("presto.s3.max-retry-time", defaults.getS3MaxRetryTime().toString()));
        this.selectClient = new PrestoS3SelectClient(configuration, clientConfig, s3ClientFactory);
        this.closer.register((Closeable)this.selectClient);
    }

    public abstract SelectObjectContentRequest buildSelectObjectRequest(Properties var1, String var2, Path var3);

    private int readLine(Text value) throws IOException {
        try {
            return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).run("readRecordsContentStream", () -> {
                if (this.isFirstLine) {
                    this.recordsFromS3 = 0L;
                    this.selectObjectContent = this.selectClient.getRecordsContent(this.selectObjectContentRequest);
                    this.closer.register((Closeable)this.selectObjectContent);
                    this.reader = new LineReader(this.selectObjectContent, this.lineDelimiter.getBytes(StandardCharsets.UTF_8));
                    this.closer.register((Closeable)this.reader);
                    this.isFirstLine = false;
                }
                try {
                    return this.reader.readLine(value);
                }
                catch (RuntimeException e) {
                    this.isFirstLine = true;
                    this.recordsFromS3 = 0L;
                    if (e instanceof AmazonS3Exception) {
                        switch (((AmazonS3Exception)e).getStatusCode()) {
                            case 400: 
                            case 403: 
                            case 404: {
                                throw new UnrecoverableS3OperationException(this.selectClient.getBucketName(), this.selectClient.getKeyName(), e);
                            }
                        }
                    }
                    throw e;
                }
            });
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public synchronized boolean next(LongWritable key, Text value) throws IOException {
        int bytes;
        do {
            if ((bytes = this.readLine(value)) <= 0) {
                if (!this.selectClient.isRequestComplete()) {
                    throw new IOException("S3 Select request was incomplete as End Event was not received");
                }
                return false;
            }
            ++this.recordsFromS3;
        } while (this.recordsFromS3 <= this.processedRecords);
        this.position += (long)bytes;
        ++this.processedRecords;
        key.set(this.processedRecords);
        return true;
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public Text createValue() {
        return new Text();
    }

    public long getPos() {
        return this.position;
    }

    public void close() throws IOException {
        this.closer.close();
    }

    public float getProgress() {
        return (float)(this.position - this.start) / (float)(this.end - this.start);
    }

    String getFieldDelimiter(Properties schema) {
        return schema.getProperty("field.delim", schema.getProperty("serialization.format"));
    }

    @VisibleForTesting
    static class UnrecoverableS3OperationException
    extends RuntimeException {
        public UnrecoverableS3OperationException(String bucket, String key, Throwable cause) {
            super(String.format("%s (Bucket: %s, Key: %s)", cause, bucket, key));
        }
    }
}

