/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.Varchars;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SubfieldExtractor {
    private final StandardFunctionResolution functionResolution;
    private final ExpressionOptimizer expressionOptimizer;
    private final ConnectorSession connectorSession;

    public SubfieldExtractor(StandardFunctionResolution functionResolution, ExpressionOptimizer expressionOptimizer, ConnectorSession connectorSession) {
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.expressionOptimizer = Objects.requireNonNull(expressionOptimizer, "expressionOptimzier is null");
        this.connectorSession = Objects.requireNonNull(connectorSession, "connectorSession is null");
    }

    public DomainTranslator.ColumnExtractor<Subfield> toColumnExtractor() {
        return (expression, domain) -> {
            Type type = expression.getType();
            if ((type instanceof ArrayType || type instanceof MapType || type instanceof RowType) && !domain.isOnlyNull() && (!domain.getValues().isAll() || domain.isNullAllowed())) {
                return Optional.empty();
            }
            return this.extract(expression);
        };
    }

    public Optional<Subfield> extract(RowExpression expression) {
        return SubfieldExtractor.toSubfield(expression, this.functionResolution, this.expressionOptimizer, this.connectorSession);
    }

    private static Optional<Subfield> toSubfield(RowExpression expression, StandardFunctionResolution functionResolution, ExpressionOptimizer expressionOptimizer, ConnectorSession connectorSession) {
        block5: {
            ArrayList<Object> elements = new ArrayList<Object>();
            while (true) {
                if (expression instanceof VariableReferenceExpression) {
                    Collections.reverse(elements);
                    return Optional.of(new Subfield(((VariableReferenceExpression)expression).getName(), Collections.unmodifiableList(elements)));
                }
                if (expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm() == SpecialFormExpression.Form.DEREFERENCE) {
                    Optional fieldName;
                    Object index;
                    SpecialFormExpression dereferenceExpression = (SpecialFormExpression)expression;
                    RowExpression base = (RowExpression)dereferenceExpression.getArguments().get(0);
                    RowType baseType = (RowType)base.getType();
                    RowExpression indexExpression = expressionOptimizer.optimize((RowExpression)dereferenceExpression.getArguments().get(1), ExpressionOptimizer.Level.OPTIMIZED, connectorSession);
                    if (indexExpression instanceof ConstantExpression && (index = ((ConstantExpression)indexExpression).getValue()) instanceof Number && (fieldName = ((RowType.Field)baseType.getFields().get(((Number)index).intValue())).getName()).isPresent()) {
                        elements.add(new Subfield.NestedField((String)fieldName.get()));
                        expression = base;
                        continue;
                    }
                    return Optional.empty();
                }
                if (!(expression instanceof CallExpression) || !functionResolution.isSubscriptFunction(((CallExpression)expression).getFunctionHandle())) break block5;
                List arguments = ((CallExpression)expression).getArguments();
                RowExpression indexExpression = expressionOptimizer.optimize((RowExpression)arguments.get(1), ExpressionOptimizer.Level.OPTIMIZED, connectorSession);
                if (!(indexExpression instanceof ConstantExpression)) break;
                Object index = ((ConstantExpression)indexExpression).getValue();
                if (index instanceof Number) {
                    elements.add(new Subfield.LongSubscript(((Number)index).longValue()));
                    expression = (RowExpression)arguments.get(0);
                    continue;
                }
                if (!Varchars.isVarcharType((Type)indexExpression.getType())) break;
                elements.add(new Subfield.StringSubscript(((Slice)index).toStringUtf8()));
                expression = (RowExpression)arguments.get(0);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

