/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveSelectivePageSourceFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.orc.OrcSelectivePageSource;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.FilterFunction;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.TupleDomainFilterUtils;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.Predicate;
import com.facebook.presto.spi.relation.PredicateCompiler;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.units.DataSize;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.joda.time.DateTimeZone;

public class OrcSelectivePageSourceFactory
implements HiveSelectivePageSourceFactory {
    private final TypeManager typeManager;
    private final StandardFunctionResolution functionResolution;
    private final RowExpressionService rowExpressionService;
    private final boolean useOrcColumnNames;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final int domainCompactionThreshold;

    @Inject
    public OrcSelectivePageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, HiveClientConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats) {
        this(typeManager, functionResolution, rowExpressionService, Objects.requireNonNull(config, "hiveClientConfig is null").isUseOrcColumnNames(), hdfsEnvironment, stats, config.getDomainCompactionThreshold());
    }

    public OrcSelectivePageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, boolean useOrcColumnNames, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, int domainCompactionThreshold) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.useOrcColumnNames = useOrcColumnNames;
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.domainCompactionThreshold = domainCompactionThreshold;
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Storage storage, List<HiveColumnHandle> columns, Map<Integer, String> prefilledValues, List<Integer> outputColumns, TupleDomain<Subfield> domainPredicate, RowExpression remainingPredicate, DateTimeZone hiveStorageTimeZone) {
        if (!OrcSerde.class.getName().equals(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        if (fileSize == 0L) {
            return Optional.of(new FixedPageSource((Iterable)ImmutableList.of()));
        }
        return Optional.of(OrcSelectivePageSourceFactory.createOrcPageSource(session, OrcEncoding.ORC, this.hdfsEnvironment, configuration, path, start, length, fileSize, columns, prefilledValues, outputColumns, domainPredicate, remainingPredicate, this.useOrcColumnNames, hiveStorageTimeZone, this.typeManager, this.functionResolution, this.rowExpressionService, HiveSessionProperties.isOrcBloomFiltersEnabled(session), this.stats, this.domainCompactionThreshold));
    }

    public static OrcSelectivePageSource createOrcPageSource(ConnectorSession session, OrcEncoding orcEncoding, HdfsEnvironment hdfsEnvironment, Configuration configuration, Path path, long start, long length, long fileSize, List<HiveColumnHandle> columns, Map<Integer, String> prefilledValues, List<Integer> outputColumns, TupleDomain<Subfield> domainPredicate, RowExpression remainingPredicate, boolean useOrcColumnNames, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, boolean orcBloomFiltersEnabled, FileFormatDataSourceStats stats, int domainCompactionThreshold) {
        HdfsOrcDataSource orcDataSource;
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        DataSize maxMergeDistance = HiveSessionProperties.getOrcMaxMergeDistance(session);
        DataSize maxBufferSize = HiveSessionProperties.getOrcMaxBufferSize(session);
        DataSize streamBufferSize = HiveSessionProperties.getOrcStreamBufferSize(session);
        DataSize tinyStripeThreshold = HiveSessionProperties.getOrcTinyStripeThreshold(session);
        DataSize maxReadBlockSize = HiveSessionProperties.getOrcMaxReadBlockSize(session);
        boolean lazyReadSmallRanges = HiveSessionProperties.getOrcLazyReadSmallRanges(session);
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(session.getUser(), path, configuration);
            FSDataInputStream inputStream = fileSystem.open(path);
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, maxMergeDistance, maxBufferSize, streamBufferSize, lazyReadSmallRanges, inputStream, stats);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, OrcSelectivePageSourceFactory.splitError(e, path, start, length), (Throwable)e);
        }
        AggregatedMemoryContext systemMemoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        try {
            OrcReader reader = new OrcReader((OrcDataSource)orcDataSource, orcEncoding, maxMergeDistance, tinyStripeThreshold, maxReadBlockSize);
            Preconditions.checkArgument((!domainPredicate.isNone() ? 1 : 0) != 0, (Object)"Unexpected NONE domain");
            List<HiveColumnHandle> physicalColumns = HiveUtil.getPhysicalHiveColumnHandles(columns, useOrcColumnNames, reader, path);
            Map indexMapping = (Map)IntStream.range(0, columns.size()).boxed().collect(ImmutableMap.toImmutableMap(i -> ((HiveColumnHandle)columns.get((int)i)).getHiveColumnIndex(), i -> ((HiveColumnHandle)physicalColumns.get((int)i)).getHiveColumnIndex()));
            Map columnNames = (Map)physicalColumns.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getHiveColumnIndex, HiveColumnHandle::getName));
            OrcPredicate orcPredicate = OrcSelectivePageSourceFactory.toOrcPredicate(domainPredicate, physicalColumns, typeManager, domainCompactionThreshold, orcBloomFiltersEnabled);
            ImmutableBiMap columnIndices = ImmutableBiMap.copyOf((Map)columnNames).inverse();
            Map<Integer, Map<Subfield, TupleDomainFilter>> tupleDomainFilters = OrcSelectivePageSourceFactory.toTupleDomainFilters(domainPredicate, (Map<String, Integer>)columnIndices);
            List outputIndices = (List)outputColumns.stream().map(indexMapping::get).collect(ImmutableList.toImmutableList());
            Map<Integer, List<Subfield>> requiredSubfields = OrcSelectivePageSourceFactory.collectRequiredSubfields(physicalColumns, outputIndices, tupleDomainFilters, remainingPredicate, (Map<String, Integer>)columnIndices, functionResolution, rowExpressionService, session);
            Map columnTypes = (Map)physicalColumns.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getHiveColumnIndex, column -> typeManager.getType(column.getTypeSignature())));
            Map typedPrefilledValues = Maps.transformEntries((Map)((Map)prefilledValues.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (Integer)indexMapping.get(entry.getKey()), Map.Entry::getValue))), (hiveColumnIndex, value) -> HiveUtil.typedPartitionKey(value, (Type)columnTypes.get(hiveColumnIndex), (String)columnNames.get(hiveColumnIndex), hiveStorageTimeZone));
            BiMap inputs = (BiMap)IntStream.range(0, physicalColumns.size()).boxed().collect(ImmutableBiMap.toImmutableBiMap(i -> ((HiveColumnHandle)physicalColumns.get((int)i)).getHiveColumnIndex(), Function.identity()));
            Map variableToInput = (Map)columnNames.keySet().stream().collect(ImmutableMap.toImmutableMap(hiveColumnIndex -> new VariableReferenceExpression((String)columnNames.get(hiveColumnIndex), (Type)columnTypes.get(hiveColumnIndex)), hiveColumnIndex -> new InputReferenceExpression(((Integer)inputs.get(hiveColumnIndex)).intValue(), (Type)columnTypes.get(hiveColumnIndex))));
            List<FilterFunction> filterFunctions = OrcSelectivePageSourceFactory.toFilterFunctions(RowExpressionNodeInliner.replaceExpression((RowExpression)remainingPredicate, (Map)variableToInput), session, rowExpressionService.getDeterminismEvaluator(), rowExpressionService.getPredicateCompiler());
            OrcSelectiveRecordReader recordReader = reader.createSelectiveRecordReader(columnTypes, outputIndices, tupleDomainFilters, filterFunctions, (Map)inputs.inverse(), requiredSubfields, typedPrefilledValues, orcPredicate, start, length, hiveStorageTimeZone, systemMemoryUsage, Optional.empty(), 1);
            return new OrcSelectivePageSource(recordReader, (OrcDataSource)orcDataSource, systemMemoryUsage.newAggregatedMemoryContext(), stats);
        }
        catch (Exception e) {
            try {
                orcDataSource.close();
            }
            catch (IOException physicalColumns) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)((Object)e);
            }
            String message = OrcSelectivePageSourceFactory.splitError(e, path, start, length);
            if (e.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static Map<Integer, List<Subfield>> collectRequiredSubfields(List<HiveColumnHandle> physicalColumns, List<Integer> outputColumns, Map<Integer, Map<Subfield, TupleDomainFilter>> tupleDomainFilters, RowExpression remainingPredicate, Map<String, Integer> columnIndices, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, ConnectorSession session) {
        int index;
        HashMap<Integer, Set<Subfield>> requiredSubfields = new HashMap<Integer, Set<Subfield>>();
        physicalColumns.stream().filter(column -> outputColumns.contains(column.getHiveColumnIndex())).forEach(column -> {
            Set cfr_ignored_0 = requiredSubfields.put(column.getHiveColumnIndex(), new HashSet<Subfield>(column.getRequiredSubfields()));
        });
        for (int index2 : outputColumns) {
            requiredSubfields.computeIfAbsent(index2, v -> new HashSet());
        }
        ImmutableSet.Builder predicateSubfields = ImmutableSet.builder();
        remainingPredicate.accept((RowExpressionVisitor)new RequiredSubfieldsExtractor(new SubfieldExtractor(functionResolution, rowExpressionService.getExpressionOptimizer(), session)), (Object)predicateSubfields);
        for (Subfield subfield : predicateSubfields.build()) {
            index = columnIndices.get(subfield.getRootName());
            OrcSelectivePageSourceFactory.updateRequiredSubfields(requiredSubfields, index, subfield);
        }
        for (Map.Entry entry2 : tupleDomainFilters.entrySet()) {
            index = (Integer)entry2.getKey();
            for (Subfield subfield : ((Map)entry2.getValue()).keySet()) {
                OrcSelectivePageSourceFactory.updateRequiredSubfields(requiredSubfields, index, subfield);
            }
        }
        return (Map)requiredSubfields.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableList.copyOf((Collection)((Collection)entry.getValue()))));
    }

    private static void updateRequiredSubfields(Map<Integer, Set<Subfield>> requiredSubfields, int index, Subfield subfield) {
        if (OrcSelectivePageSourceFactory.isEntireColumn(subfield)) {
            if (requiredSubfields.containsKey(index)) {
                requiredSubfields.get(index).clear();
            }
            return;
        }
        if (requiredSubfields.containsKey(index)) {
            if (!requiredSubfields.get(index).isEmpty()) {
                requiredSubfields.get(index).add(subfield);
            }
            return;
        }
        requiredSubfields.computeIfAbsent(index, v -> new HashSet()).add(subfield);
    }

    private static boolean isEntireColumn(Optional<Subfield> subfield) {
        return subfield.get().getPath().isEmpty();
    }

    private static Map<Integer, Map<Subfield, TupleDomainFilter>> toTupleDomainFilters(TupleDomain<Subfield> domainPredicate, Map<String, Integer> columnIndices) {
        Map filtersBySubfield = Maps.transformValues((Map)((Map)domainPredicate.getDomains().get()), TupleDomainFilterUtils::toFilter);
        HashMap<Integer, Map> filtersByColumn = new HashMap<Integer, Map>();
        for (Map.Entry entry : filtersBySubfield.entrySet()) {
            int columnIndex = columnIndices.get(((Subfield)entry.getKey()).getRootName());
            filtersByColumn.computeIfAbsent(columnIndex, k -> new HashMap()).put(entry.getKey(), entry.getValue());
        }
        return ImmutableMap.copyOf(filtersByColumn);
    }

    private static boolean isEntireColumn(Subfield subfield) {
        return subfield.getPath().isEmpty();
    }

    private static OrcPredicate toOrcPredicate(TupleDomain<Subfield> domainPredicate, List<HiveColumnHandle> physicalColumns, TypeManager typeManager, int domainCompactionThreshold, boolean orcBloomFiltersEnabled) {
        ImmutableList.Builder columnReferences = ImmutableList.builder();
        for (HiveColumnHandle column : physicalColumns) {
            if (column.getColumnType() != HiveColumnHandle.ColumnType.REGULAR) continue;
            Type type = typeManager.getType(column.getTypeSignature());
            columnReferences.add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)column, column.getHiveColumnIndex(), type));
        }
        ImmutableMap columnsByName = Maps.uniqueIndex(physicalColumns, HiveColumnHandle::getName);
        TupleDomain entireColumnDomains = domainPredicate.transform(arg_0 -> OrcSelectivePageSourceFactory.lambda$toOrcPredicate$14((Map)columnsByName, arg_0));
        return new TupleDomainOrcPredicate(entireColumnDomains, (List)columnReferences.build(), orcBloomFiltersEnabled, Optional.of(domainCompactionThreshold));
    }

    private static List<FilterFunction> toFilterFunctions(RowExpression filter, ConnectorSession session, DeterminismEvaluator determinismEvaluator, PredicateCompiler predicateCompiler) {
        if (LogicalRowExpressions.TRUE_CONSTANT.equals((Object)filter)) {
            return ImmutableList.of();
        }
        List conjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)filter);
        if (conjuncts.size() == 1) {
            return ImmutableList.of((Object)new FilterFunction(session, determinismEvaluator.isDeterministic(filter), (Predicate)predicateCompiler.compilePredicate(filter).get()));
        }
        LinkedHashMap<Set, List> inputsToConjuncts = new LinkedHashMap<Set, List>();
        for (RowExpression conjunct : conjuncts) {
            inputsToConjuncts.computeIfAbsent(OrcSelectivePageSourceFactory.extractInputs(conjunct), k -> new ArrayList()).add(conjunct);
        }
        return (List)inputsToConjuncts.values().stream().map(expressions -> LogicalRowExpressions.binaryExpression((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Collection)expressions)).map(predicate -> new FilterFunction(session, determinismEvaluator.isDeterministic(predicate), (Predicate)predicateCompiler.compilePredicate(predicate).get())).collect(ImmutableList.toImmutableList());
    }

    private static Set<Integer> extractInputs(RowExpression expression) {
        ImmutableSet.Builder inputs = ImmutableSet.builder();
        expression.accept((RowExpressionVisitor)new InputReferenceBuilderVisitor(), (Object)inputs);
        return inputs.build();
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }

    private static /* synthetic */ HiveColumnHandle lambda$toOrcPredicate$14(Map columnsByName, Subfield subfield) {
        return OrcSelectivePageSourceFactory.isEntireColumn(subfield) ? (HiveColumnHandle)columnsByName.get(subfield.getRootName()) : null;
    }

    private static class InputReferenceBuilderVisitor
    extends DefaultRowExpressionTraversalVisitor<ImmutableSet.Builder<Integer>> {
        private InputReferenceBuilderVisitor() {
        }

        public Void visitInputReference(InputReferenceExpression input, ImmutableSet.Builder<Integer> builder) {
            builder.add((Object)input.getField());
            return null;
        }
    }

    private static final class RequiredSubfieldsExtractor
    extends DefaultRowExpressionTraversalVisitor<ImmutableSet.Builder<Subfield>> {
        private final SubfieldExtractor subfieldExtractor;

        public RequiredSubfieldsExtractor(SubfieldExtractor subfieldExtractor) {
            this.subfieldExtractor = Objects.requireNonNull(subfieldExtractor, "subfieldExtractor is null");
        }

        public Void visitCall(CallExpression call, ImmutableSet.Builder<Subfield> context) {
            Optional<Subfield> subfield = this.subfieldExtractor.extract((RowExpression)call);
            if (subfield.isPresent()) {
                if (!OrcSelectivePageSourceFactory.isEntireColumn(subfield)) {
                    context.add((Object)subfield.get());
                }
                return null;
            }
            call.getArguments().forEach(argument -> {
                Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
            });
            return null;
        }

        public Void visitSpecialForm(SpecialFormExpression specialForm, ImmutableSet.Builder<Subfield> context) {
            Optional<Subfield> subfield = this.subfieldExtractor.extract((RowExpression)specialForm);
            if (subfield.isPresent()) {
                if (!OrcSelectivePageSourceFactory.isEntireColumn(subfield)) {
                    context.add((Object)subfield.get());
                }
                return null;
            }
            specialForm.getArguments().forEach(argument -> {
                Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
            });
            return null;
        }
    }
}

