/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.AbstractIterator;
import io.airlift.stats.TimeStat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class HiveFileIterator
extends AbstractIterator<LocatedFileStatus> {
    private final Deque<Path> paths = new ArrayDeque<Path>();
    private final ListDirectoryOperation listDirectoryOperation;
    private final NamenodeStats namenodeStats;
    private final NestedDirectoryPolicy nestedDirectoryPolicy;
    private Iterator<LocatedFileStatus> remoteIterator = Collections.emptyIterator();

    public HiveFileIterator(Path path, ListDirectoryOperation listDirectoryOperation, NamenodeStats namenodeStats, NestedDirectoryPolicy nestedDirectoryPolicy) {
        this.paths.addLast(Objects.requireNonNull(path, "path is null"));
        this.listDirectoryOperation = Objects.requireNonNull(listDirectoryOperation, "listDirectoryOperation is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.nestedDirectoryPolicy = Objects.requireNonNull(nestedDirectoryPolicy, "nestedDirectoryPolicy is null");
    }

    protected LocatedFileStatus computeNext() {
        block5: while (true) {
            if (this.remoteIterator.hasNext()) {
                LocatedFileStatus status = this.getLocatedFileStatus(this.remoteIterator);
                String fileName = status.getPath().getName();
                if (fileName.startsWith("_") || fileName.startsWith(".")) continue;
                if (status.isDirectory()) {
                    switch (this.nestedDirectoryPolicy) {
                        case IGNORED: {
                            continue block5;
                        }
                        case RECURSE: {
                            this.paths.add(status.getPath());
                            continue block5;
                        }
                        case FAIL: {
                            throw new NestedDirectoryNotAllowedException();
                        }
                    }
                }
                return status;
            }
            if (this.paths.isEmpty()) {
                return (LocatedFileStatus)this.endOfData();
            }
            this.remoteIterator = this.getLocatedFileStatusRemoteIterator(this.paths.removeFirst());
        }
    }

    private Iterator<LocatedFileStatus> getLocatedFileStatusRemoteIterator(Path path) {
        try (TimeStat.BlockTimer ignored = this.namenodeStats.getListLocatedStatus().time();){
            FileStatusIterator fileStatusIterator = new FileStatusIterator(path, this.listDirectoryOperation, this.namenodeStats);
            return fileStatusIterator;
        }
    }

    private LocatedFileStatus getLocatedFileStatus(Iterator<LocatedFileStatus> iterator) {
        try (TimeStat.BlockTimer ignored = this.namenodeStats.getRemoteIteratorNext().time();){
            LocatedFileStatus locatedFileStatus = iterator.next();
            return locatedFileStatus;
        }
    }

    public static interface ListDirectoryOperation {
        public RemoteIterator<LocatedFileStatus> list(Path var1) throws IOException;
    }

    public static class NestedDirectoryNotAllowedException
    extends RuntimeException {
        public NestedDirectoryNotAllowedException() {
            super("Nested sub-directories are not allowed");
        }
    }

    private static class FileStatusIterator
    implements Iterator<LocatedFileStatus> {
        private final Path path;
        private final NamenodeStats namenodeStats;
        private final RemoteIterator<LocatedFileStatus> fileStatusIterator;

        private FileStatusIterator(Path path, ListDirectoryOperation listDirectoryOperation, NamenodeStats namenodeStats) {
            this.path = path;
            this.namenodeStats = namenodeStats;
            try {
                this.fileStatusIterator = listDirectoryOperation.list(path);
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.fileStatusIterator.hasNext();
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        @Override
        public LocatedFileStatus next() {
            try {
                return (LocatedFileStatus)this.fileStatusIterator.next();
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        private PrestoException processException(IOException exception) {
            this.namenodeStats.getRemoteIteratorNext().recordException(exception);
            if (exception instanceof FileNotFoundException) {
                return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, "Partition location does not exist: " + this.path);
            }
            return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to list directory: " + this.path, (Throwable)exception);
        }
    }

    public static enum NestedDirectoryPolicy {
        IGNORED,
        RECURSE,
        FAIL;

    }
}

