/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.HiveSplitPartitionInfo;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.S3SelectPushdown;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.predicate.Domain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;

public class InternalHiveSplitFactory {
    private final FileSystem fileSystem;
    private final InputFormat<?, ?> inputFormat;
    private final Optional<Domain> pathDomain;
    private final boolean forceLocalScheduling;
    private final boolean s3SelectPushdownEnabled;
    private final HiveSplitPartitionInfo partitionInfo;
    private final boolean schedulerUsesHostAddresses;

    public InternalHiveSplitFactory(FileSystem fileSystem, InputFormat<?, ?> inputFormat, Optional<Domain> pathDomain, boolean forceLocalScheduling, boolean s3SelectPushdownEnabled, HiveSplitPartitionInfo partitionInfo, boolean schedulerUsesHostAddresses) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.pathDomain = Objects.requireNonNull(pathDomain, "pathDomain is null");
        this.forceLocalScheduling = forceLocalScheduling;
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        this.partitionInfo = partitionInfo;
        this.schedulerUsesHostAddresses = schedulerUsesHostAddresses;
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(LocatedFileStatus status, boolean splittable) {
        return this.createInternalHiveSplit(status, OptionalInt.empty(), OptionalInt.empty(), splittable);
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(LocatedFileStatus status, int readBucketNumber, int tableBucketNumber, boolean splittable) {
        return this.createInternalHiveSplit(status, OptionalInt.of(readBucketNumber), OptionalInt.of(tableBucketNumber), splittable);
    }

    private Optional<InternalHiveSplit> createInternalHiveSplit(LocatedFileStatus status, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable) {
        splittable = splittable && HiveUtil.isSplittable(this.inputFormat, this.fileSystem, status.getPath());
        return this.createInternalHiveSplit(status.getPath(), status.getBlockLocations(), 0L, status.getLen(), status.getLen(), readBucketNumber, tableBucketNumber, splittable);
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(FileSplit split) throws IOException {
        FileStatus file = this.fileSystem.getFileStatus(split.getPath());
        return this.createInternalHiveSplit(split.getPath(), this.fileSystem.getFileBlockLocations(file, split.getStart(), split.getLength()), split.getStart(), split.getLength(), file.getLen(), OptionalInt.empty(), OptionalInt.empty(), false);
    }

    private Optional<InternalHiveSplit> createInternalHiveSplit(Path path, BlockLocation[] blockLocations, long start, long length, long fileSize, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable) {
        String pathString = path.toString();
        if (!InternalHiveSplitFactory.pathMatchesPredicate(this.pathDomain, pathString)) {
            return Optional.empty();
        }
        boolean forceLocalScheduling = this.forceLocalScheduling;
        if (fileSize == 0L && blockLocations.length == 0) {
            blockLocations = new BlockLocation[]{new BlockLocation()};
            forceLocalScheduling = false;
        }
        ImmutableList.Builder blockBuilder = ImmutableList.builder();
        for (BlockLocation blockLocation : blockLocations) {
            long blockEnd;
            long blockStart = Math.max(start, blockLocation.getOffset());
            if (blockStart > (blockEnd = Math.min(start + length, blockLocation.getOffset() + blockLocation.getLength())) || blockStart == blockEnd && (blockStart != start || blockEnd != start + length)) continue;
            ImmutableList addresses = InternalHiveSplitFactory.getHostAddresses(blockLocation);
            if (!this.needsHostAddresses(forceLocalScheduling, (List<HostAddress>)addresses)) {
                addresses = ImmutableList.of();
            }
            blockBuilder.add((Object)new InternalHiveSplit.InternalHiveBlock(blockEnd, (List<HostAddress>)addresses));
        }
        ImmutableList blocks = blockBuilder.build();
        InternalHiveSplitFactory.checkBlocks((List<InternalHiveSplit.InternalHiveBlock>)blocks, start, length);
        if (!splittable) {
            ImmutableList addresses = ((InternalHiveSplit.InternalHiveBlock)blocks.get(0)).getAddresses();
            if (!this.needsHostAddresses(forceLocalScheduling, (List<HostAddress>)addresses)) {
                addresses = ImmutableList.of();
            }
            blocks = ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(start + length, (List<HostAddress>)addresses));
        }
        URI relativePath = this.partitionInfo.getPath().relativize(path.toUri());
        return Optional.of(new InternalHiveSplit(relativePath.toString(), start, start + length, length, (List<InternalHiveSplit.InternalHiveBlock>)blocks, readBucketNumber, tableBucketNumber, splittable, forceLocalScheduling && InternalHiveSplitFactory.allBlocksHaveRealAddress((List<InternalHiveSplit.InternalHiveBlock>)blocks), this.s3SelectPushdownEnabled && S3SelectPushdown.isCompressionCodecSupported(this.inputFormat, path), this.partitionInfo));
    }

    private boolean needsHostAddresses(boolean forceLocalScheduling, List<HostAddress> addresses) {
        return this.schedulerUsesHostAddresses || forceLocalScheduling && InternalHiveSplitFactory.hasRealAddress(addresses);
    }

    private static void checkBlocks(List<InternalHiveSplit.InternalHiveBlock> blocks, long start, long length) {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((start + length == blocks.get(blocks.size() - 1).getEnd() ? 1 : 0) != 0);
    }

    private static boolean allBlocksHaveRealAddress(List<InternalHiveSplit.InternalHiveBlock> blocks) {
        return blocks.stream().map(InternalHiveSplit.InternalHiveBlock::getAddresses).allMatch(InternalHiveSplitFactory::hasRealAddress);
    }

    private static boolean hasRealAddress(List<HostAddress> addresses) {
        return addresses.stream().anyMatch(address -> !address.getHostText().equals("localhost"));
    }

    private static List<HostAddress> getHostAddresses(BlockLocation blockLocation) {
        String[] hosts;
        try {
            hosts = blockLocation.getHosts();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (List)Arrays.stream(hosts).map(HostAddress::fromString).collect(ImmutableList.toImmutableList());
    }

    private static boolean pathMatchesPredicate(Optional<Domain> pathDomain, String path) {
        if (!pathDomain.isPresent()) {
            return true;
        }
        return pathDomain.get().includesNullableValue((Object)Slices.utf8Slice((String)path));
    }
}

