/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.json;

import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.Base64Variant;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.JsonParseException;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.JsonParser;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.JsonToken;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.ObjectCodec;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.base.ParserBase;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.io.CharTypes;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.io.IOContext;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class ReaderBasedJsonParser
extends ParserBase {
    protected Reader _reader;
    protected char[] _inputBuffer;
    protected ObjectCodec _objectCodec;
    protected final CharsToNameCanonicalizer _symbols;
    protected final int _hashSeed;
    protected boolean _tokenIncomplete = false;

    public ReaderBasedJsonParser(IOContext iOContext, int n, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer) {
        super(iOContext, n);
        this._reader = reader;
        this._inputBuffer = iOContext.allocTokenBuffer();
        this._objectCodec = objectCodec;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public int releaseBuffered(Writer writer) throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n < 1) {
            return 0;
        }
        int n2 = this._inputPtr;
        writer.write(this._inputBuffer, n2, n);
        return n;
    }

    @Override
    public Object getInputSource() {
        return this._reader;
    }

    @Override
    protected boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        if (this._reader != null) {
            int n = this._reader.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n > 0) {
                this._inputPtr = 0;
                this._inputEnd = n;
                return true;
            }
            this._closeInput();
            if (n == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
            }
        }
        return false;
    }

    protected char getNextChar(String string) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(string);
        }
        return this._inputBuffer[this._inputPtr++];
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._reader != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._reader.close();
            }
            this._reader = null;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        super._releaseBuffers();
        char[] cArray = this._inputBuffer;
        if (cArray != null) {
            this._inputBuffer = null;
            this._ioContext.releaseTokenBuffer(cArray);
        }
    }

    @Override
    public String getText() throws IOException, JsonParseException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(jsonToken);
    }

    @Override
    public String getValueAsString() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(string);
    }

    protected String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken) {
            case FIELD_NAME: {
                return this._parsingContext.getCurrentName();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n);
                        } else if (this._nameCopyBuffer.length < n) {
                            this._nameCopyBuffer = new char[n];
                        }
                        string.getChars(0, n, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return 0;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException, JsonParseException {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n = this._readBinary(base64Variant, outputStream, byArray);
            return n;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) throws IOException, JsonParseException {
        int n = 0;
        int n2 = byArray.length - 3;
        int n3 = 0;
        while (true) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n4 = base64Variant.decodeBase64Char(c);
            if (n4 < 0) {
                if (c == '\"') break;
                n4 = this._decodeBase64Escape(base64Variant, c, 0);
                if (n4 < 0) continue;
            }
            if (n > n2) {
                n3 += n;
                outputStream.write(byArray, 0, n);
                n = 0;
            }
            int n5 = n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                n4 = this._decodeBase64Escape(base64Variant, c, 1);
            }
            n5 = n5 << 6 | n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n4 != -2) {
                    if (c == '\"' && !base64Variant.usesPadding()) {
                        byArray[n++] = (byte)(n5 >>= 4);
                        break;
                    }
                    n4 = this._decodeBase64Escape(base64Variant, c, 2);
                }
                if (n4 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c = this._inputBuffer[this._inputPtr++])) {
                        throw this.reportInvalidBase64Char(base64Variant, c, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n++] = (byte)(n5 >>= 4);
                    continue;
                }
            }
            n5 = n5 << 6 | n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n4 != -2) {
                    if (c == '\"' && !base64Variant.usesPadding()) {
                        byArray[n++] = (byte)((n5 >>= 2) >> 8);
                        byArray[n++] = (byte)n5;
                        break;
                    }
                    n4 = this._decodeBase64Escape(base64Variant, c, 3);
                }
                if (n4 == -2) {
                    byArray[n++] = (byte)((n5 >>= 2) >> 8);
                    byArray[n++] = (byte)n5;
                    continue;
                }
            }
            n5 = n5 << 6 | n4;
            byArray[n++] = (byte)(n5 >> 16);
            byArray[n++] = (byte)(n5 >> 8);
            byArray[n++] = (byte)n5;
        }
        this._tokenIncomplete = false;
        if (n > 0) {
            n3 += n;
            outputStream.write(byArray, 0, n);
        }
        return n3;
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        Object object;
        boolean bl;
        int n;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n != 44) {
                this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n = this._skipWS();
        }
        if (bl = this._parsingContext.inObject()) {
            object = this._parseFieldName(n);
            this._parsingContext.setCurrentName((String)object);
            this._currToken = JsonToken.FIELD_NAME;
            n = this._skipWS();
            if (n != 58) {
                this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
            }
            n = this._skipWS();
        }
        switch (n) {
            case 34: {
                this._tokenIncomplete = true;
                object = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                object = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                object = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                object = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                object = this.parseNumberText(n);
                break;
            }
            default: {
                object = this._handleUnexpectedValue(n);
            }
        }
        if (bl) {
            this._nextToken = object;
            return this._currToken;
        }
        this._currToken = object;
        return object;
    }

    private JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public String nextTextValue() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    this._finishString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public int nextIntValue(int n) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n;
    }

    @Override
    public long nextLongValue(long l) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l;
    }

    @Override
    public Boolean nextBooleanValue() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        switch (this.nextToken()) {
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    /*
     * Unable to fully structure code
     */
    protected JsonToken parseNumberText(int var1_1) throws IOException, JsonParseException {
        block12: {
            block11: {
                var2_2 = var1_1 == 45;
                var3_3 = this._inputPtr;
                var4_4 = var3_3 - 1;
                var5_5 = this._inputEnd;
                if (!var2_2) break block11;
                if (var3_3 < this._inputEnd) {
                    if ((var1_1 = this._inputBuffer[var3_3++]) > 57 || var1_1 < 48) {
                        this._inputPtr = var3_3;
                        return this._handleInvalidNumberStart(var1_1, true);
                    } else {
                        ** GOTO lbl11
                    }
                }
                break block12;
            }
            if (var1_1 == 48) break block12;
            var6_6 = 1;
            block0: while (var3_3 < this._inputEnd) {
                if ((var1_1 = this._inputBuffer[var3_3++]) >= 48 && var1_1 <= 57) {
                    ++var6_6;
                    continue;
                }
                var7_7 = 0;
                if (var1_1 != 46) ** GOTO lbl26
                while (var3_3 < var5_5) {
                    if ((var1_1 = this._inputBuffer[var3_3++]) >= 48 && var1_1 <= 57) {
                        ++var7_7;
                        continue;
                    }
                    if (var7_7 == 0) {
                        this.reportUnexpectedNumberChar(var1_1, "Decimal point not followed by a digit");
                    }
lbl26:
                    // 4 sources

                    var8_8 = 0;
                    if (var1_1 == 101 || var1_1 == 69) {
                        if (var3_3 >= var5_5) break block0;
                        if ((var1_1 = this._inputBuffer[var3_3++]) == 45 || var1_1 == 43) {
                            if (var3_3 >= var5_5) break block0;
                            var1_1 = this._inputBuffer[var3_3++];
                        }
                        while (var1_1 <= 57 && var1_1 >= 48) {
                            ++var8_8;
                            if (var3_3 >= var5_5) break block0;
                            var1_1 = this._inputBuffer[var3_3++];
                        }
                        if (var8_8 == 0) {
                            this.reportUnexpectedNumberChar(var1_1, "Exponent indicator not followed by a digit");
                        }
                    }
                    this._inputPtr = --var3_3;
                    var9_9 = var3_3 - var4_4;
                    this._textBuffer.resetWithShared(this._inputBuffer, var4_4, var9_9);
                    return this.reset(var2_2, var6_6, var7_7, var8_8);
                }
                break block0;
            }
        }
        this._inputPtr = var2_2 != false ? var4_4 + 1 : var4_4;
        return this.parseNumberText2(var2_2);
    }

    private JsonToken parseNumberText2(boolean bl) throws IOException, JsonParseException {
        char c;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n = 0;
        if (bl) {
            cArray[n++] = 45;
        }
        int n2 = 0;
        char c2 = c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("No digit following minus sign");
        if (c == '0') {
            c = this._verifyNoLeadingZeroes();
        }
        boolean bl2 = false;
        while (c >= '0' && c <= '9') {
            ++n2;
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = c;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                c = '\u0000';
                bl2 = true;
                break;
            }
            c = this._inputBuffer[this._inputPtr++];
        }
        if (n2 == 0) {
            this.reportInvalidNumber("Missing integer part (next char " + ReaderBasedJsonParser._getCharDesc(c) + ")");
        }
        int n3 = 0;
        if (c == '.') {
            cArray[n++] = c;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                if ((c = this._inputBuffer[this._inputPtr++]) < '0' || c > '9') break;
                ++n3;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = c;
            }
            if (n3 == 0) {
                this.reportUnexpectedNumberChar(c, "Decimal point not followed by a digit");
            }
        }
        int n4 = 0;
        if (c == 'e' || c == 'E') {
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = c;
            char c3 = c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent");
            if (c == '-' || c == '+') {
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = c;
                char c4 = c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent");
            }
            while (c <= '9' && c >= '0') {
                ++n4;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = c;
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                c = this._inputBuffer[this._inputPtr++];
            }
            if (n4 == 0) {
                this.reportUnexpectedNumberChar(c, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl2) {
            --this._inputPtr;
        }
        this._textBuffer.setCurrentLength(n);
        return this.reset(bl, n2, n3, n4);
    }

    private char _verifyNoLeadingZeroes() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return '0';
        }
        char c = this._inputBuffer[this._inputPtr];
        if (c < '0' || c > '9') {
            return '0';
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (c == '0') {
            while (this._inputPtr < this._inputEnd || this.loadMore()) {
                c = this._inputBuffer[this._inputPtr];
                if (c < '0' || c > '9') {
                    return '0';
                }
                ++this._inputPtr;
                if (c == '0') continue;
                break;
            }
        }
        return c;
    }

    protected JsonToken _handleInvalidNumberStart(int n, boolean bl) throws IOException, JsonParseException {
        if (n == 73) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            if ((n = this._inputBuffer[this._inputPtr++]) == 78) {
                String string = bl ? "-INF" : "+INF";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            } else if (n == 110) {
                String string = bl ? "-Infinity" : "+Infinity";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            }
        }
        this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    protected String _parseFieldName(int n) throws IOException, JsonParseException {
        if (n != 34) {
            return this._handleUnusualFieldName(n);
        }
        int n2 = this._inputPtr;
        int n3 = this._hashSeed;
        int n4 = this._inputEnd;
        if (n2 < n4) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n5 = nArray.length;
            do {
                char c;
                if ((c = this._inputBuffer[n2]) < n5 && nArray[c] != 0) {
                    if (c != '\"') break;
                    int n6 = this._inputPtr;
                    this._inputPtr = n2 + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n6, n2 - n6, n3);
                }
                n3 = n3 * 33 + c;
            } while (++n2 < n4);
        }
        int n7 = this._inputPtr;
        this._inputPtr = n2;
        return this._parseFieldName2(n7, n3, 34);
    }

    private String _parseFieldName2(int n, int n2, int n3) throws IOException, JsonParseException {
        this._textBuffer.resetWithShared(this._inputBuffer, n, this._inputPtr - n);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n4 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing '" + (char)n3 + "' for name");
            }
            if ((c2 = (c = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c2 == '\\') {
                    c = this._decodeEscaped();
                } else if (c2 <= n3) {
                    if (c2 == n3) break;
                    if (c2 < ' ') {
                        this._throwUnquotedSpace(c2, "name");
                    }
                }
            }
            n2 = n2 * 33 + c2;
            cArray[n4++] = c;
            if (n4 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n4 = 0;
        }
        this._textBuffer.setCurrentLength(n4);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n5 = textBuffer.getTextOffset();
        int n6 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n5, n6, n2);
    }

    protected String _handleUnusualFieldName(int n) throws IOException, JsonParseException {
        int n2;
        int[] nArray;
        int n3;
        boolean bl;
        if (n == 39 && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseApostropheFieldName();
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            this._reportUnexpectedChar(n, "was expecting double-quote to start field name");
        }
        if (!(bl = n < (n3 = (nArray = CharTypes.getInputCodeLatin1JsNames()).length) ? nArray[n] == 0 && (n < 48 || n > 57) : Character.isJavaIdentifierPart((char)n))) {
            this._reportUnexpectedChar(n, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int n4 = this._inputPtr;
        int n5 = this._hashSeed;
        int n6 = this._inputEnd;
        if (n4 < n6) {
            do {
                if ((n2 = this._inputBuffer[n4]) < n3) {
                    if (nArray[n2] != 0) {
                        int n7 = this._inputPtr - 1;
                        this._inputPtr = n4;
                        return this._symbols.findSymbol(this._inputBuffer, n7, n4 - n7, n5);
                    }
                } else if (!Character.isJavaIdentifierPart((char)n2)) {
                    int n8 = this._inputPtr - 1;
                    this._inputPtr = n4;
                    return this._symbols.findSymbol(this._inputBuffer, n8, n4 - n8, n5);
                }
                n5 = n5 * 33 + n2;
            } while (++n4 < n6);
        }
        n2 = this._inputPtr - 1;
        this._inputPtr = n4;
        return this._parseUnusualFieldName2(n2, n5, nArray);
    }

    protected String _parseApostropheFieldName() throws IOException, JsonParseException {
        int n = this._inputPtr;
        int n2 = this._hashSeed;
        int n3 = this._inputEnd;
        if (n < n3) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n4 = nArray.length;
            do {
                char c;
                if ((c = this._inputBuffer[n]) == '\'') {
                    int n5 = this._inputPtr;
                    this._inputPtr = n + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n5, n - n5, n2);
                }
                if (c < n4 && nArray[c] != 0) break;
                n2 = n2 * 33 + c;
            } while (++n < n3);
        }
        int n6 = this._inputPtr;
        this._inputPtr = n;
        return this._parseFieldName2(n6, n2, 39);
    }

    protected JsonToken _handleUnexpectedValue(int n) throws IOException, JsonParseException {
        switch (n) {
            case 39: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._handleApostropheValue();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this._reportInvalidEOFInValue();
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++], false);
            }
        }
        this._reportUnexpectedChar(n, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    protected JsonToken _handleApostropheValue() throws IOException, JsonParseException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            if ((c2 = (c = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c2 == '\\') {
                    c = this._decodeEscaped();
                } else if (c2 <= '\'') {
                    if (c2 == '\'') break;
                    if (c2 < ' ') {
                        this._throwUnquotedSpace(c2, "string value");
                    }
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = c;
        }
        this._textBuffer.setCurrentLength(n);
        return JsonToken.VALUE_STRING;
    }

    private String _parseUnusualFieldName2(int n, int n2, int[] nArray) throws IOException, JsonParseException {
        char c;
        char c2;
        this._textBuffer.resetWithShared(this._inputBuffer, n, this._inputPtr - n);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n3 = this._textBuffer.getCurrentSegmentSize();
        int n4 = nArray.length;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && !((c2 = (c = this._inputBuffer[this._inputPtr])) <= n4 ? nArray[c2] != 0 : !Character.isJavaIdentifierPart(c))) {
            ++this._inputPtr;
            n2 = n2 * 33 + c2;
            cArray[n3++] = c;
            if (n3 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n3 = 0;
        }
        this._textBuffer.setCurrentLength(n3);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n5 = textBuffer.getTextOffset();
        int n6 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n5, n6, n2);
    }

    @Override
    protected void _finishString() throws IOException, JsonParseException {
        int n = this._inputPtr;
        int n2 = this._inputEnd;
        if (n < n2) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n3 = nArray.length;
            do {
                char c;
                if ((c = this._inputBuffer[n]) >= n3 || nArray[c] == 0) continue;
                if (c != '\"') break;
                this._textBuffer.resetWithShared(this._inputBuffer, this._inputPtr, n - this._inputPtr);
                this._inputPtr = n + 1;
                return;
            } while (++n < n2);
        }
        this._textBuffer.resetWithCopy(this._inputBuffer, this._inputPtr, n - this._inputPtr);
        this._inputPtr = n;
        this._finishString2();
    }

    protected void _finishString2() throws IOException, JsonParseException {
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            if ((c2 = (c = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c2 == '\\') {
                    c = this._decodeEscaped();
                } else if (c2 <= '\"') {
                    if (c2 == '\"') break;
                    if (c2 < ' ') {
                        this._throwUnquotedSpace(c2, "string value");
                    }
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = c;
        }
        this._textBuffer.setCurrentLength(n);
    }

    protected void _skipString() throws IOException, JsonParseException {
        this._tokenIncomplete = false;
        int n = this._inputPtr;
        int n2 = this._inputEnd;
        char[] cArray = this._inputBuffer;
        while (true) {
            char c;
            char c2;
            if (n >= n2) {
                this._inputPtr = n;
                if (!this.loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value");
                }
                n = this._inputPtr;
                n2 = this._inputEnd;
            }
            if ((c2 = (c = cArray[n++])) > '\\') continue;
            if (c2 == '\\') {
                this._inputPtr = n;
                c = this._decodeEscaped();
                n = this._inputPtr;
                n2 = this._inputEnd;
                continue;
            }
            if (c2 > '\"') continue;
            if (c2 == '\"') break;
            if (c2 >= ' ') continue;
            this._inputPtr = n;
            this._throwUnquotedSpace(c2, "string value");
        }
        this._inputPtr = n;
    }

    protected void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected void _skipLF() throws IOException {
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int _skipWS() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c != '/') {
                    return c;
                }
                this._skipComment();
                continue;
            }
            if (c == ' ') continue;
            if (c == '\n') {
                this._skipLF();
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private int _skipWSOrEnd() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c == '/') {
                    this._skipComment();
                    continue;
                }
                return c;
            }
            if (c == ' ') continue;
            if (c == '\n') {
                this._skipLF();
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        this._handleEOF();
        return -1;
    }

    private void _skipComment() throws IOException, JsonParseException {
        char c;
        if (!this.isEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '/') {
            this._skipCppComment();
        } else if (c == '*') {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(c, "was expecting either '*' or '/' for a comment");
        }
    }

    private void _skipCComment() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > '*') continue;
            if (c == '*') {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) break;
                if (this._inputBuffer[this._inputPtr] != '/') continue;
                ++this._inputPtr;
                return;
            }
            if (c >= ' ') continue;
            if (c == '\n') {
                this._skipLF();
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        this._reportInvalidEOF(" in a comment");
    }

    private void _skipCppComment() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) >= ' ') continue;
            if (c == '\n') {
                this._skipLF();
                break;
            }
            if (c == '\r') {
                this._skipCR();
                break;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        char c = this._inputBuffer[this._inputPtr++];
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '/': 
            case '\\': {
                return c;
            }
            case 'u': {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape(c);
            }
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            char c2;
            int n2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            if ((n2 = CharTypes.charToHex(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(c2, "expected a hex-digit for character escape sequence");
            }
            n = n << 4 | n2;
        }
        return (char)n;
    }

    protected void _matchToken(String string, int n) throws IOException, JsonParseException {
        int n2 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidToken(string.substring(0, n));
            }
            if (this._inputBuffer[this._inputPtr] != string.charAt(n)) {
                this._reportInvalidToken(string.substring(0, n));
            }
            ++this._inputPtr;
        } while (++n < n2);
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return;
        }
        char c = this._inputBuffer[this._inputPtr];
        if (c < '0' || c == ']' || c == '}') {
            return;
        }
        if (Character.isJavaIdentifierPart(c)) {
            this._reportInvalidToken(string.substring(0, n));
        }
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException, JsonParseException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n = base64Variant.decodeBase64Char(c);
            if (n < 0) {
                if (c == '\"') {
                    return byteArrayBuilder.toByteArray();
                }
                n = this._decodeBase64Escape(base64Variant, c, 0);
                if (n < 0) continue;
            }
            int n2 = n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                n = this._decodeBase64Escape(base64Variant, c, 1);
            }
            n2 = n2 << 6 | n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n != -2) {
                    if (c == '\"' && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n2 >>= 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n = this._decodeBase64Escape(base64Variant, c, 2);
                }
                if (n == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c = this._inputBuffer[this._inputPtr++])) {
                        throw this.reportInvalidBase64Char(base64Variant, c, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n2 >>= 4);
                    continue;
                }
            }
            n2 = n2 << 6 | n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n != -2) {
                    if (c == '\"' && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n2 >>= 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n = this._decodeBase64Escape(base64Variant, c, 3);
                }
                if (n == -2) {
                    byteArrayBuilder.appendTwoBytes(n2 >>= 2);
                    continue;
                }
            }
            n2 = n2 << 6 | n;
            byteArrayBuilder.appendThreeBytes(n2);
        }
    }

    protected void _reportInvalidToken(String string) throws IOException, JsonParseException {
        this._reportInvalidToken(string, "'null', 'true', 'false' or NaN");
    }

    protected void _reportInvalidToken(String string, String string2) throws IOException, JsonParseException {
        char c;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && Character.isJavaIdentifierPart(c = this._inputBuffer[this._inputPtr])) {
            ++this._inputPtr;
            stringBuilder.append(c);
        }
        this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting ");
    }
}

